/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.chargen;

import de.rpgframework.character.Attachment;
import de.rpgframework.character.CharacterHandle;
import de.rpgframework.character.CharacterProvider;
import de.rpgframework.character.CharacterProviderLoader;
import de.rpgframework.character.ProcessingStep;
import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.core.BabylonEventBus;
import de.rpgframework.core.BabylonEventType;
import de.rpgframework.genericrpg.ToDoElement;
import de.rpgframework.genericrpg.chargen.BasicControllerEvents;
import de.rpgframework.genericrpg.chargen.CharacterController;
import de.rpgframework.genericrpg.chargen.ControllerEvent;
import de.rpgframework.genericrpg.chargen.ControllerListener;
import de.rpgframework.genericrpg.chargen.DataSetMode;
import de.rpgframework.genericrpg.chargen.IRecommender;
import de.rpgframework.genericrpg.chargen.LevellingProfileController;
import de.rpgframework.genericrpg.chargen.PartialController;
import de.rpgframework.genericrpg.data.CommonCharacter;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataSet;
import de.rpgframework.genericrpg.data.IAttribute;
import de.rpgframework.genericrpg.data.RuleController;
import de.rpgframework.genericrpg.modification.Modification;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public abstract class CharacterControllerImpl<A extends IAttribute, M extends RuleSpecificCharacterObject<A, ?, ?, ?>>
implements CharacterController<A, M> {
    private static final System.Logger logger = System.getLogger(CharacterControllerImpl.class.getPackageName() + ".main");
    protected M model;
    protected CharacterHandle handle;
    protected RuleController ruleCtrl;
    protected LevellingProfileController profileCtrl;
    protected Optional<IRecommender<A>> recommender;
    protected Locale locale = Locale.getDefault();
    private Collection<ControllerListener> listener = new ArrayList<ControllerListener>();
    protected List<ProcessingStep> processChain = new ArrayList<ProcessingStep>();
    protected boolean dontProcess;
    private List<Modification> unitTestModifications = new ArrayList<Modification>();
    protected boolean allowRunProcessor = true;

    protected CharacterControllerImpl() {
        this.recommender = Optional.empty();
    }

    protected CharacterControllerImpl(M model, CharacterHandle handle) {
        this();
        this.model = model;
        this.handle = handle;
        this.recommender = Optional.empty();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public boolean showDataItem(DataItem item) {
        if (item.getLanguage() != null && !this.locale.getLanguage().equals(item.getLanguage())) {
            return false;
        }
        if (item.getLanguage() == null && item.hasLanguageAlternative(this.locale.getLanguage())) {
            return false;
        }
        if (this.model instanceof CommonCharacter) {
            CommonCharacter.DataSetControl dsCtrl = ((CommonCharacter)this.model).getDataSets();
            if (dsCtrl.mode == DataSetMode.SELECTED) {
                boolean found = false;
                for (DataSet set : item.getAssignedDataSets()) {
                    if (!dsCtrl.selected.contains(set.getID()) && !set.getID().equalsIgnoreCase("CORE")) continue;
                    found = true;
                }
                if (!found) {
                    return false;
                }
            }
        }
        return true;
    }

    public void addUnitTestModification(Modification mod) {
        this.unitTestModifications.add(mod);
        this.runProcessors();
    }

    public void removeUnitTestModification(Modification mod) {
        this.unitTestModifications.remove(mod);
        this.runProcessors();
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    public void setModel(M data) {
        this.model = data;
    }

    @Override
    public void addListener(ControllerListener callback) {
        if (!this.listener.contains(callback)) {
            this.listener.add(callback);
        }
    }

    @Override
    public void removeListener(ControllerListener callback) {
        this.listener.remove(callback);
    }

    @Override
    public boolean hasListener(ControllerListener callback) {
        return this.listener.contains(callback);
    }

    @Override
    public Collection<ControllerListener> getListener() {
        return this.listener;
    }

    @Override
    public void fireEvent(ControllerEvent type, Object ... param) {
        logger.log(System.Logger.Level.WARNING, "########" + String.valueOf(type) + " to " + this.listener.size() + " listeners of " + String.valueOf(this.getClass()));
        System.err.println("CharacterControllerImpl########" + String.valueOf(type) + " to " + this.listener.size() + " listeners of " + String.valueOf(this.getClass()));
        if (this.listener.size() == 0) {
            logger.log(System.Logger.Level.ERROR, "No listeners for character controller - that can only be an error");
            System.err.println("CharacterControllerImpl: No listeners for character controller - that can only be an error");
        }
        for (ControllerListener callback : new ArrayList<ControllerListener>(this.listener)) {
            try {
                callback.handleControllerEvent(type, param);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error delivering generation event", (Throwable)e);
            }
        }
        if (type == BasicControllerEvents.CHARACTER_PROFILES_CHANGED) {
            this.recommender.ifPresent(r -> r.update());
        }
    }

    @Override
    public RuleController getRuleController() {
        return this.ruleCtrl;
    }

    @Override
    public LevellingProfileController getProfileController() {
        return this.profileCtrl;
    }

    @Override
    public List<ToDoElement> getToDos() {
        ArrayList<ToDoElement> ret = new ArrayList<ToDoElement>();
        if (this.model == null) {
            return ret;
        }
        for (ProcessingStep step : this.processChain) {
            if (!(step instanceof PartialController)) continue;
            ret.addAll(((PartialController)step).getToDos());
        }
        Collections.sort(ret, new Comparator<ToDoElement>(){

            @Override
            public int compare(ToDoElement o1, ToDoElement o2) {
                return Integer.compare(o1.getSeverity().ordinal(), o2.getSeverity().ordinal());
            }
        });
        return ret;
    }

    @Override
    public void setAllowRunProcessor(boolean value) {
        this.allowRunProcessor = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runProcessors() {
        if (this.dontProcess || !this.allowRunProcessor) {
            return;
        }
        try {
            this.dontProcess = true;
            logger.log(System.Logger.Level.DEBUG, "\n\nSTART: runProcessors: " + this.processChain.size() + "-------------------------------------------------------");
            List<Modification> unprocessed = new ArrayList<Modification>(this.unitTestModifications);
            for (ProcessingStep processor : this.processChain) {
                if (processor == null) {
                    logger.log(System.Logger.Level.ERROR, "Found NULL in processChain");
                    continue;
                }
                try {
                    unprocessed = processor.process(unprocessed);
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Exception in processor " + String.valueOf(processor.getClass()), (Throwable)e);
                    BabylonEventBus.fireEvent((BabylonEventType)BabylonEventType.UI_MESSAGE, (Object[])new Object[]{2, "Error calculating character", e});
                }
                logger.log(System.Logger.Level.WARNING, "------ after {0}:\t {1}", processor.getClass().getSimpleName(), unprocessed);
            }
            logger.log(System.Logger.Level.DEBUG, "Remaining mods  = " + String.valueOf(unprocessed));
            logger.log(System.Logger.Level.INFO, "ToDos = " + String.valueOf(this.getToDos()));
            logger.log(System.Logger.Level.WARNING, "STOP : runProcessors: " + this.processChain.size() + "-------------------------------------------------------");
            this.fireEvent(BasicControllerEvents.CHARACTER_CHANGED, this.model);
        }
        finally {
            this.dontProcess = false;
        }
    }

    @Override
    public boolean save(byte[] data) throws IOException {
        logger.log(System.Logger.Level.DEBUG, "save called for handle {0} and char {0}", this.handle, this.model.getName());
        CharacterProvider prov = CharacterProviderLoader.getCharacterProvider();
        if (this.handle != null) {
            logger.log(System.Logger.Level.DEBUG, "handle already exists");
            boolean modelNeedsSaving = true;
            boolean imageNeedsSaving = true;
            for (Attachment attach : prov.listAttachments(this.handle)) {
                if (attach.getType() == Attachment.Type.CHARACTER && attach.getFormat() == Attachment.Format.RULESPECIFIC) {
                    attach.setData(data);
                    logger.log(System.Logger.Level.INFO, "Update character file");
                    prov.modifyAttachment(this.handle, attach);
                    modelNeedsSaving = false;
                }
                if (attach.getType() != Attachment.Type.CHARACTER || attach.getFormat() != Attachment.Format.IMAGE) continue;
                if (this.model.getImage() != null) {
                    attach.setData(this.model.getImage());
                    logger.log(System.Logger.Level.INFO, "Update character image");
                    prov.modifyAttachment(this.handle, attach);
                } else {
                    logger.log(System.Logger.Level.INFO, "Delete character image, since not present in model anymore");
                    prov.deleteAttachment(this.handle, attach);
                }
                imageNeedsSaving = false;
            }
            if (modelNeedsSaving) {
                prov.addAttachment(this.handle, Attachment.Type.CHARACTER, Attachment.Format.RULESPECIFIC, this.handle.getName(), data);
            }
            if (imageNeedsSaving && this.model.getImage() != null) {
                prov.addAttachment(this.handle, Attachment.Type.CHARACTER, Attachment.Format.IMAGE, this.handle.getName(), this.model.getImage());
            }
            return true;
        }
        logger.log(System.Logger.Level.DEBUG, "handle does not exist yet");
        this.handle = prov.getCharacter(this.model.getName(), this.model.getRules());
        if (this.handle != null) {
            logger.log(System.Logger.Level.WARNING, "Trying to overwrite existing character with this one");
            return false;
        }
        this.handle = prov.createCharacter(this.model.getName(), this.model.getRules());
        if (this.handle == null) {
            throw new IOException("Failed: No character handle");
        }
        if (this.handle.getUUID() == null) {
            throw new IOException("Failed: No UUID in character handle");
        }
        prov.addAttachment(this.handle, Attachment.Type.CHARACTER, Attachment.Format.RULESPECIFIC, this.model.getName() + ".xml", data);
        if (this.model.getImage() != null) {
            prov.addAttachment(this.handle, Attachment.Type.CHARACTER, Attachment.Format.IMAGE, this.model.getName() + ".img", this.model.getImage());
        }
        return true;
    }

    @Override
    public Optional<IRecommender<A>> getRecommender() {
        return this.recommender;
    }

    public void setRecommender(IRecommender<A> recommender) {
        this.recommender = Optional.ofNullable(recommender);
    }
}

