/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.chargen.ai;

import de.rpgframework.genericrpg.chargen.RecommendationState;
import de.rpgframework.genericrpg.chargen.ai.RecommendationCache;
import de.rpgframework.genericrpg.chargen.ai.Weight;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.IAttribute;
import de.rpgframework.genericrpg.data.OneAttributeSkill;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.RecommendationModification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Recommender {
    private static System.Logger logger = System.getLogger(Recommender.class.getPackageName());
    private List<RecommendationModification> recommendations = new ArrayList<RecommendationModification>();
    private Map<String, Map<DataItem, RecommendationCache<? extends DataItem>>> mapsByType = new HashMap<String, Map<DataItem, RecommendationCache<? extends DataItem>>>();
    private Map<IAttribute, RecommendationCache<IAttribute>> mapByAttribute = new HashMap<IAttribute, RecommendationCache<IAttribute>>();

    public void clearConfiguration() {
        this.recommendations.clear();
        this.mapsByType.clear();
        this.mapByAttribute.clear();
    }

    public void addConfiguration(List<Modification> mods) {
        for (Modification tmp : mods) {
            Object item;
            RecommendationModification mod = (RecommendationModification)tmp;
            this.recommendations.add(mod);
            if (mod.getResolvedKey() instanceof DataItem) {
                item = (DataItem)mod.getResolvedKey();
                String typeKey = ((DataItem)item).getTypeString();
                Map<DataItem, RecommendationCache<? extends DataItem>> map = this.mapsByType.get(typeKey);
                if (map == null) {
                    map = new HashMap<DataItem, RecommendationCache<? extends DataItem>>();
                    this.mapsByType.put(typeKey, map);
                }
                RecommendationCache<Object> newCache = new RecommendationCache<Object>(item, mod.getWeight());
                RecommendationCache<? extends DataItem> oldCache = map.get(item);
                if (oldCache == null) {
                    map.put((DataItem)item, newCache);
                    logger.log(System.Logger.Level.INFO, "Recommend {0}:{1} with level {2}", new Object[]{typeKey, ((DataItem)item).getId(), newCache.getLevel()});
                } else {
                    Weight old = oldCache.getLevel();
                    oldCache.merge(newCache);
                    logger.log(System.Logger.Level.INFO, "Recommendation {0}:{1} upgraded from {2} to {3}", new Object[]{typeKey, ((DataItem)item).getId(), old, newCache.getLevel()});
                }
                this.calculateDerivedeffects(mod, (DataItem)item);
                continue;
            }
            if (!(mod.getResolvedKey() instanceof IAttribute)) continue;
            item = (IAttribute)mod.getResolvedKey();
            RecommendationCache<Object> newCache = new RecommendationCache<Object>(item, mod.getWeight());
            RecommendationCache<IAttribute> oldCache = this.mapByAttribute.get(item);
            if (oldCache == null) {
                logger.log(System.Logger.Level.INFO, "Recommend attribute {0} with level {1}", new Object[]{item, newCache.getLevel()});
                this.mapByAttribute.put((IAttribute)item, newCache);
                continue;
            }
            Weight old = oldCache.getLevel();
            oldCache.merge(newCache);
            logger.log(System.Logger.Level.INFO, "Recommend attribute {0} upgraded from {1} to {2}", new Object[]{item, old, newCache.getLevel()});
        }
    }

    public void calculateDerivedeffects(RecommendationModification mod, DataItem resolved) {
        if (resolved instanceof OneAttributeSkill) {
            OneAttributeSkill skill = (OneAttributeSkill)resolved;
            Weight level = mod.getWeight();
            if (level.ordinal() > 1) {
                level = Weight.values()[level.ordinal() - 1];
            }
            RecommendationCache newCache = new RecommendationCache(skill.getAttribute(), level);
            RecommendationCache<IAttribute> oldCache = this.mapByAttribute.get(skill.getAttribute());
            if (oldCache == null) {
                logger.log(System.Logger.Level.INFO, "Recommend attribute {0} with level {1}", new Object[]{skill.getAttribute(), newCache.getLevel()});
                this.mapByAttribute.put((IAttribute)skill.getAttribute(), newCache);
            } else {
                Weight old = oldCache.getLevel();
                oldCache.merge(newCache);
                logger.log(System.Logger.Level.INFO, "Recommend attribute {0} upgraded from {1} to {2}", new Object[]{skill.getAttribute(), old, newCache.getLevel()});
            }
        }
    }

    public RecommendationState getRecommendationState(DataItem key) {
        RecommendationCache<? extends DataItem> cache;
        String typeKey = key.getTypeString();
        Map<DataItem, RecommendationCache<? extends DataItem>> map = this.mapsByType.get(typeKey);
        if (map != null && (cache = map.get(key)) != null) {
            switch (cache.getLevel()) {
                case NOT_RECOMMENDED: {
                    return RecommendationState.UNRECOMMENDED;
                }
                case HOBBY: {
                    return RecommendationState.NEUTRAL;
                }
                case GOOD: 
                case VERY_GOOD: {
                    return RecommendationState.RECOMMENDED;
                }
                case MASTER: 
                case INSANE: {
                    return RecommendationState.STRONGLY_RECOMMENDED;
                }
            }
        }
        return RecommendationState.NEUTRAL;
    }

    public RecommendationState getRecommendationState(IAttribute key) {
        RecommendationCache<IAttribute> cache = this.mapByAttribute.get(key);
        if (cache != null) {
            switch (cache.getLevel()) {
                case NOT_RECOMMENDED: {
                    return RecommendationState.UNRECOMMENDED;
                }
                case HOBBY: {
                    return RecommendationState.NEUTRAL;
                }
                case GOOD: 
                case VERY_GOOD: {
                    return RecommendationState.RECOMMENDED;
                }
                case MASTER: 
                case INSANE: {
                    return RecommendationState.STRONGLY_RECOMMENDED;
                }
            }
        }
        return RecommendationState.NEUTRAL;
    }
}

