/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.genericrpg.ModifyableNumericalValue;
import de.rpgframework.genericrpg.NumericalValue;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.ChoiceOption;
import de.rpgframework.genericrpg.data.CommonCharacter;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataItemValue;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.data.DecisionContainer;
import de.rpgframework.genericrpg.data.IAttribute;
import de.rpgframework.genericrpg.data.ReferenceException;
import de.rpgframework.genericrpg.items.CarriedItem;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import de.rpgframework.genericrpg.modification.RelevanceModification;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.prelle.simplepersist.Attribute;
import org.prelle.simplepersist.ElementList;

public class ComplexDataItemValue<T extends ComplexDataItem>
extends DataItemValue<T>
implements NumericalValue<T>,
DecisionContainer {
    private static final System.Logger logger = System.getLogger(ComplexDataItemValue.class.getPackageName());
    @ElementList(entry="decision", type=Decision.class, inline=true)
    protected List<Decision> decisions = new ArrayList<Decision>();
    @ElementList(entry="flag", type=String.class, inline=true)
    protected List<String> flags = new ArrayList<String>();
    @Attribute
    protected UUID uuid;
    protected transient List<String> autoFlags = new ArrayList<String>();

    public ComplexDataItemValue() {
    }

    public ComplexDataItemValue(T data) {
        this();
        if (((DataItem)data).getId() == null) {
            throw new IllegalArgumentException("Resolved's getId() returns NULL");
        }
        this.ref = ((DataItem)data).getId();
        this.resolved = data;
    }

    public ComplexDataItemValue(T data, int val) {
        this(data);
        if (((DataItem)data).getId() == null) {
            throw new IllegalArgumentException("Resolved's getId() returns NULL");
        }
        this.ref = ((DataItem)data).getId();
        this.value = val;
    }

    public List<Decision> getDecisions() {
        return this.decisions;
    }

    public Decision[] getDecisionArray() {
        Decision[] ret = new Decision[this.decisions.size()];
        return this.decisions.toArray(ret);
    }

    @Override
    public void addDecision(Decision value) {
        for (Decision dec : this.decisions) {
            if (!dec.getChoiceUUID().equals(value.getChoiceUUID())) continue;
            return;
        }
        this.decisions.add(value);
    }

    public void removeDecision(Decision value) {
        this.removeDecision(value.getChoiceUUID());
    }

    @Override
    public void removeDecision(UUID choiceUUID) {
        for (Decision dec : this.decisions) {
            if (!dec.getChoiceUUID().equals(choiceUUID)) continue;
            this.decisions.remove(dec);
            return;
        }
    }

    @Override
    public Decision getDecision(UUID uuid) {
        for (Decision dec : this.decisions) {
            if (dec == null || !dec.getChoiceUUID().equals(uuid)) continue;
            return dec;
        }
        return null;
    }

    public Decision getDecisionByRef(String name) {
        for (Decision dec : this.decisions) {
            Choice choice = ((ComplexDataItem)this.getResolved()).getChoice(dec.getChoiceUUID());
            if (choice == null || choice.getTypeReference() == null || !choice.getTypeReference().equals(name)) continue;
            return dec;
        }
        return null;
    }

    public Decision getDecisionByType(ModifiedObjectType type) {
        for (Decision dec : this.decisions) {
            Choice choice = ((ComplexDataItem)this.getResolved()).getChoice(dec.getChoiceUUID());
            if (choice == null || choice.getChooseFrom() == null || choice.getChooseFrom() != type) continue;
            return dec;
        }
        return null;
    }

    public void updateDecision(UUID uuid, String value) {
        for (Decision dec : this.decisions) {
            if (!dec.getChoiceUUID().equals(uuid)) continue;
            dec.setValue(value);
            return;
        }
        throw new NoSuchElementException(String.valueOf(uuid) + " not in " + String.valueOf(this.decisions));
    }

    public String getDecisionString(Locale loc) {
        return this.getDecisionString(loc, this.character);
    }

    public String getPerDecisionString(Choice choice, Object obj, Decision dec, Locale loc) {
        DataItem item = null;
        DataItemValue itemV = null;
        if (obj instanceof DataItem) {
            item = (DataItem)obj;
        } else if (obj instanceof DataItemValue) {
            itemV = (DataItemValue)obj;
        } else {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj != null) {
                try {
                    Method getName = obj.getClass().getMethod("getName", Locale.class);
                    return String.valueOf(getName.invoke(obj, loc));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (choice.getSubOptions() != null && !choice.getSubOptions().isEmpty()) {
            return ((ComplexDataItem)this.resolved).getChoiceOptionStrings(choice, choice.getSubOption(dec.getValue()), loc)[0];
        }
        if (item != null) {
            return item.getName(loc);
        }
        if (itemV != null) {
            return itemV.getNameWithoutRating(loc);
        }
        if (obj instanceof IAttribute) {
            return ((IAttribute)obj).getName(loc);
        }
        return dec.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDecisionString(Locale loc, CommonCharacter<?, ?, ?, ?> model) {
        String string;
        ArrayList<String> elem;
        block19: {
            elem = new ArrayList<String>();
            try {
                block21: {
                    block20: {
                        if (this.resolved != null) break block20;
                        logger.log(System.Logger.Level.ERROR, "<resolved> is null");
                        break block21;
                    }
                    Map<UUID, Choice> allChoices = this.getChoiceMapRecursivly(model);
                    for (Decision dec : this.decisions) {
                        Choice choice;
                        if (logger.isLoggable(System.Logger.Level.TRACE)) {
                            logger.log(System.Logger.Level.TRACE, "getDecisionString: dec=" + String.valueOf(dec));
                        }
                        if ((choice = allChoices.get(dec.getChoiceUUID())) == null) {
                            choice = ((ComplexDataItem)this.resolved).getHardcodedChoice(dec.getChoiceUUID());
                        }
                        if (choice == null) {
                            if (!dec.getChoiceUUID().toString().equals("c2d17c87-1cfe-4355-9877-a20fe09c170d")) {
                                logger.log(System.Logger.Level.WARNING, "No choice found for decision " + String.valueOf(dec) + " of " + String.valueOf(this));
                            }
                            elem.add(dec.getValue());
                            continue;
                        }
                        try {
                            void var8_16;
                            block23: {
                                block25: {
                                    Object var8_9;
                                    block24: {
                                        block22: {
                                            var8_9 = null;
                                            if (!choice.getChooseFrom().toString().equals("SUBSELECT")) break block22;
                                            ChoiceOption choiceOption = choice.getSubOption(dec.getValue());
                                            break block23;
                                        }
                                        if (!choice.getChooseFrom().toString().equals("CARRIED")) break block24;
                                        if (model != null) {
                                            CarriedItem<?> carriedItem = model.getCarriedItem(dec.getValueAsUUID());
                                            if (carriedItem == null) {
                                                logger.log(System.Logger.Level.ERROR, "Item {0} has a CARRIED decision {1} which is no known carried item in the character", this.getKey(), dec.getValue());
                                            }
                                            break block23;
                                        } else {
                                            if (this.character == null) {
                                                logger.log(System.Logger.Level.ERROR, "Item {0} has a CARRIED decision {1}, but the character has not been given", this.getKey(), dec.getValue());
                                                throw new RuntimeException("Cannot resolve CARRIED:" + dec.getValue() + " without character");
                                            }
                                            CarriedItem carriedItem = this.character.getCarriedItem(dec.getValueAsUUID());
                                            if (carriedItem == null) {
                                                logger.log(System.Logger.Level.ERROR, "Item {0} has a CARRIED decision {1} which is no known carried item in the character", this.getKey(), dec.getValue());
                                            }
                                        }
                                        break block23;
                                    }
                                    if (choice.getTypeReference() == null) break block25;
                                    if (choice.getTypeReference().equals("CHOICE")) {
                                        Object t = choice.getChooseFrom().resolve(dec.getValue());
                                        break block23;
                                    } else if (var8_9 == null) {
                                        String string2 = dec.getValue();
                                    }
                                    break block23;
                                }
                                Object t = choice.getChooseFrom().resolve(dec.getValue());
                            }
                            if (var8_16 == null) {
                                System.err.println("Could not resolve " + dec.getValue() + " for choice " + String.valueOf(choice));
                            }
                            String toAdd = this.getPerDecisionString(choice, var8_16, dec, loc);
                            elem.add(toAdd);
                        }
                        catch (ReferenceException referenceException) {
                            logger.log(System.Logger.Level.ERROR, "Error resolving ''{0}'' from instance of {1}: " + referenceException.getMessage(), dec.getValue(), this.getModifyable());
                        }
                    }
                }
                if (!elem.isEmpty()) break block19;
                string = "";
            }
            catch (Throwable throwable) {
                logger.log(System.Logger.Level.TRACE, "getDecisionString: {0}", elem);
                throw throwable;
            }
            logger.log(System.Logger.Level.TRACE, "getDecisionString: {0}", elem);
            return string;
        }
        string = String.join((CharSequence)", ", elem);
        logger.log(System.Logger.Level.TRACE, "getDecisionString: {0}", elem);
        return string;
    }

    private static void replaceOrAdd(StringBuffer haystack, String needle, String replace, List<String> names) {
        int from = haystack.indexOf("(" + needle + ")");
        int to = from + needle.length() + 2;
        if (from >= 0) {
            haystack.replace(from, to, replace);
        } else {
            names.add(replace);
        }
    }

    @Override
    public String getNameWithoutRating(Locale loc) {
        StringBuffer ret = new StringBuffer(super.getNameWithoutRating(loc));
        return ret.toString();
    }

    @Override
    public String getNameWithoutRating() {
        return this.getNameWithoutRating(Locale.getDefault());
    }

    @Override
    public String getNameWithRating(Locale loc) {
        String decString;
        String string = decString = this.decisions.isEmpty() ? "" : this.getDecisionString(loc);
        if (this.resolved == null) {
            return this.ref + " " + this.value + " " + decString;
        }
        if (this.decisions.isEmpty() && !((ComplexDataItem)this.resolved).getChoices().isEmpty()) {
            decString = "Undecided";
        }
        if (this.value == 0) {
            return ((ComplexDataItem)this.resolved).getName(loc) + " " + decString;
        }
        return ((ComplexDataItem)this.resolved).getName(loc) + " " + this.value + " " + decString;
    }

    public void updateOutgoingModificiations(CommonCharacter<?, ?, ?, ?> model) {
        this.outgoingModifications.clear();
        for (Modification tmp : ((ComplexDataItem)this.resolved).getOutgoingModifications()) {
            if (tmp.getReferenceType() == null) {
                if (!(tmp instanceof RelevanceModification)) {
                    logger.log(System.Logger.Level.WARNING, "{0} has a modification without type", this.getKey());
                }
                this.outgoingModifications.add(tmp);
                continue;
            }
            if (this instanceof ModifyableNumericalValue) {
                int lvl = ((ModifyableNumericalValue)((Object)this)).getModifiedValue();
                try {
                    Modification mod = tmp.getReferenceType().instantiateModification(tmp, this, lvl, model);
                    this.outgoingModifications.add(mod);
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Error instantiating mod " + String.valueOf(tmp) + " from " + String.valueOf(tmp.getSource()), (Throwable)e);
                }
                continue;
            }
            Modification mod = tmp.getReferenceType().instantiateModification(tmp, this, this.getDistributed(), model);
            if (mod == null) {
                logger.log(System.Logger.Level.DEBUG, "No instantiated {0} will be returned", tmp);
                continue;
            }
            this.outgoingModifications.add(mod);
        }
        for (Choice choice : ((ComplexDataItem)this.resolved).getChoices()) {
            ChoiceOption sub;
            Decision dec;
            if (choice.getSubOptions().isEmpty() || (dec = this.getDecision(choice.getUUID())) == null || (sub = choice.getSubOption(dec.getValue())) == null) continue;
            for (Modification tmp : sub.getOutgoingModifications()) {
                if (tmp.getReferenceType() == null) {
                    if (!(tmp instanceof RelevanceModification)) {
                        logger.log(System.Logger.Level.WARNING, "{0} has a modification without type", this.getKey());
                    }
                    this.outgoingModifications.add(tmp);
                    continue;
                }
                if (this instanceof ModifyableNumericalValue) {
                    int lvl = ((ModifyableNumericalValue)((Object)this)).getModifiedValue();
                    try {
                        Modification mod = tmp.getReferenceType().instantiateModification(tmp, this, lvl, model);
                        this.outgoingModifications.add(mod);
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Error instantiating mod " + String.valueOf(tmp) + " from " + String.valueOf(tmp.getSource()), (Throwable)e);
                    }
                    continue;
                }
                Modification mod = tmp.getReferenceType().instantiateModification(tmp, this, this.getDistributed(), model);
                if (mod == null) {
                    logger.log(System.Logger.Level.DEBUG, "No instantiated {0} will be returned", tmp);
                    continue;
                }
                this.outgoingModifications.add(mod);
            }
        }
    }

    public void addFlag(Enum<?> flag) {
        if (!this.flags.contains(flag.name())) {
            this.flags.add(flag.name());
        }
    }

    public void addAutoFlag(Enum<?> flag) {
        if (!this.autoFlags.contains(flag.name())) {
            this.autoFlags.add(flag.name());
        }
    }

    public void removeFlag(Enum<?> flag) {
        this.flags.remove(flag.name());
    }

    public void removeAutoFlag(Enum<?> flag) {
        this.autoFlags.remove(flag.name());
    }

    public void addAutoFlag(String flag) {
        if (!this.autoFlags.contains(flag)) {
            this.autoFlags.add(flag);
        }
    }

    public <E extends Enum> List<E> getFlags(Class<E> enumClass) {
        ArrayList<Enum> ret = new ArrayList<Enum>();
        block0: for (String name : this.flags) {
            for (Enum tmp : (Enum[])enumClass.getEnumConstants()) {
                if (!tmp.name().equals(name)) continue;
                ret.add(tmp);
                continue block0;
            }
            logger.log(System.Logger.Level.WARNING, "Unknown flag {0} in {1} for item {2}", name, enumClass, this.getKey());
        }
        return Collections.unmodifiableList(ret);
    }

    public <E extends Enum> List<E> getAutoFlags(Class<E> enumClass) {
        ArrayList<Enum> ret = new ArrayList<Enum>();
        block0: for (String name : this.autoFlags) {
            for (Enum tmp : (Enum[])enumClass.getEnumConstants()) {
                if (!tmp.name().equals(name)) continue;
                ret.add(tmp);
                continue block0;
            }
            logger.log(System.Logger.Level.WARNING, "Unknown flag {0} in class {1} for item {2}", name, enumClass, this.getKey());
        }
        return Collections.unmodifiableList(ret);
    }

    public boolean hasFlag(Enum<?> value) {
        return this.flags.contains(value.name()) || this.autoFlags.contains(value.name());
    }

    public boolean hasFlag(String value) {
        return this.flags.contains(value) || this.autoFlags.contains(value);
    }

    public void clearAutoFlags() {
        this.autoFlags.clear();
    }

    public boolean hasAutoFlag(Enum<?> value) {
        return this.autoFlags.contains(value.name());
    }

    public void setFlag(Enum<?> flag, boolean set) {
        if (set) {
            if (!this.flags.contains(flag.name())) {
                this.flags.add(flag.name());
            }
        } else {
            this.flags.remove(flag.name());
        }
    }

    public void setAutoFlag(Enum<?> flag, boolean set) {
        if (set) {
            if (!this.autoFlags.contains(flag.name())) {
                this.autoFlags.add(flag.name());
            }
        } else {
            this.autoFlags.remove(flag.name());
        }
    }

    public void setAutoFlag(String flag, boolean set) {
        if (set) {
            if (!this.autoFlags.contains(flag)) {
                this.autoFlags.add(flag);
            }
        } else {
            this.autoFlags.remove(flag);
        }
    }

    public Map<UUID, Choice> getChoiceMapRecursivly(CommonCharacter<?, ?, ?, ?> model) {
        HashMap<UUID, Choice> allChoices = new HashMap<UUID, Choice>();
        ((ComplexDataItem)this.resolved).getChoices().forEach(c -> allChoices.put(c.getUUID(), (Choice)c));
        for (Decision dec : this.decisions) {
            if (logger.isLoggable(System.Logger.Level.TRACE)) {
                logger.log(System.Logger.Level.TRACE, "getDecisionString: dec=" + String.valueOf(dec));
            }
            Choice choice = (Choice)allChoices.get(dec.getChoiceUUID());
            if ("standard".equals(dec.getValue().toLowerCase())) continue;
            if (choice == null) {
                logger.log(System.Logger.Level.WARNING, "No choice found for decision " + String.valueOf(dec) + " of " + String.valueOf(this));
                continue;
            }
            try {
                CarriedItem<Object> obj = null;
                if ("CHOICE".equals(choice.getTypeReference())) {
                    if ("CARRIED".equals(String.valueOf(choice.getChooseFrom())) && model != null) {
                        obj = model.getCarriedItem(UUID.fromString(dec.getValue()));
                        if (obj == null) {
                            logger.log(System.Logger.Level.ERROR, "No such CarriedItem {0} in character", dec.getValue());
                        }
                    } else {
                        obj = (CarriedItem<Object>)choice.getChooseFrom().resolve(dec.getValue());
                    }
                } else if ("CARRIED".equals(String.valueOf(choice.getChooseFrom()))) {
                    if (model == null) {
                        logger.log(System.Logger.Level.ERROR, "Cannot resolve CARRIED:{0}, since model of {1} is NULL", dec.getValue(), this);
                    }
                    if ((obj = model.getCarriedItem(UUID.fromString(dec.getValue()))) == null) {
                        logger.log(System.Logger.Level.ERROR, "No such CarriedItem {0} in character", dec.getValue());
                    }
                } else if (choice.getTypeReference() != null) {
                    if ("CARRIED".equals(String.valueOf(choice.getChooseFrom()))) {
                        if (model == null) {
                            logger.log(System.Logger.Level.ERROR, "Cannot resolve CARRIED:{0}, since model of {1} is NULL", dec.getValue(), this);
                        }
                        if ((obj = model.getCarriedItem(UUID.fromString(dec.getValue()))) == null) {
                            logger.log(System.Logger.Level.ERROR, "No such CarriedItem {0} in character", dec.getValue());
                        }
                    } else {
                        obj = choice.getChooseFrom().resolve(choice.getTypeReference());
                        if (obj == null) {
                            logger.log(System.Logger.Level.DEBUG, "Failed to resolve {0} from {1} ", dec.getValue(), choice.getChooseFrom());
                            obj = choice.getChooseFrom().resolve(dec.getValue());
                        }
                    }
                } else {
                    obj = choice.getChooseFrom().resolve(dec.getValue());
                }
                DataItem item = null;
                if (obj instanceof DataItem) {
                    item = (DataItem)((Object)obj);
                    logger.log(System.Logger.Level.DEBUG, "resolved {0} to {1}", dec.getValue(), item);
                    if (item == null || !(item instanceof ComplexDataItem)) continue;
                    logger.log(System.Logger.Level.DEBUG, "Choices from {0} are {1}", dec.getValue(), ((ComplexDataItem)item).getChoices());
                    ((ComplexDataItem)item).getChoices().forEach(c -> {
                        logger.log(System.Logger.Level.DEBUG, "Add choice " + String.valueOf(c) + " for resolution");
                        allChoices.put(c.getUUID(), (Choice)c);
                    });
                    continue;
                }
                if (!(obj instanceof DataItemValue)) continue;
                DataItemValue itemV = obj;
                item = itemV.getResolved();
                logger.log(System.Logger.Level.DEBUG, "resolved {0} to {1}", dec.getValue(), item);
                if (!(itemV instanceof ComplexDataItemValue)) continue;
                allChoices.put(dec.getChoiceUUID(), choice);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(System.Logger.Level.ERROR, "Failed resolving ''{0}'': {1}", dec.getValue(), e.toString());
            }
        }
        return allChoices;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void reset() {
        this.clearIncomingModifications();
    }
}

