/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataSet;
import de.rpgframework.genericrpg.data.ReferenceError;

public class DataErrorException
extends RuntimeException {
    private static final long serialVersionUID = 7732274685110052626L;
    private DataSet dataset;
    private DataItem item;
    private String resource;
    private ReferenceError refError;

    public DataErrorException(DataItem item, String message) {
        super(message);
        this.item = item;
    }

    public DataErrorException(DataItem item, DataSet plugin, Exception e) {
        super(e.getMessage(), e);
        this.item = item;
        this.dataset = plugin;
    }

    public DataErrorException(DataItem item, ReferenceError refError) {
        super(refError.toString());
        this.item = item;
        this.refError = refError;
    }

    @Override
    public String getMessage() {
        StringBuffer buf = new StringBuffer();
        if (this.refError != null) {
            buf.append(this.refError.toString());
        } else {
            buf.append(super.getMessage());
        }
        if (this.dataset != null) {
            buf.append("\nDataset : " + this.dataset.getID());
        }
        if (this.resource != null) {
            buf.append("\nResource: " + this.resource);
        }
        if (this.item != null) {
            buf.append("\n" + this.item.getTypeString() + "=" + this.item.getId());
        } else {
            buf.append("\nitem=null");
        }
        return buf.toString();
    }

    public DataSet getDataset() {
        return this.dataset;
    }

    public void setDataset(DataSet dataset) {
        this.dataset = dataset;
    }

    public DataItem getItem() {
        return this.item;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public ReferenceError getReferenceError() {
        return this.refError;
    }
}

