/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.genericrpg.NumericalValue;
import de.rpgframework.genericrpg.SelectedValue;
import de.rpgframework.genericrpg.data.CommonCharacter;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.ResolvableDataItem;
import de.rpgframework.genericrpg.modification.DataItemModification;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModifyableImpl;
import java.util.Locale;
import org.prelle.simplepersist.Attribute;
import org.prelle.simplepersist.Element;

public abstract class DataItemValue<T extends DataItem>
extends ModifyableImpl
implements NumericalValue<T>,
ResolvableDataItem<T>,
SelectedValue<T> {
    @Attribute(required=true)
    protected String ref;
    @Attribute(required=false, name="lang")
    protected String language = Locale.getDefault().getLanguage();
    protected transient T resolved;
    protected transient CommonCharacter<?, ?, ?, ?> character;
    @Attribute(name="value")
    protected int value;
    @Element
    protected String customName;
    protected transient Object injectedBy;

    public DataItemValue() {
    }

    public DataItemValue(T data) {
        this();
        this.ref = ((DataItem)data).getId();
        this.resolved = data;
    }

    public DataItemValue(T data, int val) {
        this(data);
        this.value = val;
    }

    @Override
    public String getKey() {
        return this.ref;
    }

    @Override
    public void setResolved(T value) {
        this.resolved = value;
        this.ref = value != null ? ((DataItem)value).getId() : null;
    }

    @Override
    public T getResolved() {
        return this.resolved;
    }

    @Override
    public int getDistributed() {
        return this.value;
    }

    @Override
    public void setDistributed(int points) {
        this.value = points;
    }

    public boolean isAutoAdded() {
        if (this.getInjectedBy() != null) {
            return true;
        }
        for (Modification mod : this.incomingModifications) {
            DataItemModification tmp;
            if (!(mod instanceof DataItemModification) || (tmp = (DataItemModification)mod).getResolvedKey() != this.resolved) continue;
            return true;
        }
        return false;
    }

    @Override
    public T getModifyable() {
        return this.getResolved();
    }

    public String getNameWithoutDecisions(Locale loc) {
        if (this.customName != null) {
            return this.customName;
        }
        if (this.resolved == null) {
            return this.ref;
        }
        return ((DataItem)this.resolved).getName(loc);
    }

    public String getNameWithoutRating(Locale loc) {
        if (this.customName != null) {
            return this.customName;
        }
        if (this.resolved == null) {
            return "?" + this.ref;
        }
        return ((DataItem)this.resolved).getName(loc);
    }

    public String getNameWithoutRating() {
        return this.getNameWithoutRating(Locale.getDefault());
    }

    public String getNameWithRating(Locale loc) {
        if (this.resolved == null) {
            return this.ref + " " + this.value;
        }
        if (this.value == 0) {
            return ((DataItem)this.resolved).getName(loc);
        }
        return ((DataItem)this.resolved).getName(loc) + " " + this.value;
    }

    public String getNameWithRating() {
        return this.getNameWithRating(Locale.getDefault());
    }

    public String getShortName(Locale locale) {
        if (this.resolved == null) {
            return this.ref;
        }
        return ((DataItem)this.resolved).getShortName(locale);
    }

    public CommonCharacter<?, ?, ?, ?> getCharacter() {
        return this.character;
    }

    public void setCharacter(CommonCharacter<?, ?, ?, ?> character) {
        this.character = character;
    }

    public Object getInjectedBy() {
        return this.injectedBy;
    }

    public void setInjectedBy(Object injectedBy) {
        this.injectedBy = injectedBy;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

