/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.MultiLanguageResourceBundle;
import de.rpgframework.core.CustomResourceManagerLoader;
import de.rpgframework.core.RoleplayingSystem;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class DataSet {
    protected static final System.Logger logger = System.getLogger(DataSet.class.getPackageName());
    private MultiLanguageResourceBundle resources;
    private transient String bundleID;
    private String id;
    private RoleplayingSystem rules;
    private List<Locale> languages;
    private DataSetType type = DataSetType.OTHER;
    private int released = 209999;

    public DataSet(Object parent, RoleplayingSystem rules, String id, String resourcePrefix, Locale ... locales) {
        this.id = id;
        this.rules = rules;
        this.bundleID = resourcePrefix != null ? resourcePrefix + "." + id.toLowerCase() : id.toLowerCase();
        this.languages = Arrays.asList(locales);
        try {
            this.resources = new MultiLanguageResourceBundle(parent.getClass(), this.bundleID, locales);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public DataSet(Object parent, RoleplayingSystem rules, String id, String resourcePrefix, MultiLanguageResourceBundle res, Locale ... locales) {
        this.id = id;
        this.rules = rules;
        this.bundleID = resourcePrefix + "." + id;
        this.languages = Arrays.asList(locales);
        this.resources = res;
    }

    public String toString() {
        return "dataset:" + this.id;
    }

    public String getBundleID() {
        return this.bundleID;
    }

    public String getName(Locale locale) {
        return this.getResourceString("dataset.name", locale);
    }

    public String getShortName(Locale locale) {
        return this.getResourceString("dataset.name.short", locale);
    }

    public String getDescription(Locale locale) {
        return this.getResourceString("dataset.desc", locale);
    }

    public String getID() {
        return this.id;
    }

    public RoleplayingSystem getRules() {
        return this.rules;
    }

    public List<Locale> getLocales() {
        return this.languages;
    }

    public String getResourceString(String key, Locale locale) {
        if (this.resources == null) {
            System.err.println("No MultiLanguageResourceBundle set for " + this.id);
            return key;
        }
        return this.resources.getString(key, locale);
    }

    public String getResourceString(List<String> keys, Locale locale) {
        if (this.resources == null) {
            System.err.println("No MultiLanguageResourceBundle set for " + this.id);
            return "?" + String.valueOf(keys) + "?";
        }
        if (CustomResourceManagerLoader.getInstance() != null) {
            for (String key : keys) {
                String custom = CustomResourceManagerLoader.getInstance().getProperty(this.rules, key, locale);
                if (custom == null) continue;
                return custom;
            }
        }
        return this.resources.getString(keys, locale);
    }

    public String getBaseBundleName() {
        return this.resources.getBaseBundleName();
    }

    public void flushMissingKeys() {
        this.resources.flushMissingKeys();
    }

    public DataSetType getType() {
        return this.type;
    }

    public void setType(DataSetType type) {
        this.type = type;
    }

    public int getReleased() {
        return this.released;
    }

    public void setReleased(int released) {
        this.released = released;
    }

    public static enum DataSetType {
        RULES,
        OPT_RULES,
        LOCATION,
        BACKGROUND,
        OTHER;

    }
}

