/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataProvider;
import de.rpgframework.genericrpg.data.IReferenceResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataStorage<V extends DataItem>
implements DataProvider<V> {
    private String type;
    private Map<String, V> items;

    public DataStorage(String type) {
        this.type = type;
        this.items = new HashMap<String, V>();
    }

    @Override
    public String getSupportedDataType() {
        return this.type;
    }

    @Override
    public V getItem(String key) {
        DataItem ret = (DataItem)this.items.get(key);
        if (ret != null) {
            return (V)ret;
        }
        for (DataItem tmp : this.items.values()) {
            if (!(tmp instanceof IReferenceResolver) || (ret = (DataItem)((IReferenceResolver)((Object)tmp)).resolveItem(key)) == null) continue;
            return (V)ret;
        }
        return null;
    }

    @Override
    public V getItem(String key, String lang) {
        DataItem ret = (DataItem)this.items.get(key);
        if (ret != null) {
            DataItem ret2 = lang != null ? (DataItem)ret.getLanguageAlternative(lang) : null;
            return (V)(ret2 != null ? ret2 : ret);
        }
        for (DataItem tmp : this.items.values()) {
            if (!(tmp instanceof IReferenceResolver) || (ret = (DataItem)((IReferenceResolver)((Object)tmp)).resolveItem(key)) == null) continue;
            return (V)ret;
        }
        return null;
    }

    @Override
    public List<V> getItems() {
        ArrayList<DataItem> all = new ArrayList<DataItem>();
        for (DataItem tmp : this.items.values()) {
            all.add(tmp);
            all.addAll(tmp.getLanguageAlternatives());
        }
        return all;
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.items.keySet());
    }

    public void add(V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (!((DataItem)value).getTypeString().equals(this.type)) {
            throw new IllegalArgumentException("Trying to add a '" + ((DataItem)value).getTypeString() + "' to a database of '" + this.type + "'");
        }
        this.items.put(((DataItem)value).getId(), value);
    }

    public void add(V value, DataItem parent) {
        if (value == null) {
            throw new NullPointerException("Value");
        }
        if (parent == null) {
            throw new NullPointerException("parent DataItem");
        }
        this.items.put(parent.getId() + "/" + ((DataItem)value).getId(), value);
    }

    public V remove(String key) {
        return (V)((DataItem)this.items.remove(key));
    }

    public void clear() {
        this.items.clear();
    }
}

