/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.genericrpg.data.Choice;
import java.util.UUID;
import org.prelle.simplepersist.Attribute;

public class Decision {
    @Attribute(name="choice", required=true)
    private UUID choiceUUID;
    @Attribute(required=true)
    private String value;
    private transient UUID valueAsUUID;

    public Decision() {
    }

    public Decision(Choice choice, String value) {
        if (choice.getUUID() == null) {
            throw new NullPointerException("Choice has no UUID");
        }
        this.choiceUUID = choice.getUUID();
        this.value = value;
    }

    public Decision(UUID uuid, String value) {
        this.choiceUUID = uuid;
        this.value = value;
    }

    public Decision(String uuid, String value) {
        this.choiceUUID = UUID.fromString(uuid);
        this.value = value;
    }

    public Decision(UUID uuid, UUID value) {
        if (uuid == null || value == null) {
            throw new NullPointerException();
        }
        this.choiceUUID = uuid;
        this.value = value.toString();
    }

    public String toString() {
        return String.valueOf(this.choiceUUID) + "=" + this.value;
    }

    public UUID getChoiceUUID() {
        return this.choiceUUID;
    }

    public String getValue() {
        return this.value;
    }

    public int getValueAsInt() {
        return Integer.parseInt(this.value);
    }

    public String[] getValues() {
        return this.value.split(",");
    }

    public void setValue(String value) {
        this.value = value;
    }

    public UUID getValueAsUUID() {
        if (this.valueAsUUID == null) {
            this.valueAsUUID = UUID.fromString(this.value);
        }
        return this.valueAsUUID;
    }

    public void setValueAsUUID(UUID valueAsUUID) {
        this.valueAsUUID = valueAsUUID;
    }
}

