/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.genericrpg.data.DataErrorException;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataItemTypeKey;
import de.rpgframework.genericrpg.data.DataSet;
import de.rpgframework.genericrpg.data.DataStorage;
import de.rpgframework.genericrpg.data.PageReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.prelle.simplepersist.Persister;
import org.prelle.simplepersist.SerializationException;

public abstract class GenericCore {
    protected static final System.Logger logger = System.getLogger(GenericCore.class.getPackageName());
    protected static Persister serializer = new Persister();
    private static Map<Class<? extends DataItem>, DataStorage<? extends DataItem>> storesByType = new HashMap<Class<? extends DataItem>, DataStorage<? extends DataItem>>();
    protected static List<DataSet> sets = new ArrayList<DataSet>();

    public static Persister getPersister() {
        return serializer;
    }

    protected static <E extends DataItem> DataStorage<E> getStorage(Class<E> cls) {
        DataStorage<DataItem> store = storesByType.get(cls);
        if (store == null) {
            DataItemTypeKey anno = cls.getAnnotation(DataItemTypeKey.class);
            if (anno == null) {
                throw new IllegalArgumentException("Class " + cls.getName() + " misses @DataItemTypeKey annotation");
            }
            store = new DataStorage(anno.id());
            storesByType.put(cls, store);
        }
        return store;
    }

    public static List<DataSet> getDataSets() {
        return new ArrayList<DataSet>(sets);
    }

    public static void removeDataSet(DataSet set) {
        System.getLogger("rpgframework").log(System.Logger.Level.WARNING, "Remove dataset " + set.getID());
        sets.remove(set);
        for (Map.Entry<Class<? extends DataItem>, DataStorage<? extends DataItem>> entry : storesByType.entrySet()) {
            DataStorage<? extends DataItem> storage = entry.getValue();
            for (DataItem dataItem : new ArrayList<DataItem>(storage.getItems())) {
                for (PageReference pageRef : new ArrayList<PageReference>(dataItem.getPageReferences())) {
                    if (pageRef.getProduct() != set) continue;
                    dataItem.getPageReferences().remove(pageRef);
                }
                if (!dataItem.getPageReferences().isEmpty() || storage.remove(dataItem.getId()) != null) continue;
                System.getLogger("rpgframework").log(System.Logger.Level.WARNING, "Failed to remove item {0}", dataItem.getId());
            }
        }
    }

    public static <E extends DataItem> List<E> loadDataItems(Class<? extends List<E>> cls, Class<E> itemCls, DataSet plugin, Class<?> clazz, String resourceName) throws IOException {
        List<E> list;
        block5: {
            try {
                list = GenericCore.loadDataItems(cls, itemCls, plugin, clazz.getResourceAsStream(resourceName));
                if (!Persister.errorFound) break block5;
            }
            catch (DataErrorException e) {
                try {
                    e.setResource(resourceName);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (Persister.errorFound) {
                        logger.log(System.Logger.Level.ERROR, "Error in resource {0}", resourceName);
                    }
                    throw throwable;
                }
            }
            logger.log(System.Logger.Level.ERROR, "Error in resource {0}", resourceName);
        }
        return list;
    }

    public static <E extends DataItem> List<E> loadDataItems(Class<? extends List<E>> cls, Class<E> itemCls, DataSet plugin, InputStream in) throws IOException {
        DataStorage<E> storage = GenericCore.getStorage(itemCls);
        try {
            List added = (List)serializer.read(cls, in);
            if (!sets.contains(plugin)) {
                sets.add(plugin);
            }
            for (DataItem item2 : added) {
                E already = storage.getItem(item2.getId());
                if (already != null) {
                    if (((DataItem)already).getLanguage() != item2.getLanguage()) {
                        logger.log(System.Logger.Level.DEBUG, "Add different language definition of {0}: {1}", item2.toString(), item2.getLanguage());
                        ((DataItem)already).addLanguageAlternative(item2.getLanguage(), item2);
                    } else {
                        logger.log(System.Logger.Level.WARNING, "Add {0} from {1} to already existing {2} from {3}", item2.toString(), plugin, ((DataItem)already).toString(), ((DataItem)already).getAssignedDataSets());
                    }
                    if (!((DataItem)already).datasets.contains(plugin)) {
                        ((DataItem)already).assignToDataSet(plugin);
                    }
                    if (item2.datasets.contains(plugin)) continue;
                    item2.assignToDataSet(plugin);
                    continue;
                }
                item2.assignToDataSet(plugin);
                storage.add(item2);
            }
            added.forEach(item -> {
                try {
                    item.validate();
                    item.getName();
                    item.getDescription();
                }
                catch (DataErrorException e) {
                    e.setDataset(plugin);
                    System.err.println("In dataset " + plugin.getID() + "\n" + e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    throw new DataErrorException((DataItem)item, plugin, e);
                }
            });
            return added;
        }
        catch (SerializationException e) {
            System.err.println("Line " + e.getLine() + "  col " + e.getColumn());
            throw e;
        }
    }

    public static <E extends DataItem> void retainItems(Class<E> itemCls, String ... keys) {
        List<String> allowed = Arrays.asList(keys);
        List<String> found = GenericCore.getStorage(itemCls).getKeys();
        for (String key : found) {
            if (allowed.contains(key)) continue;
            GenericCore.getStorage(itemCls).remove(key);
        }
    }

    public static <E extends DataItem> E getItem(Class<E> itemCls, String key) {
        return GenericCore.getStorage(itemCls).getItem(key);
    }

    public static <E extends DataItem> E getItem(Class<E> itemCls, String key, String lang) {
        return GenericCore.getStorage(itemCls).getItem(key, lang);
    }

    public static <E extends DataItem> List<E> getItemList(Class<E> itemCls) {
        ArrayList foo = new ArrayList();
        GenericCore.getStorage(itemCls).getItems().forEach(item -> foo.add(item));
        return foo;
    }

    public static <E extends DataItem> List<PageReference> getBestPageReferences(E item, Locale locale) {
        ArrayList<PageReference> ret = new ArrayList<PageReference>();
        for (PageReference tmp : item.getPageReferences()) {
            if (!tmp.getLanguage().equals(locale.getLanguage())) continue;
            ret.add(tmp);
        }
        if (ret.isEmpty()) {
            ret.addAll(item.getPageReferences());
        }
        return ret;
    }

    public static <E extends DataItem> List<String> getBestPageReferenceShortNames(E item, Locale locale) {
        ArrayList<String> ret = new ArrayList<String>();
        for (PageReference tmp : GenericCore.getBestPageReferences(item, locale)) {
            ret.add(tmp.getProduct().getShortName(locale) + " " + tmp.getPage());
        }
        return ret;
    }

    public static <E extends DataItem> List<String> getBestPageReferenceLongNames(E item, Locale locale) {
        ArrayList<String> ret = new ArrayList<String>();
        for (PageReference tmp : GenericCore.getBestPageReferences(item, locale)) {
            ret.add(tmp.getProduct().getName(locale) + " " + tmp.getPage());
        }
        return ret;
    }
}

