/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.items.CarriedItem;
import de.rpgframework.genericrpg.items.Hook;
import de.rpgframework.genericrpg.items.PieceOfGear;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModifyableImpl;
import de.rpgframework.genericrpg.modification.ValueModification;
import java.util.ArrayList;
import java.util.List;
import org.prelle.simplepersist.Attribute;

public abstract class AAvailableSlot<H extends Hook, T extends PieceOfGear>
extends ModifyableImpl {
    @Attribute
    protected float capacity;
    protected transient List<CarriedItem<T>> embedded = new ArrayList<CarriedItem<T>>();

    protected AAvailableSlot() {
    }

    public AAvailableSlot(float capacity) {
        this();
        this.capacity = capacity;
    }

    public List<CarriedItem<T>> getAllEmbeddedItems() {
        return new ArrayList<CarriedItem<T>>(this.embedded);
    }

    public String toString() {
        return String.valueOf(this.getHook()) + "(cap=" + this.capacity + ", used=" + this.getUsedCapacity() + ", items=" + String.valueOf(this.embedded) + ", mods=" + String.valueOf(this.incomingModifications) + ")";
    }

    public void addEmbeddedItem(CarriedItem accessory) {
        this.embedded.add(accessory);
    }

    public boolean removeEmbeddedItem(CarriedItem accessory) {
        return this.embedded.remove(accessory);
    }

    public abstract H getHook();

    public float getCapacity() {
        float modifier = 0.0f;
        for (Modification mod : this.getIncomingModifications()) {
            if (!(mod instanceof ValueModification)) continue;
            modifier += ((ValueModification)mod).getFormula().getAsFloat();
        }
        return this.capacity + modifier;
    }

    public void setCapacity(float value) {
        this.capacity = value;
    }

    public abstract float getUsedCapacity();

    public abstract float getFreeCapacity();

    public void clear() {
        this.embedded.clear();
    }
}

