/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.core.RoleplayingSystem;
import de.rpgframework.genericrpg.ToDoElement;
import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.data.ApplyTo;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.DataErrorException;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.data.IReferenceResolver;
import de.rpgframework.genericrpg.data.Lifeform;
import de.rpgframework.genericrpg.data.ReferenceError;
import de.rpgframework.genericrpg.data.ReferenceException;
import de.rpgframework.genericrpg.items.ApplyDecisionsStep;
import de.rpgframework.genericrpg.items.CarriedItem;
import de.rpgframework.genericrpg.items.CarriedItemProcessor;
import de.rpgframework.genericrpg.items.CarryMode;
import de.rpgframework.genericrpg.items.CopyRequirementsStep;
import de.rpgframework.genericrpg.items.CopyResolvedAttributesStep;
import de.rpgframework.genericrpg.items.IItemAttribute;
import de.rpgframework.genericrpg.items.IVariantMode;
import de.rpgframework.genericrpg.items.PieceOfGear;
import de.rpgframework.genericrpg.items.PieceOfGearVariant;
import de.rpgframework.genericrpg.items.RecurseEmbeddedItems;
import de.rpgframework.genericrpg.items.ResolveVariantStep;
import de.rpgframework.genericrpg.items.formula.ResolveFormulasInRequirementsStep;
import de.rpgframework.genericrpg.items.formula.ResolveFormulasStep;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class GearTool {
    public static final String SELECTION_NOT_ALLOWED = "Selection not allowed";
    private static final System.Logger logger = CarriedItem.logger;
    static CarriedItemProcessor[] PHASE1_STEPS = new CarriedItemProcessor[]{new ResolveVariantStep(), new CopyResolvedAttributesStep(), new ApplyDecisionsStep(), new ResolveFormulasStep(), new CopyRequirementsStep(), new ResolveFormulasInRequirementsStep()};
    static CarriedItemProcessor[] PHASE2_STEPS = new CarriedItemProcessor[]{new RecurseEmbeddedItems()};
    private static Map<RoleplayingSystem, CarriedItemProcessor[]> PER_RPG_PHASE1_STEPS = new HashMap<RoleplayingSystem, CarriedItemProcessor[]>();
    private static Map<RoleplayingSystem, CarriedItemProcessor[]> PER_RPG_PHASE2_STEPS = new HashMap<RoleplayingSystem, CarriedItemProcessor[]>();

    public static void setPerRPGStatsPhase1(RoleplayingSystem rules, CarriedItemProcessor[] steps) {
        PER_RPG_PHASE1_STEPS.put(rules, steps);
    }

    public static void setPerRPGStatsPhase2(RoleplayingSystem rules, CarriedItemProcessor[] steps) {
        PER_RPG_PHASE2_STEPS.put(rules, steps);
    }

    public static OperationResult<Boolean> validate(CarriedItem<?> model) {
        return new OperationResult<Boolean>(true);
    }

    public static <T extends PieceOfGear> OperationResult<CarriedItem<T>> buildItem(T template, CarryMode mode, Lifeform charac, boolean strict, Decision ... decisions) {
        return GearTool.buildItem(template, mode, null, charac, strict, decisions);
    }

    public static <T extends PieceOfGear> OperationResult<CarriedItem<T>> buildItem(T template, CarryMode mode, PieceOfGearVariant<? extends IVariantMode> variant, Lifeform charac, boolean strict, Decision ... decisions) {
        return GearTool.buildItem(template, mode, variant, charac, strict, null, decisions);
    }

    public static <T extends PieceOfGear> OperationResult<CarriedItem<T>> buildItem(T template, CarryMode mode, PieceOfGearVariant<? extends IVariantMode> variant, Lifeform charac, boolean strict, IReferenceResolver context, Decision ... decisions) {
        CarriedItem<T> ret = new CarriedItem<T>(template, variant, mode);
        ret.setUser(charac);
        OperationResult result = new OperationResult(ret);
        ArrayList<Decision> validDecisions = new ArrayList<Decision>();
        ArrayList<Choice> allChoices = new ArrayList<Choice>(template.getChoices());
        if (variant != null) {
            allChoices.addAll(variant.getChoices());
        }
        List expected = allChoices.stream().map(c -> c.getUUID()).collect(Collectors.toList());
        logger.log(System.Logger.Level.DEBUG, "Go over all {0} decisions", decisions.length);
        block4: for (Decision dec : decisions) {
            if (dec.getChoiceUUID() == null) {
                result.addMessage(new ToDoElement(ToDoElement.Severity.STOPPER, "Internal error: missing UUID in decision " + dec.getValue()));
                continue;
            }
            if (dec.getChoiceUUID() == PieceOfGear.VARIANT) continue;
            Choice choice = template.getChoice(dec.getChoiceUUID());
            if (choice == null && variant != null) {
                choice = variant.getChoice(dec.getChoiceUUID());
            }
            if (choice == null) {
                result.addMessage(new ToDoElement(ToDoElement.Severity.STOPPER, "Internal error: choice " + String.valueOf(dec.getChoiceUUID()) + " does not exist in " + template.getId()));
                continue;
            }
            expected.remove(dec.getChoiceUUID());
            String[] options = choice.getChoiceOptions();
            if (choice.getChoiceOptions() != null) {
                boolean found = false;
                for (String opt : choice.getChoiceOptions()) {
                    if (!opt.equals(dec.getValue())) continue;
                    if (choice.isNegated()) {
                        result.addMessage(new ToDoElement(ToDoElement.Severity.STOPPER, "Selection not allowed: " + choice.getTypeReference() + "=" + dec.getValue()));
                        continue block4;
                    }
                    found = true;
                    validDecisions.add(dec);
                    break;
                }
                if (found) continue;
                logger.log(System.Logger.Level.WARNING, template.getId() + ": Invalid decision " + dec.getValue() + " for " + choice.getTypeReference() + "/" + String.valueOf(choice.getUUID()));
                continue;
            }
            ModifiedObjectType type = choice.getChooseFrom();
            Integer resolved = null;
            try {
                try {
                    resolved = Integer.parseInt(dec.getValue());
                }
                catch (NumberFormatException e) {
                    resolved = type.resolve(dec.getValue());
                }
            }
            catch (ReferenceException e) {
                logger.log(System.Logger.Level.ERROR, "In decision {0} of item {1}: {2}", dec, template, e.getMessage());
                result.addMessage(new ToDoElement(ToDoElement.Severity.WARNING, "Could not resolve " + dec.getValue()));
                continue;
            }
            if (resolved == null) {
                System.err.println("GearTool: Could not resolve " + dec.getValue() + "   context=" + String.valueOf(context));
            }
            if (resolved == null && context != null) {
                resolved = context.resolveItem(dec.getValue());
            }
            if (resolved != null) {
                validDecisions.add(dec);
                if (!logger.isLoggable(System.Logger.Level.INFO)) continue;
                logger.log(System.Logger.Level.INFO, template.getId() + ": Valid decision " + dec.getValue() + " for " + String.valueOf(type) + "/" + String.valueOf(choice.getUUID()));
                continue;
            }
            logger.log(System.Logger.Level.ERROR, "Valid decision {0} points to unknown object: {1}", choice.getUUID(), dec.getValue());
            if (strict) continue;
            validDecisions.add(dec);
        }
        for (UUID uuid : expected) {
            Choice choice = template.getChoice(uuid);
            if (choice == null && variant != null) {
                choice = variant.getChoice(uuid);
            }
            if (choice == null) {
                logger.log(System.Logger.Level.WARNING, "Expected choice " + String.valueOf(uuid) + " but template of " + template.getId() + " does not know about it");
                throw new IllegalStateException("Expected choice " + String.valueOf(uuid) + " but template of " + template.getId() + " does not know about it");
            }
            if (choice.getChoiceOptions() == null || choice.getChoiceOptions().length <= 0 || strict) continue;
            logger.log(System.Logger.Level.DEBUG, "Add first option {0} for choice {1}:{2}", choice.getChoiceOptions()[0], choice.getChooseFrom(), choice.getTypeReference());
            validDecisions.add(new Decision(choice, choice.getChoiceOptions()[0]));
        }
        logger.log(System.Logger.Level.DEBUG, template.getId() + ": Set decisions = " + String.valueOf(validDecisions));
        ret.setDecisions(validDecisions);
        OperationResult<List<Modification>> res = GearTool.recalculate("", template.getReferenceType(), charac, ret, strict);
        if (res.hasError()) {
            res.getMessages().forEach(m -> result.addMessage((ToDoElement)m));
        }
        if (res.get() != null && !res.get().isEmpty()) {
            logger.log(System.Logger.Level.DEBUG, "To Do: Add calculated character modifications to item {0}", ret);
            logger.log(System.Logger.Level.DEBUG, "-2--{0}", ret.getIncomingModifications());
            logger.log(System.Logger.Level.DEBUG, "-3--{0}", ret.getOutgoingModifications());
            for (Modification mod : res.get()) {
                logger.log(System.Logger.Level.DEBUG, "Add {0}    {1}", new Object[]{mod, mod.getApplyTo()});
                if (mod.getApplyTo() != ApplyTo.DATA_ITEM && mod.getApplyTo() != null) continue;
                ret.addIncomingModification(mod);
            }
        }
        return result;
    }

    static CarriedItemProcessor[] concat(CarriedItemProcessor[] array1, CarriedItemProcessor[] array2) {
        CarriedItemProcessor[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    protected static CarriedItemProcessor[] getSteps(CarriedItem<?> carried) {
        RoleplayingSystem rules = null;
        CarriedItemProcessor[] extra1 = null;
        CarriedItemProcessor[] extra2 = null;
        try {
            if (!((PieceOfGear)carried.getModifyable()).getAssignedDataSets().isEmpty()) {
                rules = ((PieceOfGear)carried.getModifyable()).getAssignedDataSets().iterator().next().getRules();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.WARNING, "Error processing CarriedItem " + String.valueOf(carried.getUuid()) + ": " + String.valueOf(e));
            throw e;
        }
        if (rules != null) {
            extra1 = PER_RPG_PHASE1_STEPS.get(rules);
            extra2 = PER_RPG_PHASE2_STEPS.get(rules);
        }
        CarriedItemProcessor[] p1 = extra1 != null ? GearTool.concat(PHASE1_STEPS, extra1) : PHASE1_STEPS;
        CarriedItemProcessor[] p2 = extra2 != null ? GearTool.concat(PHASE2_STEPS, extra2) : PHASE2_STEPS;
        return GearTool.concat(p1, p2);
    }

    public static <I extends IItemAttribute> OperationResult<List<Modification>> recalculate(String indent, ModifiedObjectType refType, Lifeform user, CarriedItem<?> item) {
        return GearTool.recalculate(indent, refType, user, item, true);
    }

    public static <I extends IItemAttribute> OperationResult<List<Modification>> recalculate(String indent, ModifiedObjectType refType, Lifeform user, CarriedItem<?> item, boolean strict) {
        logger.log(System.Logger.Level.INFO, indent + "recalculate {0} of {1}", item.getKey(), user != null ? user.getName() : null);
        if (item.getResolved() == null) {
            throw new DataErrorException(null, new ReferenceError(null, item.getTemplateID()));
        }
        String prefix = indent + item.getTemplateID() + ": ";
        item.reset();
        logger.log(System.Logger.Level.DEBUG, prefix + "START:----------------" + String.valueOf(item));
        for (CarriedItem<?> carriedItem : item.getAccessories()) {
            GearTool.recalculate(indent, refType, user, carriedItem);
        }
        OperationResult<List<Modification>> unprocessed = new OperationResult<List<Modification>>(new ArrayList());
        try {
            for (CarriedItemProcessor step : GearTool.getSteps(item)) {
                OperationResult<List<Modification>> result;
                if (logger.isLoggable(System.Logger.Level.TRACE)) {
                    logger.log(System.Logger.Level.TRACE, prefix + "  run " + step.getClass().getSimpleName());
                }
                if ((result = step.process(strict, refType, user, item, unprocessed.get())).hasError()) {
                    if (strict) {
                        logger.log(System.Logger.Level.WARNING, "Error recalculating item {0}: {1}", item.getUuid(), result.getMessages());
                    }
                } else {
                    unprocessed.set(result.get());
                }
                unprocessed.getMessages().addAll(result.getMessages());
                if (!logger.isLoggable(System.Logger.Level.TRACE)) continue;
                logger.log(System.Logger.Level.TRACE, prefix + "  after " + step.getClass().getSimpleName() + " = " + String.valueOf(unprocessed) + " / " + String.valueOf(item.getOutgoingModifications()));
            }
            logger.log(System.Logger.Level.DEBUG, prefix + "  unprocessed = " + String.valueOf(unprocessed));
            logger.log(System.Logger.Level.DEBUG, prefix + "  character   = " + String.valueOf(item.getOutgoingModifications()));
            logger.log(System.Logger.Level.DEBUG, prefix + "  messages    = " + String.valueOf(unprocessed.getMessages()));
            unprocessed.get().forEach(tmp -> item.addIncomingModification((Modification)tmp));
        }
        catch (Exception exception) {
            logger.log(System.Logger.Level.ERROR, "Error recalculating item " + item.getKey() + " in " + String.valueOf(user));
            exception.printStackTrace();
        }
        logger.log(System.Logger.Level.DEBUG, prefix + "STOP :----------------" + String.valueOf(item));
        item.setLastRecalculateResult(unprocessed);
        return unprocessed;
    }
}

