/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.ValueType;
import de.rpgframework.genericrpg.items.IItemAttribute;
import de.rpgframework.genericrpg.items.ItemAttributeDefinition;
import de.rpgframework.genericrpg.items.ItemAttributeValue;
import de.rpgframework.genericrpg.modification.ApplyableValueModification;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ValueModification;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Locale;
import org.prelle.simplepersist.Attribute;

public class ItemAttributeFloatValue<A extends IItemAttribute>
extends ItemAttributeValue<A> {
    @Attribute(name="value")
    protected float value;

    public ItemAttributeFloatValue(ItemAttributeDefinition template) {
        super(template.getModifyable());
        if (!template.isInteger()) {
            throw new IllegalArgumentException("Not a number definition");
        }
        this.value = template.getFormula().getAsFloat();
    }

    public ItemAttributeFloatValue(A attr) {
        super(attr);
        this.value = 0.0f;
    }

    public ItemAttributeFloatValue(A attr, float val) {
        super(attr);
        this.value = val;
    }

    @Override
    public Object clone() {
        ItemAttributeFloatValue<IItemAttribute> copy = new ItemAttributeFloatValue<IItemAttribute>(this.attribute, this.value);
        copy.addModifications(new ArrayList<Modification>(this.incomingModifications));
        return copy;
    }

    public String toString() {
        if (this.getModifier() == 0) {
            return String.valueOf(this.value);
        }
        return this.value + " (" + this.getModifiedValue() + ")";
    }

    public float getDistributed() {
        return this.value;
    }

    public void setDistributed(float points) {
        this.value = points;
    }

    public int getModifier() {
        int count = 0;
        for (Modification mod : this.incomingModifications) {
            if (mod instanceof ApplyableValueModification) {
                ApplyableValueModification applyableValueModification = (ApplyableValueModification)mod;
                continue;
            }
            if (!(mod instanceof ValueModification)) continue;
            count += ((ValueModification)mod).getValue();
        }
        return count;
    }

    public float getFloatModifier() {
        BigDecimal count = new BigDecimal(0);
        for (Modification mod : this.incomingModifications) {
            if (!(mod instanceof ValueModification)) continue;
            ValueModification sMod = (ValueModification)mod;
            BigDecimal d1 = new BigDecimal(String.format("%.3f", sMod.getValue()));
            BigDecimal d2 = new BigDecimal("1000");
            BigDecimal tmp = d1.divide(d2);
            if (sMod.getResolvedKey() != this.attribute) continue;
            count = count.add(tmp);
        }
        return count.floatValue();
    }

    public BigDecimal getBigDecimalModifier() {
        BigDecimal count = new BigDecimal(0);
        for (Modification mod : this.incomingModifications) {
            if (!(mod instanceof ValueModification)) continue;
            ValueModification sMod = (ValueModification)mod;
            BigDecimal d1 = new BigDecimal(String.format("%d", sMod.getValue()));
            BigDecimal d2 = new BigDecimal("1000");
            BigDecimal tmp = d1.divide(d2);
            if (sMod.getResolvedKey() != this.attribute) continue;
            count = count.add(tmp);
        }
        return count;
    }

    public float getModifiedValue() {
        BigDecimal b1 = new BigDecimal(String.format(Locale.ENGLISH, "%.3f", Float.valueOf(this.value)));
        BigDecimal b2 = this.getBigDecimalModifier();
        return b1.add(b2).floatValue();
    }

    public double getModifiedValueDouble() {
        BigDecimal b1 = new BigDecimal(String.format(Locale.ENGLISH, "%.3f", Float.valueOf(this.value)));
        BigDecimal b2 = this.getBigDecimalModifier();
        return b1.add(b2).doubleValue();
    }

    public BigDecimal getModifiedValueBigDecimal() {
        BigDecimal b1 = new BigDecimal(String.format(Locale.ENGLISH, "%.3f", Float.valueOf(this.value)));
        BigDecimal b2 = this.getBigDecimalModifier();
        return b1.add(b2);
    }

    public float getModifiedValue(ValueType type) {
        return this.getFloatModifier();
    }
}

