/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.ModifyableNumericalValue;
import de.rpgframework.genericrpg.ValueType;
import de.rpgframework.genericrpg.items.IItemAttribute;
import de.rpgframework.genericrpg.items.ItemAttributeDefinition;
import de.rpgframework.genericrpg.items.ItemAttributeValue;
import de.rpgframework.genericrpg.modification.ApplyableValueModification;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ValueModification;
import java.util.ArrayList;
import org.prelle.simplepersist.Attribute;

public class ItemAttributeNumericalValue<A extends IItemAttribute>
extends ItemAttributeValue<A>
implements ModifyableNumericalValue<A> {
    @Attribute(name="value")
    protected int value;

    public ItemAttributeNumericalValue(ItemAttributeDefinition template) {
        super(template.getModifyable());
        if (!template.isInteger()) {
            throw new IllegalArgumentException("Not a number definition");
        }
        this.value = template.getFormula().getAsInteger();
    }

    public ItemAttributeNumericalValue(A attr) {
        super(attr);
        this.value = 0;
    }

    public ItemAttributeNumericalValue(A attr, int val) {
        super(attr);
        this.value = val;
    }

    @Override
    public Object clone() {
        ItemAttributeNumericalValue<IItemAttribute> copy = new ItemAttributeNumericalValue<IItemAttribute>(this.attribute, this.value);
        copy.addModifications(new ArrayList<Modification>(this.incomingModifications));
        return copy;
    }

    public String toString() {
        if (this.getModifier() == 0) {
            return "NUM:" + String.valueOf(this.value);
        }
        return "NUM:" + this.value + " (" + this.getModifiedValue() + ")";
    }

    @Override
    public int getDistributed() {
        return this.value;
    }

    @Override
    public void setDistributed(int points) {
        this.value = points;
    }

    @Override
    public int getModifier() {
        int count = 0;
        for (Modification mod : this.incomingModifications) {
            if (mod instanceof ApplyableValueModification) {
                ApplyableValueModification sMod = (ApplyableValueModification)mod;
                System.getLogger("de.rpgframework.genericrpg.items").log(System.Logger.Level.WARNING, "ToDo: ApplyableValueModification");
                continue;
            }
            if (mod instanceof ValueModification) {
                ValueModification vMod = (ValueModification)mod;
                if (vMod.getResolvedKey() == this.attribute) {
                    count += vMod.getValue();
                    continue;
                }
                System.getLogger("de.rpgframework.genericrpg.items").log(System.Logger.Level.WARNING, "mismatch of ItemAttribute");
                continue;
            }
            System.getLogger("de.rpgframework.genericrpg.items").log(System.Logger.Level.WARNING, "Unsupported Modification: " + String.valueOf(mod));
        }
        return count;
    }

    @Override
    public int getModifiedValue() {
        return this.value + this.getModifier();
    }

    @Override
    public int getModifiedValue(ValueType ... type) {
        return this.getModifiedValue();
    }
}

