/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.items.AGearData;
import de.rpgframework.genericrpg.items.AlternateUsage;
import de.rpgframework.genericrpg.items.CarryMode;
import de.rpgframework.genericrpg.items.IItemAttribute;
import de.rpgframework.genericrpg.items.IUsageMode;
import de.rpgframework.genericrpg.items.IVariantMode;
import de.rpgframework.genericrpg.items.ItemAttributeDefinition;
import de.rpgframework.genericrpg.items.OperationMode;
import de.rpgframework.genericrpg.items.PieceOfGearVariant;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.prelle.simplepersist.Attribute;
import org.prelle.simplepersist.ElementList;

public abstract class PieceOfGear<V extends IVariantMode, U extends IUsageMode, A extends PieceOfGearVariant<V>, B extends AlternateUsage<U>>
extends AGearData {
    public static final UUID VARIANT = UUID.randomUUID();
    @ElementList(entry="variant", type=PieceOfGearVariant.class, inline=true)
    protected List<A> variants = new ArrayList<A>();
    @Attribute(name="reqVariant")
    protected boolean requireVariant;
    @ElementList(entry="alternate", type=AlternateUsage.class, inline=true)
    protected List<B> alternates = new ArrayList<B>();
    @Attribute
    protected int price;
    @ElementList(entry="mode", type=OperationMode.class, inline=true)
    protected List<OperationMode> modes = new ArrayList<OperationMode>();
    @Attribute(name="modonly")
    private boolean modOnly;
    @Attribute(name="count")
    protected boolean countable;
    @Attribute
    private Integer units;
    private transient boolean validated;
    protected transient ModifiedObjectType refType;

    public Collection<A> getVariants() {
        return this.variants;
    }

    public A getVariant(String id) {
        for (PieceOfGearVariant variant : this.variants) {
            if (!variant.getId().equals(id)) continue;
            return (A)variant;
        }
        return null;
    }

    public A getVariant(CarryMode carry) {
        for (PieceOfGearVariant variant : this.variants) {
            if (variant.getUsage(carry) == null) continue;
            return (A)variant;
        }
        return null;
    }

    public void addVariant(A variant) {
        if (!this.variants.contains(variant)) {
            this.variants.add(variant);
        }
    }

    @Override
    public Collection<ItemAttributeDefinition> getAttributes(String variantID) {
        if (variantID == null) {
            return this.getAttributes();
        }
        LinkedHashMap temp = new LinkedHashMap();
        this.cache.entrySet().forEach(entry -> temp.put((IItemAttribute)entry.getKey(), (ItemAttributeDefinition)entry.getValue()));
        A variant = this.getVariant(variantID);
        ((PieceOfGearVariant)variant).cache.entrySet().forEach(entry -> temp.put((IItemAttribute)entry.getKey(), (ItemAttributeDefinition)entry.getValue()));
        return temp.values();
    }

    @Override
    public Choice getChoice(UUID uuid) {
        Choice ret = super.getChoice(uuid);
        if (ret != null) {
            return ret;
        }
        for (PieceOfGearVariant variant : this.variants) {
            ret = variant.getChoice(uuid);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public List<B> getAlternates() {
        return new ArrayList<B>(this.alternates);
    }

    public List<OperationMode> getOperationModes() {
        return new ArrayList<OperationMode>(this.modes);
    }

    @Override
    public void validate() {
        if (this.validated) {
            return;
        }
        super.validate();
        for (PieceOfGearVariant variant : this.variants) {
            variant.validate();
            this.datasets.forEach(ds -> ds.getLocales().forEach(loc -> this.getVariantName(variant, (Locale)loc)));
        }
        for (AlternateUsage alt : this.alternates) {
            alt.validate();
        }
        this.validated = true;
    }

    public String dump() {
        StringBuffer buf = new StringBuffer(this.id);
        for (ItemAttributeDefinition attr : this.cache.values()) {
            buf.append("\n  " + String.valueOf(attr.getModifyable()) + " : " + attr.isInteger() + "  " + String.valueOf(attr));
        }
        return buf.toString();
    }

    public boolean isModOnly() {
        return this.modOnly;
    }

    public boolean isCountable() {
        return this.countable;
    }

    public int getUnits() {
        if (this.units == null) {
            return 1;
        }
        return this.units;
    }

    public ModifiedObjectType getReferenceType() {
        return this.refType;
    }

    public boolean requiresVariant() {
        return this.requireVariant;
    }
}

