/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.data.ApplyTo;
import de.rpgframework.genericrpg.data.Lifeform;
import de.rpgframework.genericrpg.items.AAvailableSlot;
import de.rpgframework.genericrpg.items.CarriedItem;
import de.rpgframework.genericrpg.items.CarriedItemProcessor;
import de.rpgframework.genericrpg.items.GearTool;
import de.rpgframework.genericrpg.items.Hook;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import java.util.Collection;
import java.util.List;

public class RecurseEmbeddedItems
implements CarriedItemProcessor {
    protected static final System.Logger logger = System.getLogger(RecurseEmbeddedItems.class.getPackageName());

    @Override
    public OperationResult<List<Modification>> process(boolean strict, ModifiedObjectType refType, Lifeform charac, CarriedItem<?> model, List<Modification> unprocessed) {
        OperationResult<List<Modification>> ret = new OperationResult<List<Modification>>(unprocessed);
        for (CarriedItem<?> accessory : model.getAccessories()) {
            Hook hook = accessory.getUsedSlot();
            logger.log(System.Logger.Level.INFO, "accessory {0} in slot {1}", accessory.getKey(), hook);
            OperationResult<List<Modification>> sub = GearTool.recalculate("", refType, charac, accessory, strict);
            Object slot = model.getSlot(hook);
            if (slot == null) {
                logger.log(System.Logger.Level.ERROR, "Item {0} shall be put in non-existing slot {1}", accessory.getKey(), hook);
            } else {
                ((AAvailableSlot)slot).addEmbeddedItem(accessory);
                logger.log(System.Logger.Level.INFO, "Embed ''{0}'' into slot {1} of ''{2}''", accessory.getKey(), hook, model.getKey());
            }
            ret.get().addAll((Collection<Modification>)sub.get());
            logger.log(System.Logger.Level.INFO, "Added mods = " + String.valueOf(sub.get()));
            block5: for (Modification mod : accessory.getOutgoingModifications()) {
                ApplyTo target = mod.getApplyTo();
                if (target == null) {
                    target = ApplyTo.PARENT;
                }
                switch (target) {
                    case CHARACTER: 
                    case PERSONA: 
                    case MELEE: 
                    case UNARMED: 
                    case POINTS: 
                    case DRAKE: {
                        logger.log(System.Logger.Level.INFO, "Added char mod {0}", mod);
                        model.addOutgoingModification(mod);
                        continue block5;
                    }
                    case PARENT: 
                    case ACTIVE_GEAR: 
                    case DATA_ITEM: {
                        logger.log(System.Logger.Level.INFO, "Added gear mod {0}", mod);
                        model.addIncomingModification(mod);
                        continue block5;
                    }
                }
                System.err.println("RecurseEmbeddedItems: Unknown target " + String.valueOf((Object)target));
            }
        }
        return ret;
    }
}

