/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.data.Lifeform;
import de.rpgframework.genericrpg.items.CarriedItem;
import de.rpgframework.genericrpg.items.CarriedItemProcessor;
import de.rpgframework.genericrpg.items.PieceOfGear;
import de.rpgframework.genericrpg.items.PieceOfGearVariant;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import java.util.List;

public class ResolveVariantStep
implements CarriedItemProcessor {
    private static final System.Logger logger = CarriedItem.logger;

    @Override
    public OperationResult<List<Modification>> process(boolean strict, ModifiedObjectType refType, Lifeform user, CarriedItem<?> model, List<Modification> unprocessed) {
        OperationResult<List<Modification>> ret = new OperationResult<List<Modification>>(unprocessed);
        if (model.getVariantID() == null) {
            return ret;
        }
        if (model.getVariant() != null && model.getVariant().getId().equals(model.getVariantID())) {
            return ret;
        }
        PieceOfGear template = (PieceOfGear)model.getModifyable();
        logger.log(System.Logger.Level.DEBUG, "Resolve variant {0}/{1}", model.getTemplateID(), model.getVariantID());
        model.setVariant((PieceOfGearVariant)template.getVariant(model.getVariantID()));
        return ret;
    }
}

