/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items.formula;

import de.rpgframework.genericrpg.items.Formula;
import de.rpgframework.genericrpg.items.formula.FormulaElement;
import de.rpgframework.genericrpg.items.formula.FormulaException;
import de.rpgframework.genericrpg.items.formula.FormulaTool;
import de.rpgframework.genericrpg.items.formula.NumberElement;
import de.rpgframework.genericrpg.items.formula.NumericalValueElement;
import de.rpgframework.genericrpg.items.formula.ObjectElement;
import de.rpgframework.genericrpg.items.formula.OperandElement;
import de.rpgframework.genericrpg.persist.IntegerArrayConverter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.prelle.simplepersist.StringValueConverter;

public class FormulaImpl
implements Formula {
    protected static final System.Logger logger = System.getLogger(FormulaTool.class.getPackageName());
    private List<FormulaElement> elements = new ArrayList<FormulaElement>();
    private Object cached;

    public void addElement(FormulaElement val) {
        this.elements.add(val);
    }

    List<FormulaElement> getElements() {
        return this.elements;
    }

    FormulaElement getLastElement() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.get(this.elements.size() - 1);
    }

    public String toString() {
        return String.valueOf(this.elements);
    }

    @Override
    public boolean isResolved() {
        return this.elements.stream().allMatch(el -> !el.needsResolving());
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Object getValue() {
        logger.log(System.Logger.Level.INFO, "getValue {0}", this.elements);
        if (this.elements.isEmpty()) {
            return null;
        }
        if (this.cached != null) {
            return this.cached;
        }
        if (this.elements.size() == 2 && this.elements.get(0).getType() == FormulaElement.Type.OPERATION && ((OperandElement)this.elements.get(0)).getOperation() == FormulaElement.Operation.SUBSTRACT) {
            NumberElement toNegate = (NumberElement)this.elements.get(1);
            if (toNegate.isFloat()) {
                toNegate.setValue(toNegate.getValueAsFloat() * -1.0f);
            } else {
                toNegate.setValue(toNegate.getValueAsInt() * -1);
            }
            this.elements.remove(0);
        }
        Iterator<FormulaElement> it = this.elements.iterator();
        FormulaElement last = it.next();
        while (it.hasNext()) {
            FormulaElement tmp = it.next();
            logger.log(System.Logger.Level.INFO, "New element {0}", tmp);
            if (tmp.getType() != FormulaElement.Type.OPERATION) {
                logger.log(System.Logger.Level.ERROR, "Error converting {0}", tmp);
                throw new FormulaException(tmp.toString(), "Syntax error - expect operand after " + String.valueOf(last) + " but found " + String.valueOf((Object)tmp.getType()), tmp.getStartPos());
            }
            FormulaElement op2 = it.next();
            last = FormulaImpl.performOperation(((OperandElement)tmp).getOperation(), last, op2);
        }
        this.cached = last.getValue();
        return this.cached;
    }

    private static FormulaElement performOperation(FormulaElement.Operation operation, FormulaElement op1, FormulaElement op2) {
        if (op1 instanceof NumericalValueElement && op2 instanceof NumericalValueElement) {
            float num1 = ((NumericalValueElement)((Object)op1)).getValueAsFloat();
            float num2 = ((NumericalValueElement)((Object)op2)).getValueAsFloat();
            switch (operation) {
                case ADD: {
                    return new NumberElement(num1 + num2, op1.getStartPos());
                }
                case SUBSTRACT: {
                    return new NumberElement(num1 - num2, op1.getStartPos());
                }
                case MULTIPLY: {
                    return new NumberElement(num1 * num2, op1.getStartPos());
                }
                case DIVIDE: {
                    return new NumberElement(num1 / num2, op1.getStartPos());
                }
                case EXPONENTIATE: {
                    return new NumberElement((int)num1 ^ (int)num2, op1.getStartPos());
                }
            }
        }
        return null;
    }

    @Override
    public boolean isInteger() {
        if (this.elements.isEmpty()) {
            return false;
        }
        if (this.elements.get(0) instanceof NumberElement) {
            NumberElement num = (NumberElement)this.elements.get(0);
            return num.getValueAsFloat() == (float)num.getValueAsInt();
        }
        return false;
    }

    @Override
    public int getAsInteger() {
        try {
            return ((NumberElement)this.elements.get(0)).getValueAsInt();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public boolean isFloat() {
        if (this.elements.isEmpty()) {
            return false;
        }
        if (this.elements.get(0) instanceof NumberElement && this.elements.get(0).getRaw() != null) {
            return this.elements.get(0).getRaw().contains(".");
        }
        return false;
    }

    @Override
    public float getAsFloat() {
        try {
            return ((NumberElement)this.elements.get(0)).getValueAsFloat();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    @Override
    public boolean isObject() {
        return !this.elements.isEmpty() && this.elements.get(0) instanceof ObjectElement;
    }

    public String getAsString() {
        StringBuffer buf = new StringBuffer();
        for (FormulaElement e : this.elements) {
            buf.append(e.getRaw());
        }
        return buf.toString();
    }

    @Override
    public <T> T getAsObject(StringValueConverter<T> convert) {
        if (this.cached != null) {
            return (T)this.cached;
        }
        if (!this.isResolved()) {
            throw new IllegalStateException("Not resolved yet: " + String.valueOf(this.elements));
        }
        if (this.isObject()) {
            this.cached = ((ObjectElement)this.elements.get(0)).getValue();
            return (T)this.cached;
        }
        String toParse = this.getAsString();
        try {
            if (toParse.contains(",")) {
                if (convert instanceof IntegerArrayConverter) {
                    this.cached = convert.read(this.getAsString());
                } else {
                    String[] elements = toParse.trim().split(",");
                    ArrayList<Object> ret = new ArrayList<Object>();
                    for (String key : elements) {
                        ret.add(convert.read(key.trim()));
                    }
                    this.cached = ret;
                }
            } else {
                this.cached = convert.read(this.getAsString());
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.WARNING, "Failed converting formula \"" + String.valueOf(this.elements) + "\" to object using " + String.valueOf(convert), (Throwable)e);
            throw new RuntimeException(e);
        }
        return (T)this.cached;
    }
}

