/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items.formula;

import de.rpgframework.genericrpg.items.Formula;
import de.rpgframework.genericrpg.items.IItemAttribute;
import de.rpgframework.genericrpg.items.ItemAttributeFloatValue;
import de.rpgframework.genericrpg.items.ItemAttributeFormulaValue;
import de.rpgframework.genericrpg.items.ItemAttributeNumericalValue;
import de.rpgframework.genericrpg.items.ItemAttributeObjectValue;
import de.rpgframework.genericrpg.items.ItemAttributeValue;
import de.rpgframework.genericrpg.items.formula.FormulaElement;
import de.rpgframework.genericrpg.items.formula.FormulaException;
import de.rpgframework.genericrpg.items.formula.FormulaImpl;
import de.rpgframework.genericrpg.items.formula.NumberElement;
import de.rpgframework.genericrpg.items.formula.OperandElement;
import de.rpgframework.genericrpg.items.formula.StringElement;
import de.rpgframework.genericrpg.items.formula.SubFormulaElement;
import de.rpgframework.genericrpg.items.formula.VariableElement;
import de.rpgframework.genericrpg.items.formula.VariableResolver;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;

public class FormulaTool {
    protected static final System.Logger logger = System.getLogger(FormulaTool.class.getPackageName());
    private static final String OPERANDS = "*/+-^";

    public static ItemAttributeValue convertToAttributeValue(IItemAttribute attrib, Formula form) {
        if (form.isInteger()) {
            return new ItemAttributeNumericalValue<IItemAttribute>(attrib, form.getAsInteger());
        }
        if (form.isFloat()) {
            return new ItemAttributeFloatValue<IItemAttribute>(attrib, form.getAsFloat());
        }
        if (form.isObject()) {
            return new ItemAttributeObjectValue(attrib, form.getValue());
        }
        return new ItemAttributeFormulaValue<IItemAttribute>(attrib, form);
    }

    public static FormulaImpl tokenize(String formula) {
        FormulaImpl ret = new FormulaImpl();
        State state = State.UNKNOWN;
        StringBuffer buf = new StringBuffer();
        FormulaElement current = null;
        Stack<SubFormulaElement> subFormStack = new Stack<SubFormulaElement>();
        int last = 0;
        block36: for (int i = 0; i < formula.length(); ++i) {
            char c = formula.charAt(i);
            logger.log(System.Logger.Level.TRACE, "Found {0} while current={1} and state {2}", new Object[]{Character.valueOf(c), current, state});
            switch (state.ordinal()) {
                case 0: {
                    SubFormulaElement closed;
                    if (Character.isDigit(c)) {
                        buf = new StringBuffer();
                        if (ret.getLastElement() != null && ret.getLastElement().getType() == FormulaElement.Type.OPERATION && ret.getElements().size() == 1 && ((OperandElement)ret.getLastElement()).getOperation() == FormulaElement.Operation.SUBSTRACT) {
                            current = new NumberElement(i);
                            ret.getElements().clear();
                            buf.append('-');
                        }
                        current = new NumberElement(i);
                        ret.addElement(current);
                        buf.append(c);
                        state = State.NUMBER;
                        continue block36;
                    }
                    if (c == '$' || c == '&') {
                        current = new VariableElement(i);
                        ret.addElement(current);
                        buf = new StringBuffer();
                        buf.append(c);
                        state = State.VARIABLE;
                        continue block36;
                    }
                    if (c == '(') {
                        current = new SubFormulaElement(ret, i);
                        subFormStack.push((SubFormulaElement)current);
                        ret.addElement(current);
                        ret = (FormulaImpl)((SubFormulaElement)current).getValue();
                        buf = new StringBuffer();
                        buf.append(c);
                        state = State.UNKNOWN;
                        continue block36;
                    }
                    if (c == ')') {
                        logger.log(System.Logger.Level.DEBUG, "SubFormula ends: " + String.valueOf(subFormStack.peek()));
                        closed = (SubFormulaElement)subFormStack.pop();
                        ret = closed.getParent();
                        logger.log(System.Logger.Level.DEBUG, "       ret now : " + String.valueOf(ret));
                        continue block36;
                    }
                    if (OPERANDS.indexOf(c) >= 0) {
                        switch (c) {
                            case '+': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.ADD, i));
                                state = State.UNKNOWN;
                                break;
                            }
                            case '-': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.SUBSTRACT, i));
                                state = State.UNKNOWN;
                                break;
                            }
                            case '*': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.MULTIPLY, i));
                                state = State.UNKNOWN;
                                break;
                            }
                            case '/': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.DIVIDE, i));
                                state = State.UNKNOWN;
                                break;
                            }
                            case '^': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.EXPONENTIATE, i));
                                state = State.UNKNOWN;
                            }
                        }
                        state = State.UNKNOWN;
                        continue block36;
                    }
                    if (Character.isWhitespace(c)) continue block36;
                    current = new StringElement(i);
                    ret.addElement(current);
                    buf = new StringBuffer();
                    buf.append(c);
                    state = State.STRING;
                    continue block36;
                }
                case 1: {
                    SubFormulaElement closed;
                    if (Character.isDigit(c) || c == '.') {
                        buf.append(c);
                        continue block36;
                    }
                    ((NumberElement)current).setRaw(buf.toString());
                    try {
                        ((NumberElement)current).setValue(Float.parseFloat(buf.toString()));
                    }
                    catch (NumberFormatException e) {
                        throw new FormulaException(formula, "Not a valid number '" + current.getRaw() + "' @" + current.getStartPos(), current.getStartPos());
                    }
                    if (Character.isWhitespace(c)) {
                        state = State.UNKNOWN;
                        continue block36;
                    }
                    if (OPERANDS.indexOf(c) >= 0) {
                        switch (c) {
                            case '+': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.ADD, i));
                                state = State.UNKNOWN;
                                break;
                            }
                            case '-': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.SUBSTRACT, i));
                                state = State.UNKNOWN;
                                break;
                            }
                            case '*': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.MULTIPLY, i));
                                state = State.UNKNOWN;
                                break;
                            }
                            case '/': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.DIVIDE, i));
                                state = State.UNKNOWN;
                                break;
                            }
                            case '^': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.EXPONENTIATE, i));
                                state = State.UNKNOWN;
                            }
                        }
                        state = State.UNKNOWN;
                        continue block36;
                    }
                    if (c == ')') {
                        if (subFormStack.isEmpty()) {
                            logger.log(System.Logger.Level.ERROR, "Closing bracket, but there seems to be no open one left: " + formula);
                            throw new IllegalArgumentException("Closing bracket " + last + ", but there seems to be no open one left: " + formula);
                        }
                        logger.log(System.Logger.Level.DEBUG, "SubFormula ends: " + String.valueOf(subFormStack.peek()));
                        closed = (SubFormulaElement)subFormStack.pop();
                        ret = closed.getParent();
                        logger.log(System.Logger.Level.DEBUG, "       ret now : " + String.valueOf(ret));
                        continue block36;
                    }
                    current = new StringElement(i);
                    ret.addElement(current);
                    buf = new StringBuffer();
                    buf.append(c);
                    state = State.STRING;
                    continue block36;
                }
                case 2: {
                    if (Character.isJavaIdentifierPart(c)) {
                        buf.append(c);
                        continue block36;
                    }
                    ((VariableElement)current).setRaw(buf.toString());
                    if (Character.isWhitespace(c)) {
                        state = State.UNKNOWN;
                        continue block36;
                    }
                    if (OPERANDS.indexOf(c) >= 0) {
                        switch (c) {
                            case '+': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.ADD, i));
                                state = State.UNKNOWN;
                                break;
                            }
                            case '-': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.SUBSTRACT, i));
                                state = State.UNKNOWN;
                                break;
                            }
                            case '*': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.MULTIPLY, i));
                                state = State.UNKNOWN;
                                break;
                            }
                            case '/': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.DIVIDE, i));
                                state = State.UNKNOWN;
                                break;
                            }
                            case '^': {
                                ret.addElement(new OperandElement(FormulaElement.Operation.EXPONENTIATE, i));
                                state = State.UNKNOWN;
                            }
                        }
                        state = State.UNKNOWN;
                        continue block36;
                    }
                    if (Character.isDigit(c)) {
                        current = new NumberElement(i);
                        ret.addElement(current);
                        buf = new StringBuffer();
                        buf.append(c);
                        state = State.NUMBER;
                        continue block36;
                    }
                    if (c == '(') {
                        current = new SubFormulaElement(ret, i);
                        subFormStack.push((SubFormulaElement)current);
                        ret.addElement(current);
                        ret = (FormulaImpl)((SubFormulaElement)current).getValue();
                        buf = new StringBuffer();
                        buf.append(c);
                        state = State.UNKNOWN;
                        continue block36;
                    }
                    current = new StringElement(i);
                    ret.addElement(current);
                    buf = new StringBuffer();
                    buf.append(c);
                    state = State.STRING;
                    continue block36;
                }
                case 3: {
                    if (Character.isWhitespace(c)) {
                        current.setRaw(buf.toString());
                        state = State.UNKNOWN;
                        continue block36;
                    }
                    if (Character.isDigit(c)) {
                        current.setRaw(buf.toString());
                        current = new NumberElement(i);
                        ret.addElement(current);
                        buf = new StringBuffer();
                        buf.append(c);
                        state = State.NUMBER;
                        continue block36;
                    }
                    if (c == '$') {
                        current.setRaw(buf.toString());
                        current = new VariableElement(i);
                        ret.addElement(current);
                        buf = new StringBuffer();
                        buf.append(c);
                        state = State.VARIABLE;
                        continue block36;
                    }
                    if (c == '(') {
                        current = new SubFormulaElement(ret, i);
                        subFormStack.push((SubFormulaElement)current);
                        ret.addElement(current);
                        ret = (FormulaImpl)((SubFormulaElement)current).getValue();
                        buf = new StringBuffer();
                        buf.append(c);
                        state = State.UNKNOWN;
                        continue block36;
                    }
                    buf.append(c);
                    continue block36;
                }
                default: {
                    throw new FormulaException(formula, "Parser error: Don't know how to parse in type " + String.valueOf((Object)current.getType()), i);
                }
            }
        }
        switch (state.ordinal()) {
            case 1: {
                current.setRaw(buf.toString());
                try {
                    ((NumberElement)current).setValue(Float.parseFloat(buf.toString()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new FormulaException(formula, "Not a valid number '" + current.getRaw() + "' @" + current.getStartPos(), current.getStartPos());
                }
            }
            case 2: 
            case 3: {
                current.setRaw(buf.toString());
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new FormulaException(formula, "Parser error: Don't know how to close " + String.valueOf((Object)current.getType()), formula.length());
            }
        }
        return ret;
    }

    private static FormulaImpl calculate(FormulaImpl formula, FormulaElement.Operation ... allowed) {
        if (!formula.isResolved()) {
            return formula;
        }
        List<FormulaElement.Operation> allAllowed = Arrays.asList(allowed);
        FormulaImpl resolvedFormula = new FormulaImpl();
        Object last = null;
        for (int i = 0; i < formula.getElements().size(); ++i) {
            FormulaElement elem = formula.getElements().get(i);
            logger.log(System.Logger.Level.DEBUG, "calculate: Check " + String.valueOf(elem));
            if (elem.getType() == FormulaElement.Type.OPERATION && allAllowed.contains((Object)((OperandElement)elem).getOperation())) {
                NumberElement op1 = null;
                FormulaElement rawOp1 = resolvedFormula.getLastElement();
                if (rawOp1 instanceof NumberElement) {
                    op1 = (NumberElement)rawOp1;
                } else if (rawOp1 instanceof StringElement) {
                    Object attribute = ((StringElement)rawOp1).getValue();
                    logger.log(System.Logger.Level.ERROR, "Parse string" + String.valueOf(attribute) + " / " + String.valueOf(attribute.getClass()));
                    System.exit(1);
                } else {
                    logger.log(System.Logger.Level.ERROR, "Parse " + String.valueOf(rawOp1) + " / " + String.valueOf(rawOp1.getClass()));
                    System.exit(1);
                }
                NumberElement op2 = (NumberElement)formula.getElements().get(++i);
                resolvedFormula.getElements().remove(op1);
                switch (((OperandElement)elem).getOperation()) {
                    case ADD: {
                        resolvedFormula.addElement(new NumberElement(op1.getValueAsFloat() + op2.getValueAsFloat(), -1));
                        break;
                    }
                    case SUBSTRACT: {
                        resolvedFormula.addElement(new NumberElement(op1.getValueAsFloat() - op2.getValueAsFloat(), -1));
                        break;
                    }
                    case MULTIPLY: {
                        resolvedFormula.addElement(new NumberElement(op1.getValueAsFloat() * op2.getValueAsFloat(), -1));
                        break;
                    }
                    case DIVIDE: {
                        resolvedFormula.addElement(new NumberElement(op1.getValueAsFloat() / op2.getValueAsFloat(), -1));
                    }
                }
                continue;
            }
            resolvedFormula.addElement(elem);
        }
        return resolvedFormula;
    }

    public static String resolve(ModifiedObjectType toSetAttrib, Formula formula, VariableResolver resolver) {
        if (logger.isLoggable(System.Logger.Level.TRACE)) {
            logger.log(System.Logger.Level.TRACE, "ENTER: Resolve formula: {0}", formula);
        }
        FormulaImpl resolvedFormula = new FormulaImpl();
        for (FormulaElement elem : ((FormulaImpl)formula).getElements()) {
            NumberElement toAdd;
            String foo;
            SubFormulaElement sub;
            logger.log(System.Logger.Level.TRACE, "  Element {0}", elem);
            if (elem.needsResolving()) {
                if (elem instanceof VariableElement) {
                    VariableElement var = (VariableElement)elem;
                    FormulaElement resolvForm = resolver.resolve(toSetAttrib, var.getRaw());
                    if (resolvForm != null) {
                        resolvedFormula.addElement(resolvForm);
                        continue;
                    }
                    if (logger.isLoggable(System.Logger.Level.TRACE)) {
                        logger.log(System.Logger.Level.TRACE, "LEAVE: Failed resolving variable " + String.valueOf(var));
                    }
                    return null;
                }
                if (!(elem instanceof SubFormulaElement)) continue;
                sub = (SubFormulaElement)elem;
                foo = FormulaTool.resolve(toSetAttrib, sub.getSubFormula(), resolver);
                sub.setRaw(foo);
                logger.log(System.Logger.Level.DEBUG, "    Subformula " + String.valueOf(sub) + " resolved to " + foo);
                if (foo == null) {
                    if (logger.isLoggable(System.Logger.Level.TRACE)) {
                        logger.log(System.Logger.Level.TRACE, "LEAVE: Failed resolving subformula " + String.valueOf(sub));
                    }
                    return null;
                }
                try {
                    toAdd = new NumberElement(Float.parseFloat(foo), elem.getStartPos());
                    logger.log(System.Logger.Level.DEBUG, "    replace {0} with {1}", sub, toAdd);
                    resolvedFormula.getElements().remove(sub);
                    resolvedFormula.addElement(toAdd);
                    logger.log(System.Logger.Level.DEBUG, "    formula now {0}", resolvedFormula);
                }
                catch (NumberFormatException e2) {
                    e2.printStackTrace();
                    System.exit(1);
                }
                continue;
            }
            if (elem instanceof SubFormulaElement) {
                sub = (SubFormulaElement)elem;
                foo = FormulaTool.resolve(toSetAttrib, sub.getSubFormula(), resolver);
                sub.setRaw(foo);
                logger.log(System.Logger.Level.DEBUG, "Subformula " + String.valueOf(sub) + " resolved to " + foo);
                try {
                    toAdd = new NumberElement(Float.parseFloat(foo), elem.getStartPos());
                    logger.log(System.Logger.Level.DEBUG, "  replace {0} with {1}", sub, toAdd);
                    resolvedFormula.getElements().remove(sub);
                    resolvedFormula.addElement(toAdd);
                }
                catch (NumberFormatException e3) {
                    e3.printStackTrace();
                    System.exit(1);
                }
                continue;
            }
            resolvedFormula.addElement(elem);
        }
        if (logger.isLoggable(System.Logger.Level.TRACE)) {
            logger.log(System.Logger.Level.TRACE, "Resolved formula; " + String.valueOf(resolvedFormula));
        }
        FormulaImpl r2 = FormulaTool.calculate(resolvedFormula, FormulaElement.Operation.DIVIDE, FormulaElement.Operation.MULTIPLY);
        if (logger.isLoggable(System.Logger.Level.TRACE)) {
            logger.log(System.Logger.Level.TRACE, "Resolve formula2: " + String.valueOf(r2));
        }
        FormulaImpl r3 = FormulaTool.calculate(r2, FormulaElement.Operation.ADD, FormulaElement.Operation.SUBSTRACT);
        if (logger.isLoggable(System.Logger.Level.TRACE)) {
            logger.log(System.Logger.Level.TRACE, "Resolve formula3: " + String.valueOf(r3));
        }
        if (r3.getElements().size() == 1) {
            FormulaElement elem = r3.getLastElement();
            if (elem.getType() == FormulaElement.Type.NUMBER) {
                NumberElement num = (NumberElement)elem;
                if (num.getValueAsFloat() != (float)num.getValueAsInt()) {
                    if (logger.isLoggable(System.Logger.Level.INFO)) {
                        logger.log(System.Logger.Level.INFO, "LEAVE: Resolve formula: {0}", Float.valueOf(num.getValueAsFloat()));
                    }
                    return String.valueOf(num.getValueAsFloat());
                }
                if (logger.isLoggable(System.Logger.Level.INFO)) {
                    logger.log(System.Logger.Level.INFO, "LEAVE: Resolve formula: {0}", num.getValueAsInt());
                }
                return String.valueOf(num.getValueAsInt());
            }
            if (logger.isLoggable(System.Logger.Level.INFO)) {
                logger.log(System.Logger.Level.INFO, "LEAVE: Resolve formula: " + elem.toString());
            }
            return elem.toString();
        }
        if (logger.isLoggable(System.Logger.Level.INFO)) {
            logger.log(System.Logger.Level.INFO, "LEAVE: Resolve formula: " + String.join((CharSequence)" ", r3.getElements().stream().map(e -> e.toString()).collect(Collectors.toList())));
        }
        return String.join((CharSequence)" ", r3.getElements().stream().map(e -> e.toString()).collect(Collectors.toList()));
    }

    private static enum State {
        UNKNOWN,
        NUMBER,
        VARIABLE,
        STRING;

    }
}

