/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items.formula;

import de.rpgframework.genericrpg.items.formula.FormulaElement;
import de.rpgframework.genericrpg.items.formula.NumericalValueElement;

public class NumberElement
extends FormulaElement
implements NumericalValueElement {
    private float value;

    public NumberElement(int startPos) {
        super(FormulaElement.Type.NUMBER, startPos);
    }

    public NumberElement(float value, int startPos) {
        super(FormulaElement.Type.NUMBER, startPos);
        this.setRaw(String.valueOf(value));
        this.value = value;
    }

    public String toString() {
        return String.valueOf(Math.round(this.value));
    }

    @Override
    public boolean needsResolving() {
        return false;
    }

    @Override
    public Object getValue() {
        if (Math.floor(this.value) == (double)this.value) {
            return (int)Math.floor(this.value);
        }
        return Float.valueOf(this.value);
    }

    @Override
    public float getValueAsFloat() {
        return this.value;
    }

    public boolean isFloat() {
        return (float)((int)this.value) != this.value;
    }

    @Override
    public int getValueAsInt() {
        return Math.round(this.value);
    }

    public void setValue(float value) {
        this.value = value;
    }
}

