/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items.formula;

import de.rpgframework.genericrpg.data.AttributeValue;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.ComplexDataItemValue;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.data.Lifeform;
import de.rpgframework.genericrpg.items.CarriedItem;
import de.rpgframework.genericrpg.items.IItemAttribute;
import de.rpgframework.genericrpg.items.ItemAttributeNumericalValue;
import de.rpgframework.genericrpg.items.ItemAttributeValue;
import de.rpgframework.genericrpg.items.formula.FormulaElement;
import de.rpgframework.genericrpg.items.formula.NumberElement;
import de.rpgframework.genericrpg.items.formula.StringElement;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;

public class VariableResolver {
    protected static final System.Logger logger = System.getLogger(VariableResolver.class.getPackageName());
    private ComplexDataItemValue<? extends ComplexDataItem> model;
    private Lifeform user;

    public VariableResolver(ComplexDataItemValue<? extends ComplexDataItem> contextItem, Lifeform contextUser) {
        this.model = contextItem;
        this.user = contextUser;
    }

    private FormulaElement getItemAttributeFromParents(ModifiedObjectType toSetAttrib, String var) {
        CarriedItem parent = ((CarriedItem)this.model).getParent();
        if (parent == null) {
            logger.log(System.Logger.Level.ERROR, "Need to determine item attribute {0} from parent of CarriedItem {1}, but parent is NULL", var, this.model.getKey());
            return null;
        }
        VariableResolver res = new VariableResolver(parent, this.user);
        return res.resolve(toSetAttrib, var);
    }

    public FormulaElement resolve(ModifiedObjectType toSetAttrib, String var) {
        String tail = var.substring(1);
        if (tail.startsWith("$")) {
            logger.log(System.Logger.Level.DEBUG, "ask parent of {0} for {1}", this.model, tail);
            if (this.model instanceof CarriedItem) {
                FormulaElement ret = this.getItemAttributeFromParents(toSetAttrib, tail);
                logger.log(System.Logger.Level.DEBUG, "{0} is resolved to {1}", tail, ret);
                return ret;
            }
        } else {
            Choice choice;
            if (var.startsWith("&")) {
                logger.log(System.Logger.Level.TRACE, "ask character for {0}", tail);
                AttributeValue val = this.user.getAttribute(tail);
                if (val != null) {
                    logger.log(System.Logger.Level.INFO, var + " resolved to value " + String.valueOf(val));
                    return new NumberElement(val.getDistributed(), -1);
                }
                logger.log(System.Logger.Level.WARNING, var + " cannot be resolved - attribute is not set");
                System.err.println("VariableResolver: " + tail + " cannot be resolved - attribute is not set");
                System.exit(0);
                return null;
            }
            Decision dec = this.model.getDecisionByRef(tail);
            if (dec != null) {
                try {
                    return new NumberElement(Integer.parseInt(dec.getValue()), -1);
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else {
                logger.log(System.Logger.Level.DEBUG, "Resolve as {0}: [{1}] in {2}]", toSetAttrib, tail, this.model.getResolved());
            }
            if (this.model.getResolved() != null && (choice = ((ComplexDataItem)this.model.getResolved()).getChoice(tail)) != null && choice.getChooseFrom() != toSetAttrib) {
                return null;
            }
            if ("LEVEL".equals(tail)) {
                return new NumberElement(this.model.getDistributed(), -1);
            }
            IItemAttribute attrib = (IItemAttribute)toSetAttrib.resolve(tail);
            logger.log(System.Logger.Level.INFO, var + " resolved to ItemAttribute " + String.valueOf(attrib));
            ItemAttributeValue<?> val = ((CarriedItem)this.model).getAttributeRaw(attrib);
            if (val != null) {
                logger.log(System.Logger.Level.INFO, var + " resolved to value " + String.valueOf(val));
                if (val instanceof ItemAttributeNumericalValue) {
                    return new NumberElement(((ItemAttributeNumericalValue)val).getDistributed(), -1);
                }
                return new StringElement(val.toString(), -1);
            }
            return null;
        }
        logger.log(System.Logger.Level.ERROR, "Don't support obtaining a parent for " + String.valueOf(this.model.getClass()));
        return null;
    }
}

