/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.modification;

import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.Modifyable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class ModifyableImpl
implements Modifyable {
    protected transient List<Modification> incomingModifications = new ArrayList<Modification>();
    protected transient List<Modification> outgoingModifications = new ArrayList<Modification>();

    protected ModifyableImpl() {
    }

    @Override
    public List<Modification> getIncomingModifications() {
        return new ArrayList<Modification>(this.incomingModifications);
    }

    public void clearIncomingModifications() {
        this.incomingModifications.clear();
    }

    public void removeIncomingModifications(Modification.Origin origin) {
        this.getIncomingModifications().stream().filter(mod -> mod.getOrigin() == origin).forEach(mod -> this.removeIncomingModification((Modification)mod));
    }

    @Override
    public void setIncomingModifications(List<Modification> mods) {
        this.incomingModifications = mods;
    }

    @Override
    public void addIncomingModification(Modification mod) {
        this.incomingModifications.add(mod);
    }

    public void addModifications(Collection<Modification> mods) {
        this.incomingModifications.addAll(mods);
    }

    @Override
    public void removeIncomingModification(Modification mod) {
        this.incomingModifications.remove(mod);
    }

    public void removeIncomingModificationForSource(Object src) {
        for (Modification mod : new ArrayList<Modification>(this.incomingModifications)) {
            if (!mod.getSource().equals(src)) continue;
            this.incomingModifications.remove(src);
        }
    }

    public void clearOutgoingModifications() {
        this.outgoingModifications.clear();
    }

    public void addOutgoingModification(Modification mod) {
        this.outgoingModifications.add(mod);
    }

    public List<Modification> getOutgoingModifications() {
        return new ArrayList<Modification>(this.outgoingModifications);
    }
}

