/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.character;

import de.rpgframework.character.Attachment;
import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.core.RoleplayingSystem;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public abstract class CharacterHandle {
    protected UUID uuid;
    protected RoleplayingSystem rules;
    protected String name;
    protected String desc = "-";
    protected Date lastModified;
    protected boolean deleted;
    protected boolean shared;
    protected transient RuleSpecificCharacterObject<?, ?, ?, ?> parsedCharac;
    protected transient List<Attachment> attachments;

    public CharacterHandle() {
        this.attachments = new ArrayList<Attachment>();
    }

    public CharacterHandle(UUID uuid, RoleplayingSystem rules, String name, String desc, Date lastModified) {
        this.uuid = uuid;
        this.rules = rules;
        this.name = name;
        this.desc = desc;
        this.lastModified = lastModified;
        this.attachments = new ArrayList<Attachment>();
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        if (this.parsedCharac != null) {
            return this.parsedCharac.getShortDescription();
        }
        return this.desc;
    }

    public void setShortDescription(String desc) {
        this.desc = desc;
    }

    public RoleplayingSystem getRuleIdentifier() {
        return this.rules;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID value) {
        this.uuid = value;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setRuleIdentifier(RoleplayingSystem rules) {
        this.rules = rules;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public RuleSpecificCharacterObject getCharacter() {
        return this.parsedCharac;
    }

    public void setCharacter(RuleSpecificCharacterObject charac) throws IOException {
        this.parsedCharac = charac;
    }

    public abstract Path getPath();

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public void addAttachment(Attachment att) {
        if (att == null) {
            throw new NullPointerException();
        }
        this.attachments.add(att);
    }

    public void removeAttachment(Attachment att) {
        this.attachments.remove(att);
    }

    public Collection<Attachment> getAttachments() {
        return new ArrayList<Attachment>(this.attachments);
    }
}

