/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.character;

import de.rpgframework.character.Attachment;
import de.rpgframework.character.CharacterHandle;
import de.rpgframework.core.RoleplayingSystem;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Supplier;

public class FileBasedCharacterHandle
extends CharacterHandle {
    private static final String NAME = "name";
    static final String UUID = "uuid";
    private static final String SYNC = "sync";
    private static final String DESC = "desc";
    protected static transient System.Logger logger = System.getLogger("eden.client");
    private transient Path path;
    private transient boolean sync = true;
    private transient boolean loadAttemptMade = false;

    public FileBasedCharacterHandle() {
    }

    public FileBasedCharacterHandle(Path path, RoleplayingSystem rules) {
        this.uuid = java.util.UUID.randomUUID();
        this.path = path;
        this.rules = rules;
    }

    public FileBasedCharacterHandle(Path path, RoleplayingSystem rules, UUID uuid) {
        this.uuid = uuid;
        this.attachments = new ArrayList();
        this.path = path;
        this.rules = rules;
    }

    public String toString() {
        return this.name + "@" + this.path + "/" + super.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof FileBasedCharacterHandle) {
            FileBasedCharacterHandle other = (FileBasedCharacterHandle)o;
            return this.toString().equals(other.toString());
        }
        return false;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        if (path == null) {
            throw new NullPointerException("Path must not be null");
        }
        this.path = path;
    }

    public boolean hasSyncFlag() {
        return this.sync;
    }

    public void setSyncFlag(boolean sync) {
        this.sync = sync;
    }

    public Properties getProperties() {
        Properties pro = new Properties();
        if (this.uuid != null) {
            pro.setProperty(UUID, this.uuid.toString());
        }
        pro.setProperty(SYNC, String.valueOf(this.sync));
        pro.setProperty(DESC, this.getShortDescription());
        pro.setProperty(NAME, this.getName());
        for (Attachment attach : this.attachments) {
            pro.setProperty("attachment." + attach.getID() + ".type", attach.getType().name());
            pro.setProperty("attachment." + attach.getID() + ".format", attach.getFormat().name());
            pro.setProperty("attachment." + attach.getID() + ".file", attach.getFilename());
        }
        return pro;
    }

    public static Properties toProperties(CharacterHandle handle, Supplier<List<Attachment>> getAttachments) throws IOException {
        Properties pro = new Properties();
        if (handle.getUUID() != null) {
            pro.setProperty(UUID, handle.getUUID().toString());
        }
        List attachments = List.of();
        if (handle instanceof FileBasedCharacterHandle) {
            pro.setProperty(SYNC, String.valueOf(((FileBasedCharacterHandle)handle).hasSyncFlag()));
            attachments = ((FileBasedCharacterHandle)handle).attachments;
        } else {
            attachments = getAttachments.get();
        }
        pro.setProperty(DESC, handle.getShortDescription());
        pro.setProperty(NAME, handle.getName());
        for (Attachment attach : attachments) {
            pro.setProperty("attachment." + attach.getID() + ".type", attach.getType().name());
            pro.setProperty("attachment." + attach.getID() + ".format", attach.getFormat().name());
            pro.setProperty("attachment." + attach.getID() + ".file", attach.getFilename());
        }
        return pro;
    }

    public static void fromProperties(CharacterHandle handle, Properties pro) {
        logger.log(System.Logger.Level.DEBUG, "ENTER: fromProperties");
        if (pro.containsKey(UUID)) {
            handle.setUUID(java.util.UUID.fromString(pro.getProperty(UUID)));
        }
        if (pro.containsKey(DESC)) {
            handle.setShortDescription(pro.getProperty(DESC));
        }
        if (pro.containsKey(NAME)) {
            handle.setName(pro.getProperty(NAME));
        }
        if (handle instanceof FileBasedCharacterHandle) {
            ArrayList<String> uuids = new ArrayList<String>();
            for (Object keyO : pro.keySet()) {
                String file;
                String key = (String)keyO;
                if (!key.startsWith("attachment.") || uuids.contains(file = key.substring(11, key.lastIndexOf(".")))) continue;
                uuids.add(file);
            }
            FileBasedCharacterHandle fHandle = (FileBasedCharacterHandle)handle;
            fHandle.attachments.clear();
            for (String uuid : uuids) {
                String typeS = pro.getProperty("attachment." + uuid + ".type");
                String formatS = pro.getProperty("attachment." + uuid + ".format");
                String filename = pro.getProperty("attachment." + uuid + ".file");
                Path file = fHandle.path.resolve(filename);
                if (Files.exists(file, new LinkOption[0])) {
                    Attachment entry = new Attachment(handle, java.util.UUID.fromString(uuid), Attachment.Type.valueOf(typeS), Attachment.Format.valueOf(formatS));
                    entry.setFilename(filename);
                    entry.setLocalFile(file);
                    try {
                        entry.setLastModified(new Date(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis()));
                    }
                    catch (IOException e) {
                        logger.log(System.Logger.Level.ERROR, "Failed getting modify time of " + file + ": " + e);
                    }
                    fHandle.attachments.add(entry);
                    continue;
                }
                logger.log(System.Logger.Level.WARNING, "Found metadata for non-existing file " + file + " in character " + handle.getName() + " - remove it");
                pro.remove(typeS);
                pro.remove(formatS);
                pro.remove(uuid);
            }
        }
        logger.log(System.Logger.Level.DEBUG, "ENTER: fromProperties");
    }

    public void setProperties(Properties pro) {
        logger.log(System.Logger.Level.DEBUG, "ENTER: setProperties");
        if (pro.containsKey(UUID)) {
            this.uuid = java.util.UUID.fromString(pro.getProperty(UUID));
        }
        this.sync = Boolean.valueOf(pro.getProperty(SYNC, "false"));
        this.desc = pro.getProperty(DESC, "-");
        this.name = pro.getProperty(NAME);
        ArrayList<String> uuids = new ArrayList<String>();
        for (Object keyO : pro.keySet()) {
            String file;
            String key = (String)keyO;
            if (!key.startsWith("attachment.") || uuids.contains(file = key.substring(11, key.lastIndexOf(".")))) continue;
            uuids.add(file);
        }
        this.attachments.clear();
        for (String uuid : uuids) {
            String typeS = pro.getProperty("attachment." + uuid + ".type");
            String formatS = pro.getProperty("attachment." + uuid + ".format");
            String filename = pro.getProperty("attachment." + uuid + ".file");
            if ("null".equals(uuid)) {
                logger.log(System.Logger.Level.WARNING, "Found metadata with missing attachment UUID in character " + this.name + " - remove it");
                pro.remove(typeS);
                pro.remove(formatS);
                pro.remove(uuid);
                continue;
            }
            Path file = this.path.resolve(filename);
            if (Files.exists(file, new LinkOption[0])) {
                Attachment entry = new Attachment(this, java.util.UUID.fromString(uuid), Attachment.Type.valueOf(typeS), Attachment.Format.valueOf(formatS));
                entry.setFilename(filename);
                entry.setLocalFile(file);
                try {
                    entry.setLastModified(new Date(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis()));
                }
                catch (IOException e) {
                    logger.log(System.Logger.Level.ERROR, "Failed getting modify time of " + file + ": " + e);
                }
                try {
                    entry.setData(Files.readAllBytes(file));
                }
                catch (IOException e) {
                    logger.log(System.Logger.Level.ERROR, "Failed loading bytes from disk for " + file, (Throwable)e);
                }
                this.attachments.add(entry);
                continue;
            }
            logger.log(System.Logger.Level.WARNING, "Found metadata for non-existing file " + file + " in character " + this.name + " - remove it");
            pro.remove(typeS);
            pro.remove(formatS);
            pro.remove(uuid);
        }
        this.loadAttemptMade = true;
        logger.log(System.Logger.Level.DEBUG, "ENTER: setProperties");
    }

    public boolean isLoadAttemptMade() {
        return this.loadAttemptMade;
    }

    public void setLoadAttemptMade(boolean loadAttemptMade) {
        this.loadAttemptMade = loadAttemptMade;
    }
}

