/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.character;

import de.rpgframework.character.Attachment;
import de.rpgframework.character.CharacterHandle;
import de.rpgframework.character.CharacterIOException;
import de.rpgframework.character.DatasetDefinition;
import de.rpgframework.character.FileBasedCharacterHandle;
import de.rpgframework.character.IUserDatabase;
import de.rpgframework.core.RoleplayingSystem;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class LocalUserDatabase
implements IUserDatabase {
    private static final System.Logger logger = System.getLogger(LocalUserDatabase.class.getPackageName());
    private static final String INDEX = "metadata.properties";
    private RoleplayingSystem rules;
    private Map<UUID, FileBasedCharacterHandle> cache;
    private Path localBaseDir;
    private Path myselfPlayerDir;

    public LocalUserDatabase(Path playerDir, RoleplayingSystem rules) throws CharacterIOException {
        this.rules = rules;
        this.cache = new HashMap<UUID, FileBasedCharacterHandle>();
        this.localBaseDir = playerDir;
        this.myselfPlayerDir = this.localBaseDir.resolve("myself");
        logger.log(System.Logger.Level.INFO, "Expect player data at " + this.localBaseDir);
        System.setProperty("chardir", this.myselfPlayerDir.resolve(rules.name().toLowerCase()).toString());
        try {
            Files.createDirectories(this.localBaseDir, new FileAttribute[0]);
            Files.createDirectories(this.myselfPlayerDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.ERROR, "Could not create player directory: " + e);
            throw new CharacterIOException(CharacterIOException.ErrorCode.FILESYSTEM_WRITE, null, "Could not create directories", this.localBaseDir.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized FileBasedCharacterHandle loadCharacter(RoleplayingSystem system, Path charDir) throws CharacterIOException {
        logger.log(System.Logger.Level.TRACE, "ENTER loadCharacter({0}, {1})", system, charDir);
        try {
            UUID uuid = UUID.randomUUID();
            Path meta = charDir.resolve(INDEX);
            Properties pro = new Properties();
            try {
                pro.load(new FileReader(meta.toFile()));
                uuid = UUID.fromString(pro.getProperty("uuid"));
            }
            catch (Exception e) {
                throw new CharacterIOException(CharacterIOException.ErrorCode.FILESYSTEM_READ, "Metadata", e.getMessage(), meta.toString(), e);
            }
            FileBasedCharacterHandle handle = new FileBasedCharacterHandle(charDir, system, uuid);
            handle.setProperties(pro);
            handle.setLoadAttemptMade(true);
            handle.setPath(charDir);
            try {
                handle.setLastModified(Date.from(Files.getLastModifiedTime(charDir, new LinkOption[0]).toInstant()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (Attachment attach : handle.getAttachments()) {
                try {
                    attach.setLastModified(Date.from(Files.getLastModifiedTime(attach.getLocalFile(), new LinkOption[0]).toInstant()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            FileBasedCharacterHandle fileBasedCharacterHandle = handle;
            return fileBasedCharacterHandle;
        }
        finally {
            logger.log(System.Logger.Level.TRACE, "LEAVE loadCharacter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CharacterHandle> getCharacters() throws IOException {
        ArrayList<CharacterHandle> arrayList;
        logger.log(System.Logger.Level.DEBUG, "ENTER: getCharacters()");
        ArrayList<CharacterHandle> ret = new ArrayList<CharacterHandle>();
        try {
            if (!this.cache.isEmpty()) {
                ret.addAll(this.cache.values());
            } else {
                try {
                    DirectoryStream<Path> userDir = Files.newDirectoryStream(this.myselfPlayerDir);
                    for (Path systemDir : userDir) {
                        if (!Files.isDirectory(systemDir, new LinkOption[0]) || systemDir.getFileName().toString().endsWith(".git")) continue;
                        RoleplayingSystem system = null;
                        try {
                            system = RoleplayingSystem.valueOf((String)systemDir.getFileName().toString().toUpperCase());
                        }
                        catch (IllegalArgumentException e1) {
                            logger.log(System.Logger.Level.ERROR, "Found directory that does not match roleplaying system: " + systemDir);
                            continue;
                        }
                        logger.log(System.Logger.Level.DEBUG, "Found directory with " + system + " characters");
                        for (Path charDir : Files.newDirectoryStream(systemDir)) {
                            if (!Files.isDirectory(charDir, new LinkOption[0])) continue;
                            String dirName = charDir.getFileName().toString();
                            try {
                                UUID uuid = null;
                                FileBasedCharacterHandle handle = null;
                                try {
                                    uuid = UUID.fromString(dirName);
                                }
                                catch (Exception e) {
                                    logger.log(System.Logger.Level.ERROR, "Directory is not a UUID: {0}", charDir.getFileName());
                                    uuid = UUID.randomUUID();
                                }
                                if (uuid != null && (handle = this.cache.get(uuid)) != null) {
                                    logger.log(System.Logger.Level.ERROR, "Char {0} found in cache", uuid);
                                }
                                if (handle == null) {
                                    handle = this.loadCharacter(system, charDir);
                                }
                                ret.add(handle);
                                if (handle == null || this.cache.containsKey(uuid)) continue;
                                this.cache.put(uuid, handle);
                                logger.log(System.Logger.Level.INFO, "Added character to cache: " + handle.getName());
                            }
                            catch (Exception e) {
                                logger.log(System.Logger.Level.ERROR, "Failed loading character in " + charDir, (Throwable)e);
                                e.printStackTrace();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Failed loading characters", (Throwable)e);
                }
            }
            Collections.sort(ret, new Comparator<CharacterHandle>(){

                @Override
                public int compare(CharacterHandle handle1, CharacterHandle handle2) {
                    if (handle1.getLastModified() == null && handle2.getLastModified() != null) {
                        return 1;
                    }
                    if (handle2.getLastModified() == null && handle1.getLastModified() != null) {
                        return -1;
                    }
                    if (handle1.getLastModified() == null && handle2.getLastModified() == null) {
                        return 0;
                    }
                    return handle1.getLastModified().compareTo(handle2.lastModified);
                }
            });
            arrayList = ret;
        }
        catch (Throwable throwable) {
            logger.log(System.Logger.Level.DEBUG, "LEAVE: getCharacters() returns {0} elements", ret.size());
            throw throwable;
        }
        logger.log(System.Logger.Level.DEBUG, "LEAVE: getCharacters() returns {0} elements", ret.size());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCharacter(CharacterHandle rawHandle) throws IOException {
        logger.log(System.Logger.Level.DEBUG, "ENTER: createCharacter()");
        if (!(rawHandle instanceof FileBasedCharacterHandle)) {
            throw new IllegalArgumentException("Must be FileBasedCharacterHandle");
        }
        FileBasedCharacterHandle handle = (FileBasedCharacterHandle)rawHandle;
        try {
            Path systemDir = this.myselfPlayerDir.resolve(this.rules.name().toLowerCase());
            if (Files.exists(systemDir, new LinkOption[0])) {
                logger.log(System.Logger.Level.DEBUG, "Create directory for {0} characters at {1}", this.rules, systemDir);
                try {
                    Files.createDirectories(systemDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new CharacterIOException(CharacterIOException.ErrorCode.FILESYSTEM_WRITE, "System directory", e.getMessage(), systemDir.toString(), e);
                }
            } else {
                logger.log(System.Logger.Level.DEBUG, "Directory for {0} characters already exists at {1}", this.rules, systemDir);
            }
            Path charDir = systemDir.resolve(handle.getUUID().toString());
            handle.setPath(charDir);
            if (!Files.exists(charDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(charDir, new FileAttribute[0]);
                }
                catch (AccessDeniedException e) {
                    logger.log(System.Logger.Level.ERROR, "Access denied to " + e.getFile());
                    throw new CharacterIOException(CharacterIOException.ErrorCode.FILESYSTEM_WRITE, "Character directory", e.getMessage(), charDir.toString(), e);
                }
                catch (IOException e) {
                    throw new CharacterIOException(CharacterIOException.ErrorCode.FILESYSTEM_WRITE, "Character directory", e.getMessage(), charDir.toString(), e);
                }
                logger.log(System.Logger.Level.INFO, "Created character directory " + charDir);
            }
            this.modifyCharacter(handle);
        }
        finally {
            logger.log(System.Logger.Level.DEBUG, "LEAVE: createCharacter()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyCharacter(CharacterHandle rawHandle) throws IOException {
        logger.log(System.Logger.Level.DEBUG, "ENTER: modifyCharacter()");
        if (!(rawHandle instanceof FileBasedCharacterHandle)) {
            throw new IllegalArgumentException("Must be FileBasedCharacterHandle");
        }
        FileBasedCharacterHandle handle = (FileBasedCharacterHandle)rawHandle;
        try {
            Path charDir = handle.getPath();
            if (!Files.exists(charDir, new LinkOption[0])) {
                logger.log(System.Logger.Level.ERROR, "Trying to modify a character in a non-existing directory");
                throw new FileNotFoundException("Character directory does not exist: " + charDir);
            }
            Path meta = charDir.resolve(INDEX);
            try {
                FileBasedCharacterHandle.toProperties(handle, () -> {
                    try {
                        return this.getAttachments(handle);
                    }
                    catch (IOException e) {
                        logger.log(System.Logger.Level.ERROR, "Error getting attachments", (Throwable)e);
                        return List.of();
                    }
                }).store(new FileWriter(meta.toFile()), "Do not edit");
            }
            catch (IOException e) {
                throw new CharacterIOException(CharacterIOException.ErrorCode.FILESYSTEM_WRITE, "Metadata", e.getMessage(), meta.toString(), e);
            }
            this.cache.put(handle.getUUID(), handle);
        }
        finally {
            logger.log(System.Logger.Level.DEBUG, "LEAVE: modifyCharacter()");
        }
    }

    @Override
    public void deleteCharacter(CharacterHandle rawHandle) throws IOException {
        if (!(rawHandle instanceof FileBasedCharacterHandle)) {
            throw new IllegalArgumentException("Must be FileBasedCharacterHandle");
        }
        logger.log(System.Logger.Level.INFO, "deleteCharacter: " + rawHandle);
        FileBasedCharacterHandle handle = (FileBasedCharacterHandle)rawHandle;
        Path charDir = handle.getPath();
        logger.log(System.Logger.Level.INFO, "Need to delete " + charDir);
        try {
            Files.walkFileTree(charDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
            Files.deleteIfExists(charDir);
            this.cache.remove(rawHandle.getUUID());
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.ERROR, "");
        }
    }

    @Override
    public CharacterHandle retrieveCharacter(UUID key) throws IOException {
        return this.cache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAttachment(CharacterHandle rawHandle, Attachment attach) throws IOException {
        logger.log(System.Logger.Level.DEBUG, "ENTER: createAttachment({0}, {1}, {2} bytes)", rawHandle.getName(), attach.getFilename(), attach.getData() != null ? attach.getData().length : 0);
        try {
            if (!(rawHandle instanceof FileBasedCharacterHandle)) {
                throw new IllegalArgumentException("Must be FileBasedCharacterHandle");
            }
            FileBasedCharacterHandle handle = (FileBasedCharacterHandle)rawHandle;
            byte[] data = attach.getData();
            if (attach.getFilename() == null) {
                throw new NullPointerException("No filename set");
            }
            String filename = attach.getFilename();
            handle.addAttachment(attach);
            Path charDir = handle.getPath();
            Path target = charDir.resolve(filename);
            attach.setLocalFile(target);
            if (attach.getData() != null) {
                try {
                    logger.log(System.Logger.Level.DEBUG, "Write to {0}", target);
                    Files.write(target, data, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new CharacterIOException(CharacterIOException.ErrorCode.FILESYSTEM_WRITE, "Character data: " + attach.getType(), e.toString(), target.toString(), e);
                }
                if (attach.getLastModified() != null) {
                    try {
                        logger.log(System.Logger.Level.INFO, "Set timestamp to {0}", attach.getLastModified());
                        Files.setLastModifiedTime(target, FileTime.fromMillis(attach.getLastModified().getTime()));
                    }
                    catch (IOException e) {
                        logger.log(System.Logger.Level.WARNING, "Failed changing modification time of " + target, (Throwable)e);
                    }
                } else {
                    handle.setLastModified(new Date(System.currentTimeMillis()));
                }
            }
            try {
                Path meta = handle.getPath().resolve(INDEX);
                handle.getProperties().store(new FileWriter(meta.toFile()), "Do not edit");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Failed creating metadata.properties", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            logger.log(System.Logger.Level.DEBUG, "LEAVE: createAttachment({0}, {1})", rawHandle.getName(), attach.getFilename());
            throw throwable;
        }
        logger.log(System.Logger.Level.DEBUG, "LEAVE: createAttachment({0}, {1})", rawHandle.getName(), attach.getFilename());
    }

    private Attachment parseAttachment(FileBasedCharacterHandle handle, Path file) throws CharacterIOException {
        byte[] data;
        String filename = file.getFileName().toString();
        Attachment.Type type = Attachment.Type.CHARACTER;
        try {
            data = Files.readAllBytes(file);
        }
        catch (IOException e) {
            throw new CharacterIOException(CharacterIOException.ErrorCode.FILESYSTEM_READ, "Read character data from disk", e.toString(), file.toString(), e);
        }
        Attachment attach = null;
        if (filename.endsWith(".xml")) {
            attach = new Attachment(handle, UUID.randomUUID(), type, Attachment.Format.RULESPECIFIC);
        } else if (filename.endsWith(".html")) {
            attach = new Attachment(handle, UUID.randomUUID(), type, Attachment.Format.HTML);
        } else if (filename.endsWith(".txt")) {
            attach = new Attachment(handle, UUID.randomUUID(), type, Attachment.Format.TEXT);
        } else if (filename.endsWith(".pdf")) {
            attach = new Attachment(handle, UUID.randomUUID(), type, Attachment.Format.PDF);
        } else if (filename.endsWith(".img")) {
            attach = new Attachment(handle, UUID.randomUUID(), type, Attachment.Format.IMAGE);
        } else if (filename.endsWith(".jpg") || filename.endsWith(".png")) {
            attach = new Attachment(handle, UUID.randomUUID(), type, Attachment.Format.IMAGE);
        } else {
            if (filename.endsWith("~")) {
                logger.log(System.Logger.Level.WARNING, " Removed Emacs backup file: " + filename);
                try {
                    Files.delete(file);
                }
                catch (IOException e) {
                    logger.log(System.Logger.Level.WARNING, "Failed deleting file '{}' from disk", file, e);
                }
                return null;
            }
            logger.log(System.Logger.Level.WARNING, " Found an unsupported file format for character: " + filename);
            attach = new Attachment(handle, UUID.randomUUID(), type, Attachment.Format.RULESPECIFIC_EXTERNAL);
        }
        attach.setFilename(filename);
        logger.log(System.Logger.Level.TRACE, " " + file + " is a " + type + " " + attach.getFormat());
        attach.setData(data);
        try {
            attach.setLastModified(new Date(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis()));
        }
        catch (IOException e) {
            logger.log(System.Logger.Level.WARNING, "Failed changing file time '{}' on disk", file, e);
        }
        logger.log(System.Logger.Level.DEBUG, " Parsed " + attach);
        return attach;
    }

    private Attachment getFirstAttachment(FileBasedCharacterHandle handle, Attachment.Type type, Attachment.Format format) throws CharacterIOException {
        for (Attachment attach : handle.getAttachments()) {
            if (attach.getType() != type || attach.getFormat() != format) continue;
            return attach;
        }
        return null;
    }

    private void detectAdditionalAttachments(FileBasedCharacterHandle fileHandle) throws CharacterIOException {
        Path charDir = fileHandle.getPath();
        logger.log(System.Logger.Level.WARNING, "TODO: Check for attachments not in the metadata file");
        ArrayList<String> knownFilenames = new ArrayList<String>();
        for (Attachment attach : fileHandle.getAttachments()) {
            logger.log(System.Logger.Level.DEBUG, "  {0}: {1}  \t{2}  {3}", new Object[]{attach.getID(), attach.getFilename(), attach.getType(), attach.getFormat()});
            if (knownFilenames.contains(attach.getFilename())) {
                logger.log(System.Logger.Level.WARNING, "    Remove duplicate attachment ''{0}'' with UUID {1}", attach.getFilename(), attach.getID());
                fileHandle.removeAttachment(attach);
                Path meta = charDir.resolve(INDEX);
                try {
                    fileHandle.getProperties().store(new FileWriter(meta.toFile()), "Do not edit");
                    continue;
                }
                catch (IOException e) {
                    throw new CharacterIOException(CharacterIOException.ErrorCode.FILESYSTEM_WRITE, "Metadata", e.getMessage(), meta.toString(), e);
                }
            }
            knownFilenames.add(attach.getFilename());
        }
        logger.log(System.Logger.Level.DEBUG, "-----Check remaining files-----------");
        DirectoryStream<Path> dir = null;
        try {
            dir = Files.newDirectoryStream(charDir);
        }
        catch (IOException e) {
            throw new CharacterIOException(CharacterIOException.ErrorCode.FILESYSTEM_READ, "Character directory", e.toString(), charDir.toString(), e);
        }
        for (Path tmp : dir) {
            Attachment old;
            Attachment attach;
            if (!Files.isRegularFile(tmp, new LinkOption[0]) || tmp.getFileName().toString().equals(INDEX) || tmp.getFileName().toString().equals(".git") || tmp.getFileName().toString().endsWith("~")) continue;
            boolean isNew = true;
            for (Attachment entry : fileHandle.getAttachments()) {
                Path comp = charDir.resolve(entry.getFilename());
                if (!comp.equals(tmp)) continue;
                isNew = false;
                break;
            }
            if (!isNew || (attach = this.parseAttachment(fileHandle, tmp)) == null) continue;
            if (attach.getType() == Attachment.Type.CHARACTER && attach.getFormat() == Attachment.Format.RULESPECIFIC && (old = this.getFirstAttachment(fileHandle, Attachment.Type.CHARACTER, Attachment.Format.RULESPECIFIC)) != null) {
                logger.log(System.Logger.Level.WARNING, "Found rulespecific character data in " + tmp + " but already use that from " + old.getFilename());
                continue;
            }
            logger.log(System.Logger.Level.WARNING, "Add previously unknown file " + tmp + " as character attachment " + attach);
            fileHandle.addAttachment(attach);
        }
    }

    private void ensureMetadataLoaded(FileBasedCharacterHandle fileHandle) throws IOException {
        Path indexFile;
        if (fileHandle.isLoadAttemptMade()) {
            return;
        }
        Path charDir = fileHandle.getPath();
        logger.log(System.Logger.Level.DEBUG, "  char dir in character handle: {0}", charDir);
        if (charDir == null) {
            logger.log(System.Logger.Level.ERROR, "Character directory not set for filehandle {0}", fileHandle.getName());
            throw new NullPointerException("CharDir not set");
        }
        if (!Files.exists(charDir, new LinkOption[0])) {
            logger.log(System.Logger.Level.DEBUG, "  character directory does not exist yet");
            Files.createDirectory(charDir, new FileAttribute[0]);
        }
        if (Files.exists(indexFile = charDir.resolve(INDEX), new LinkOption[0])) {
            Properties pro = new Properties();
            try {
                pro.load(new FileReader(indexFile.toFile()));
            }
            catch (IOException e) {
                throw new CharacterIOException(CharacterIOException.ErrorCode.FILESYSTEM_READ, "Metadata", e.toString(), indexFile.toString(), e);
            }
            FileBasedCharacterHandle.fromProperties(fileHandle, pro);
            fileHandle.setLoadAttemptMade(true);
            logger.log(System.Logger.Level.DEBUG, "Found " + fileHandle.getAttachments().size() + " attachments for " + fileHandle.getName());
        } else {
            this.detectAdditionalAttachments(fileHandle);
            try {
                Path meta = fileHandle.getPath().resolve(INDEX);
                fileHandle.getProperties().store(new FileWriter(meta.toFile()), "Do not edit");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Failed creating metadata.properties", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attachment> getAttachments(CharacterHandle handle) throws IOException {
        block4: {
            ArrayList<Attachment> arrayList;
            logger.log(System.Logger.Level.DEBUG, "ENTER: getAttachments({0})", handle.getName());
            try {
                if (handle.getAttachments().isEmpty()) break block4;
                arrayList = new ArrayList<Attachment>(handle.getAttachments());
            }
            catch (Throwable throwable) {
                logger.log(System.Logger.Level.DEBUG, "LEAVE: getAttachments({0})", handle.getName());
                throw throwable;
            }
            logger.log(System.Logger.Level.DEBUG, "LEAVE: getAttachments({0})", handle.getName());
            return arrayList;
        }
        if (!(handle instanceof FileBasedCharacterHandle)) {
            throw new IllegalArgumentException("Must be FileBasedCharacterHandle");
        }
        FileBasedCharacterHandle fileHandle = (FileBasedCharacterHandle)handle;
        this.ensureMetadataLoaded(fileHandle);
        ArrayList<Attachment> arrayList = new ArrayList<Attachment>(fileHandle.getAttachments());
        logger.log(System.Logger.Level.DEBUG, "LEAVE: getAttachments({0})", handle.getName());
        return arrayList;
    }

    @Override
    public void modifyAttachment(CharacterHandle rawHandle, Attachment attach) throws IOException {
        if (!(rawHandle instanceof FileBasedCharacterHandle)) {
            throw new IllegalArgumentException("Must be FileBasedCharacterHandle");
        }
        FileBasedCharacterHandle handle = (FileBasedCharacterHandle)rawHandle;
        byte[] data = attach.getData();
        if (data == null) {
            throw new NullPointerException("No data in attachment");
        }
        if (attach.getFilename() == null) {
            throw new NullPointerException("No filename set");
        }
        String filename = attach.getFilename();
        handle.addAttachment(attach);
        Path charDir = handle.getPath();
        Path target = charDir.resolve(filename);
        attach.setLocalFile(target);
        try {
            logger.log(System.Logger.Level.INFO, "Write to {0}", target);
            Files.write(target, data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CharacterIOException(CharacterIOException.ErrorCode.FILESYSTEM_WRITE, "Character data: " + attach.getType(), e.toString(), target.toString(), e);
        }
        if (attach.getLastModified() != null) {
            try {
                logger.log(System.Logger.Level.INFO, "Set timestamp to {0}", attach.getLastModified());
                Files.setLastModifiedTime(target, FileTime.fromMillis(attach.getLastModified().getTime()));
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.WARNING, "Failed changing modification time of " + target, (Throwable)e);
            }
        } else {
            handle.setLastModified(new Date(System.currentTimeMillis()));
        }
        try {
            Path meta = handle.getPath().resolve(INDEX);
            handle.getProperties().store(new FileWriter(meta.toFile()), "Do not edit");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Failed creating metadata.properties", (Throwable)e);
        }
    }

    @Override
    public void modifyAttachmentData(CharacterHandle rawHandle, Attachment attach) throws IOException {
        if (attach.getLocalFile() == null) {
            throw new NullPointerException("No local file set");
        }
        byte[] data = attach.getData();
        Files.write(attach.getLocalFile(), data, new OpenOption[0]);
    }

    @Override
    public byte[] getAttachmentData(CharacterHandle rawHandle, Attachment attach) throws IOException {
        if (attach.getData() != null) {
            return attach.getData();
        }
        if (attach.getLocalFile() == null) {
            throw new NullPointerException("No local file set");
        }
        byte[] data = Files.readAllBytes(attach.getLocalFile());
        attach.setData(data);
        return data;
    }

    @Override
    public void deleteAttachment(CharacterHandle rawHandle, Attachment attach) throws IOException {
        if (!(rawHandle instanceof FileBasedCharacterHandle)) {
            throw new IllegalArgumentException("Must be FileBasedCharacterHandle");
        }
        FileBasedCharacterHandle handle = (FileBasedCharacterHandle)rawHandle;
        logger.log(System.Logger.Level.INFO, "deleteAttachment: " + handle + " = " + attach);
        handle.removeAttachment(attach);
        try {
            Files.delete(attach.getLocalFile());
        }
        catch (IOException e1) {
            logger.log(System.Logger.Level.ERROR, "Failed deleting local file " + attach.getLocalFile(), (Throwable)e1);
        }
        Path charDir = handle.getPath();
        Path meta = charDir.resolve(INDEX);
        try {
            handle.getProperties().store(new FileWriter(meta.toFile()), "Do not edit");
        }
        catch (IOException e) {
            throw new CharacterIOException(CharacterIOException.ErrorCode.FILESYSTEM_WRITE, "Metadata", e.getMessage(), meta.toString(), e);
        }
    }

    @Override
    public byte[] retrieveAttachment(CharacterHandle rawHandle, Attachment attach) throws IOException {
        if (!(rawHandle instanceof FileBasedCharacterHandle)) {
            throw new IllegalArgumentException("Must be FileBasedCharacterHandle");
        }
        FileBasedCharacterHandle handle = (FileBasedCharacterHandle)rawHandle;
        Path path = handle.getPath();
        attach.setData(Files.readAllBytes(path));
        return attach.getData();
    }

    @Override
    public List<DatasetDefinition> getDatasets() throws IOException {
        return null;
    }

    @Override
    public void storeDataset(DatasetDefinition value) throws IOException {
    }

    @Override
    public void deleteDataset(DatasetDefinition value) throws IOException {
    }

    @Override
    public byte[] getDatasetLocalization(DatasetDefinition value, String lang) throws IOException {
        return null;
    }

    @Override
    public void storeDatasetLocalization(DatasetDefinition value, String lang, byte[] data) throws IOException {
    }

    @Override
    public void deleteDatasetLocalization(DatasetDefinition value, String lang) throws IOException {
    }

    @Override
    public byte[] getDatasetFile(DatasetDefinition value, String name) throws IOException {
        return null;
    }

    @Override
    public void storeDatasetFile(DatasetDefinition value, String name, byte[] data) throws IOException {
    }

    @Override
    public void deleteDatasetFile(DatasetDefinition value, String name) throws IOException {
    }
}

