/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg;

import de.rpgframework.genericrpg.Reward;
import de.rpgframework.genericrpg.modification.DataItemModification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class HistoryElement {
    private String adventure;
    private String name;
    private List<Reward> gained = new ArrayList<Reward>();
    private List<DataItemModification> spent = new ArrayList<DataItemModification>();

    public String toString() {
        return this.name + "(GAIN=" + this.gained + ", spent=" + this.spent + ")";
    }

    public void addGained(Reward mod) {
        this.gained.add(mod);
        Collections.sort(this.gained, new Comparator<Reward>(){

            @Override
            public int compare(Reward o1, Reward o2) {
                if (o1.getDate() != null && o2.getDate() != null) {
                    return o1.getDate().compareTo(o2.getDate());
                }
                return 0;
            }
        });
    }

    public void addSpent(DataItemModification mod) {
        this.spent.add(mod);
        Collections.sort(this.spent, new Comparator<DataItemModification>(){

            @Override
            public int compare(DataItemModification o1, DataItemModification o2) {
                if (o1.getDate() != null && o2.getDate() != null) {
                    return o1.getDate().compareTo(o2.getDate());
                }
                return 0;
            }
        });
    }

    public Date getStart() {
        if (this.gained.isEmpty()) {
            return this.spent.get(0).getDate();
        }
        return this.gained.get(0).getDate();
    }

    public Date getEnd() {
        if (this.gained.isEmpty()) {
            return this.spent.get(this.spent.size() - 1).getDate();
        }
        return this.gained.get(this.gained.size() - 1).getDate();
    }

    public String getAdventureID() {
        return this.adventure;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Reward> getGained() {
        return this.gained;
    }

    public List<DataItemModification> getSpent() {
        return this.spent;
    }

    public int getTotalExperience() {
        int sum = 0;
        for (Reward reward : this.gained) {
            sum += reward.getExperiencePoints();
        }
        return sum;
    }

    public int getTotalMoney() {
        int sum = 0;
        for (Reward reward : this.gained) {
            sum += reward.getMoney();
        }
        return sum;
    }

    public List<String> getGamemasters() {
        ArrayList<String> ret = new ArrayList<String>();
        for (Reward reward : this.gained) {
            if (reward.getGamemaster() == null || ret.contains(reward.getGamemaster())) continue;
            ret.add(reward.getGamemaster());
        }
        return ret;
    }
}

