/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg;

import de.rpgframework.genericrpg.Datable;
import de.rpgframework.genericrpg.modification.DataItemModification;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModificationList;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import de.rpgframework.genericrpg.modification.Modifyable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.prelle.simplepersist.Attribute;
import org.prelle.simplepersist.Element;

public class Reward
implements Datable,
Modifyable {
    @Attribute(name="exp")
    private int experiencePoints;
    @Attribute
    private int money;
    @Element
    private String title;
    @Element
    private String gamemaster;
    @Attribute(required=false)
    protected Date date;
    @Attribute(required=false)
    private String id;
    @Element
    private ModificationList modifications = new ModificationList();

    public Reward() {
        this.date = Date.from(Instant.now());
    }

    public String toString() {
        return "Reward '" + this.title + "' at " + this.date + "  (id=" + this.id + ")";
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public List<Modification> getIncomingModifications() {
        return this.modifications;
    }

    @Override
    public void setIncomingModifications(List<Modification> mods) {
        this.modifications = new ModificationList((Collection<? extends Modification>)mods);
    }

    @Override
    public void addIncomingModification(Modification mod) {
        this.modifications.add(mod);
    }

    @Override
    public void removeIncomingModification(Modification mod) {
        this.modifications.remove(mod);
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    public String getGamemaster() {
        return this.gamemaster;
    }

    public void setGamemaster(String gamemaster) {
        this.gamemaster = gamemaster;
    }

    public int getExperiencePoints() {
        return this.experiencePoints;
    }

    public void setExperiencePoints(int experiencePoints) {
        this.experiencePoints = experiencePoints;
    }

    public int getMoney() {
        return this.money;
    }

    public void setMoney(int money) {
        this.money = money;
    }

    public void removeModification(ModifiedObjectType type, String ref) {
        for (Modification tmp : new ArrayList<Modification>(this.modifications)) {
            DataItemModification mod;
            if (tmp.getReferenceType() != type || !(mod = (DataItemModification)tmp).getKey().equals(ref)) continue;
            this.modifications.remove(mod);
        }
    }

    public <D extends DataItemModification> D getModification(ModifiedObjectType type, String ref) {
        for (Modification tmp : new ArrayList<Modification>(this.modifications)) {
            DataItemModification mod;
            if (tmp.getReferenceType() != type || !(mod = (DataItemModification)tmp).getKey().equals(ref)) continue;
            return (D)mod;
        }
        return null;
    }
}

