/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.chargen;

import de.rpgframework.genericrpg.ToDoElement;
import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.Decision;
import java.util.ArrayList;

public abstract class ControllerUtil {
    public <D extends ComplexDataItem> OperationResult<Boolean> canBeSelected(D value, Decision ... decisions) {
        OperationResult<Boolean> ret = new OperationResult<Boolean>(true);
        ArrayList<Decision> badDecisions = new ArrayList<Decision>();
        for (Choice choice : value.getChoices()) {
            boolean found = false;
            for (Decision dec : decisions) {
                if (dec.getChoiceUUID() == null) {
                    if (badDecisions.contains(dec)) continue;
                    badDecisions.add(dec);
                    ret.addMessage(new ToDoElement(ToDoElement.Severity.STOPPER, "Decision without a choice UUID found: " + dec));
                    continue;
                }
                if (!dec.getChoiceUUID().equals(choice.getUUID())) continue;
                found = true;
                break;
            }
            if (found) continue;
            ret.addMessage(new ToDoElement(ToDoElement.Severity.WARNING, "No decision made for choice " + choice));
            ret.set(false);
        }
        return ret;
    }
}

