/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.chargen;

import de.rpgframework.genericrpg.Possible;
import de.rpgframework.genericrpg.ToDoElement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class OperationResult<T> {
    private List<ToDoElement> messages = new ArrayList<ToDoElement>();
    private T value;

    public OperationResult() {
        this.messages.add(new ToDoElement(ToDoElement.Severity.STOPPER, "Not possible"));
    }

    public OperationResult(Possible poss) {
        if (poss.getState() == Possible.State.DECISIONS_MISSING && poss.getMostSevere() != null) {
            this.messages.add(poss.getMostSevere());
        }
        if (poss.getState() == Possible.State.IMPOSSIBLE) {
            if (poss.getI18NKey().isEmpty()) {
                this.messages.add(new ToDoElement(ToDoElement.Severity.STOPPER, "Not possible"));
            } else {
                this.messages = poss.getI18NKey();
            }
        }
        if (poss.getState() == Possible.State.REQUIREMENTS_NOT_MET) {
            this.messages.add(new ToDoElement(ToDoElement.Severity.WARNING, "" + poss.getUnfulfilledRequirements()));
        }
    }

    public OperationResult(Possible poss, boolean success) {
        if (!success) {
            if (poss.getI18NKey().isEmpty()) {
                this.messages.add(new ToDoElement(ToDoElement.Severity.STOPPER, "Not possible"));
            } else {
                this.messages = poss.getI18NKey();
            }
        }
        if (poss.getState() == Possible.State.REQUIREMENTS_NOT_MET) {
            this.messages.add(new ToDoElement(ToDoElement.Severity.WARNING, "" + poss.getUnfulfilledRequirements()));
        }
    }

    public OperationResult(T value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public boolean hasError() {
        return !this.messages.isEmpty();
    }

    public boolean wasSuccessful() {
        return this.messages.isEmpty();
    }

    public List<ToDoElement> getMessages() {
        return this.messages;
    }

    public String getError() {
        return String.join((CharSequence)"\n", this.messages.stream().map(m -> m.getMessage()).collect(Collectors.toList()));
    }

    public void addMessage(ToDoElement mess) {
        this.messages.add(mess);
    }

    public boolean isPresent() {
        return this.value != null && this.messages.isEmpty();
    }
}

