/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.genericrpg.ModifyableNumericalValue;
import de.rpgframework.genericrpg.Pool;
import de.rpgframework.genericrpg.ValueType;
import de.rpgframework.genericrpg.data.IAttribute;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModifyableImpl;
import de.rpgframework.genericrpg.modification.ValueModification;
import org.prelle.simplepersist.Attribute;

public class AttributeValue<A extends IAttribute>
extends ModifyableImpl
implements ModifyableNumericalValue<A> {
    @Attribute(name="id", required=true)
    private A id;
    @Attribute(name="value", required=true)
    private int distributed;
    @Attribute(name="start", required=false)
    private int start;
    private transient Pool<Integer> pool;

    public AttributeValue() {
    }

    public AttributeValue(A key) {
        this.id = key;
    }

    public AttributeValue(A key, int distributed) {
        this.id = key;
        this.distributed = distributed;
    }

    public String toString() {
        return this.id + ":" + this.distributed + "(" + this.getIncomingModifications() + ")";
    }

    @Override
    public int getDistributed() {
        return this.distributed;
    }

    @Override
    public void setDistributed(int value) {
        this.distributed = value;
    }

    @Override
    public A getModifyable() {
        return this.id;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getMaximum() {
        int count = 0;
        for (Modification mod : this.incomingModifications) {
            ValueModification aMod;
            if (!(mod instanceof ValueModification) || (aMod = (ValueModification)mod).getResolvedKey() != this.id || aMod.getSet() != ValueType.MAX) continue;
            count += aMod.getValue();
        }
        if (count < 0) {
            return 6 + count;
        }
        return count;
    }

    public String getDisplayString() {
        int natural = this.getDistributed();
        int augmented = this.getModifiedValue(ValueType.AUGMENTED);
        int artificial = this.getModifiedValue(ValueType.ARTIFICIAL);
        StringBuffer buf = new StringBuffer(String.valueOf(natural));
        if (augmented != natural) {
            buf.append("(" + augmented + ")");
        }
        if (artificial > 0) {
            buf.append("|" + artificial);
        }
        return buf.toString();
    }

    @Override
    public Pool<Integer> getPool() {
        return this.pool;
    }

    public void setPool(Pool<Integer> pool) {
        this.pool = pool;
    }
}

