/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.classification.Gender;
import de.rpgframework.genericrpg.Reward;
import de.rpgframework.genericrpg.chargen.DataSetMode;
import de.rpgframework.genericrpg.chargen.Rule;
import de.rpgframework.genericrpg.chargen.RuleConfiguration;
import de.rpgframework.genericrpg.chargen.ai.LevellingProfileValue;
import de.rpgframework.genericrpg.data.ASkillValue;
import de.rpgframework.genericrpg.data.AttributeValue;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataItemValue;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.data.DecisionContainer;
import de.rpgframework.genericrpg.data.IAttribute;
import de.rpgframework.genericrpg.data.ISkill;
import de.rpgframework.genericrpg.data.Lifeform;
import de.rpgframework.genericrpg.data.RuleFlag;
import de.rpgframework.genericrpg.items.CarriedItem;
import de.rpgframework.genericrpg.items.PieceOfGear;
import de.rpgframework.genericrpg.modification.DataItemModification;
import de.rpgframework.genericrpg.modification.ModificationList;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.prelle.simplepersist.Attribute;
import org.prelle.simplepersist.Element;
import org.prelle.simplepersist.ElementList;

public abstract class CommonCharacter<A extends IAttribute, S extends ISkill, V extends ASkillValue<S>, T extends PieceOfGear>
implements RuleSpecificCharacterObject<A, S, V, T>,
Lifeform<A, S, V>,
DecisionContainer {
    @Element
    protected String name = "Unnamed";
    @Element(name="datasets")
    protected DataSetControl dataSets = new DataSetControl();
    @Attribute(name="gender")
    protected Gender gender = Gender.MALE;
    @ElementList(type=RuleConfiguration.class, entry="set")
    protected List<RuleConfiguration> rules = new ArrayList<RuleConfiguration>();
    @Element
    private String hairColor;
    @Element
    private String eyeColor;
    @Element
    private String skinColor;
    @Element
    private String age;
    @Element
    private int size;
    @Element
    private int weight;
    @ElementList(type=AttributeValue.class, entry="attributes")
    private final List<AttributeValue<A>> attributes = new ArrayList<AttributeValue<A>>();
    protected Map<A, AttributeValue<A>> derivedAttributes;
    @ElementList(type=ASkillValue.class, entry="skill")
    protected List<V> skills;
    @Element
    protected byte[] image;
    @Attribute(name="career")
    protected boolean inCareerMode;
    @Element
    private String charGenUsed;
    @Element
    private String strictness;
    @ElementList(type=Decision.class, entry="decision")
    public List<Decision> decisions = new ArrayList<Decision>();
    @ElementList(type=CarriedItem.class, entry="item")
    protected List<CarriedItem<T>> items;
    protected transient List<CarriedItem<T>> virtualItems;
    @Element
    protected ModificationList history;
    @ElementList(type=Reward.class, entry="reward")
    protected List<Reward> rewards;
    @ElementList(type=LevellingProfileValue.class, entry="profile")
    protected List<LevellingProfileValue> profiles;
    protected transient List<RuleFlag> ruleFlags;
    protected transient List<T> gearDefinitions;

    public CommonCharacter() {
        this.skills = new ArrayList<V>();
        this.items = new ArrayList<CarriedItem<T>>();
        this.virtualItems = new ArrayList<CarriedItem<T>>();
        this.ruleFlags = new ArrayList<RuleFlag>();
        this.derivedAttributes = new LinkedHashMap<A, AttributeValue<A>>();
        this.history = new ModificationList();
        this.rewards = new ArrayList<Reward>();
        this.profiles = new ArrayList<LevellingProfileValue>();
        this.gearDefinitions = new ArrayList<T>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        this.name = value;
    }

    @Override
    public byte[] getImage() {
        return this.image;
    }

    @Override
    public void setImage(byte[] data) {
        this.image = data;
    }

    @Override
    public AttributeValue<A> getAttribute(A key) {
        for (AttributeValue<A> val : this.attributes) {
            if (val.getModifyable() != key) continue;
            return val;
        }
        return this.derivedAttributes.get(key);
    }

    public List<AttributeValue<A>> getAttributes() {
        ArrayList<AttributeValue<A>> ret = new ArrayList<AttributeValue<A>>(this.attributes);
        ret.addAll(this.derivedAttributes.values());
        return ret;
    }

    public void setAttribute(AttributeValue<A> val) {
        if (val.getModifyable().isDerived()) {
            this.derivedAttributes.put(val.getModifyable(), val);
        } else {
            this.attributes.add(val);
        }
    }

    @Override
    public boolean hasDecisionBeenMade(UUID choice) {
        for (Decision dec : this.decisions) {
            if (!dec.getChoiceUUID().equals(choice)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Decision getDecision(UUID choice) {
        for (Decision dec : this.decisions) {
            if (!dec.getChoiceUUID().equals(choice)) continue;
            return dec;
        }
        return null;
    }

    @Override
    public void removeDecision(UUID choice) {
        for (Decision dec : this.decisions) {
            if (!dec.getChoiceUUID().equals(choice)) continue;
            this.decisions.remove(dec);
            return;
        }
    }

    @Override
    public void addDecision(Decision decision) {
        this.removeDecision(decision.getChoiceUUID());
        this.decisions.add(decision);
    }

    @Override
    public Gender getGender() {
        return this.gender;
    }

    @Override
    public void setGender(Gender value) {
        this.gender = value;
    }

    @Override
    public String getHairColor() {
        return this.hairColor;
    }

    @Override
    public void setHairColor(String hairColor) {
        this.hairColor = hairColor;
    }

    @Override
    public String getEyeColor() {
        return this.eyeColor;
    }

    @Override
    public void setEyeColor(String eyeColor) {
        this.eyeColor = eyeColor;
    }

    @Override
    public String getSkinColor() {
        return this.skinColor;
    }

    @Override
    public void setSkinColor(String color) {
        this.skinColor = color;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public String getAge() {
        return this.age;
    }

    @Override
    public void setAge(String value) {
        this.age = value;
    }

    @Override
    public List<V> getSkillValues() {
        return this.skills;
    }

    @Override
    public V getSkillValue(S skill) {
        assert (skill != null);
        for (ASkillValue val : this.skills) {
            if (val.getModifyable() != skill && !((ISkill)val.getModifyable()).getId().equals(((DataItem)skill).getId())) continue;
            return (V)val;
        }
        return null;
    }

    @Override
    public V getSkillValue(String skillID) {
        for (ASkillValue val : this.skills) {
            if (val.getKey() == null || !val.getKey().equals(skillID)) continue;
            return (V)val;
        }
        return null;
    }

    @Override
    public V getSkillValue(UUID uuid) {
        for (ASkillValue val : this.skills) {
            if (val.getUuid() == null || !val.getUuid().equals(uuid)) continue;
            return (V)val;
        }
        return null;
    }

    public void removeSkillValue(V value) {
        for (ASkillValue val : this.skills) {
            if (!val.equals(value)) continue;
            this.skills.remove(val);
            return;
        }
    }

    public V addSkillValue(V value) {
        if (((DataItemValue)value).getKey() == null) {
            throw new RuntimeException("No key");
        }
        if (((DataItemValue)value).getResolved() == null) {
            throw new RuntimeException("Nothing resolved");
        }
        if (this.skills.contains(value)) {
            return value;
        }
        this.removeSkillValue(value);
        this.skills.add(value);
        return value;
    }

    public DataSetControl getDataSets() {
        return this.dataSets;
    }

    @Override
    public void addCarriedItem(CarriedItem<T> item) {
        if (item.getUuid() == null) {
            throw new NullPointerException("Cannot add item without UUID");
        }
        for (CarriedItem<T> tmp : this.items) {
            if (tmp.getUuid() == null) {
                System.err.println("CommonCharacter(" + this.name + ").addCarriedItem: found item " + tmp + " that has no UUID");
            }
            if (tmp.getUuid() == null || !tmp.getUuid().equals(item.getUuid())) continue;
            return;
        }
        this.items.add(item);
    }

    public List<CarriedItem<T>> getVirtualCarriedItems() {
        return new ArrayList<CarriedItem<T>>(this.virtualItems);
    }

    public void addVirtualCarriedItem(CarriedItem<T> item) {
        if (item.getInjectedBy() == null) {
            throw new IllegalArgumentException("Virtual items need an injectedBy property set");
        }
        if (!this.virtualItems.contains(item)) {
            this.virtualItems.add(item);
        }
    }

    public void removeVirtualCarriedItem(CarriedItem<T> item) {
        if (item.getInjectedBy() == null) {
            throw new IllegalArgumentException("Virtual items need an injectedBy property set");
        }
        this.virtualItems.remove(item);
    }

    @Override
    public void removeCarriedItem(CarriedItem<T> item) {
        this.items.remove(item);
    }

    @Override
    public List<CarriedItem<T>> getCarriedItems() {
        ArrayList<CarriedItem<T>> ret = new ArrayList<CarriedItem<T>>(this.items);
        ret.addAll(this.virtualItems);
        return ret;
    }

    public List<CarriedItem<T>> getCarriedItemsRecursive() {
        ArrayList<CarriedItem<T>> ret = new ArrayList<CarriedItem<T>>();
        for (CarriedItem<T> tmp : this.getCarriedItems()) {
            ret.add(tmp);
            ret.addAll(tmp.getEffectiveAccessories());
        }
        return ret;
    }

    public List<CarriedItem<T>> getCarriedItems(Predicate<CarriedItem<T>> filter) {
        return this.getCarriedItemsRecursive().stream().filter(filter).collect(Collectors.toList());
    }

    @Override
    public CarriedItem<T> getCarriedItem(String key) {
        for (CarriedItem<T> tmp : this.getCarriedItems()) {
            if (!tmp.getKey().equals(key)) continue;
            return tmp;
        }
        return null;
    }

    public CarriedItem<T> getCarriedItem(UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("UUID is null");
        }
        for (CarriedItem<T> tmp : this.getCarriedItems()) {
            if (!tmp.getUuid().equals(uuid)) continue;
            return tmp;
        }
        return null;
    }

    @Override
    public boolean isInCareerMode() {
        return this.inCareerMode;
    }

    public void setInCareerMode(boolean inCareerMode) {
        this.inCareerMode = inCareerMode;
    }

    public String getCharGenUsed() {
        return this.charGenUsed;
    }

    public void setCharGenUsed(String charGenUsed) {
        this.charGenUsed = charGenUsed;
    }

    public String getStrictness() {
        return this.strictness;
    }

    public void setStrictness(String value) {
        this.strictness = value;
    }

    public void addRuleFlag(RuleFlag flag) {
        if (!this.ruleFlags.contains(flag)) {
            this.ruleFlags.add(flag);
        }
    }

    public void clearRuleFlag(RuleFlag flag) {
        this.ruleFlags.remove(flag);
    }

    public void clearRuleFlags() {
        this.ruleFlags.clear();
    }

    public boolean hasRuleFlag(RuleFlag flag) {
        return this.ruleFlags.contains(flag);
    }

    void addRule(Rule rule, String value) {
        RuleConfiguration old = this.getRuleValue(rule);
        if (old != null) {
            this.rules.remove(old);
        }
        this.rules.add(new RuleConfiguration(rule.getID(), value));
    }

    List<RuleConfiguration> getRuleValues() {
        return this.rules;
    }

    @Override
    public RuleConfiguration getRuleValue(Rule rule) {
        for (RuleConfiguration rv : this.rules) {
            if (!rv.getRuleId().equals(rule.getID())) continue;
            return rv;
        }
        return null;
    }

    boolean getRuleValueAsBoolean(Rule rule) {
        for (RuleConfiguration rv : this.rules) {
            if (!rv.getRuleId().equals(rule.getID())) continue;
            try {
                return Boolean.parseBoolean(rv.getValueString());
            }
            catch (Exception e) {
                System.getLogger(this.getClass().getPackageName()).log(System.Logger.Level.WARNING, "Invalid entry for rule " + rule, (Throwable)e);
                return Boolean.parseBoolean(rule.getDefaultValue());
            }
        }
        return false;
    }

    <E extends Enum> E getRuleValueAsEnum(Rule rule) {
        for (RuleConfiguration rv : this.rules) {
            if (!rv.getRuleId().equals(rule.getID())) continue;
            Class enumType = rule.getEnumClassToUse();
            try {
                return Enum.valueOf(enumType, rv.getValueString());
            }
            catch (Exception e) {
                System.getLogger(this.getClass().getPackageName()).log(System.Logger.Level.WARNING, "Invalid entry for rule " + rule, (Throwable)e);
                return Enum.valueOf(enumType, rule.getDefaultValue());
            }
        }
        return rule.getDefaultAsEnumValue();
    }

    @Override
    public void setRuleValue(Rule rule, String value) {
        this.clearRuleValue(rule);
        this.rules.add(new RuleConfiguration(rule.getID(), value));
    }

    void clearRuleValue(Rule rule) {
        RuleConfiguration old = this.getRuleValue(rule);
        if (old != null) {
            this.rules.remove(old);
        }
    }

    public void addToHistory(DataItemModification mod) {
        if (mod.getDate() == null) {
            mod.setDate(new Date());
        }
        if (mod.getWhen() != null) {
            mod.setWhen(null);
        }
        if (mod.getApplyTo() != null) {
            mod.setApplyTo(null);
        }
        this.history.add(mod);
    }

    public boolean removeFromHistory(DataItemModification mod) {
        return this.history.remove(mod);
    }

    public List<DataItemModification> getHistory() {
        ArrayList<DataItemModification> ret = new ArrayList<DataItemModification>();
        this.history.forEach(tmp -> ret.add((DataItemModification)tmp));
        return ret;
    }

    public void addReward(Reward rew) {
        if (!this.rewards.contains(rew)) {
            this.rewards.add(rew);
        }
    }

    public boolean removeReward(Reward rew) {
        return this.rewards.remove(rew);
    }

    public List<Reward> getRewards() {
        return new ArrayList<Reward>(this.rewards);
    }

    public void clearGearDefinitions() {
        this.gearDefinitions.clear();
    }

    public T getGearDefinition(String key) {
        for (PieceOfGear tmp : this.gearDefinitions) {
            if (!tmp.getId().equals(key)) continue;
            return (T)tmp;
        }
        return null;
    }

    public void addGearDefinition(T gearDef) {
        if (!this.gearDefinitions.contains(gearDef)) {
            this.gearDefinitions.add(gearDef);
        }
    }

    public List<LevellingProfileValue> getProfiles() {
        return this.profiles;
    }

    public void addProfile(LevellingProfileValue value) {
        this.profiles.add(value);
    }

    public void removeProfile(LevellingProfileValue value) {
        this.profiles.remove(value);
    }

    public static class DataSetControl {
        @Attribute
        public DataSetMode mode = DataSetMode.ALL;
        @ElementList(entry="set", type=String.class)
        public List<String> selected = new ArrayList<String>();

        public void add(String id) {
            if (!this.selected.contains(id)) {
                this.selected.add(id);
            }
        }

        public void remove(String id) {
            this.selected.remove(id);
        }
    }
}

