/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.core.CustomResourceManagerLoader;
import de.rpgframework.genericrpg.LicenseManager;
import de.rpgframework.genericrpg.data.DataErrorException;
import de.rpgframework.genericrpg.data.DataItemTypeKey;
import de.rpgframework.genericrpg.data.DataSet;
import de.rpgframework.genericrpg.data.GenericRPGTools;
import de.rpgframework.genericrpg.data.PageReference;
import de.rpgframework.genericrpg.items.PieceOfGearVariant;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.prelle.simplepersist.Attribute;

public abstract class DataItem {
    protected static final System.Logger logger = System.getLogger(DataItem.class.getPackageName());
    protected List<PageReference> parentSet;
    @Attribute(required=true)
    protected String id;
    @Attribute(required=false)
    protected String lang;
    protected transient DataItem parentItem;
    protected transient List<DataSet> datasets = new ArrayList<DataSet>();
    protected transient Map<String, DataItem> languageAlternatives;

    protected DataItem() {
        this.parentSet = new ArrayList<PageReference>();
        this.languageAlternatives = new HashMap<String, DataItem>();
    }

    public void assignToDataSet(DataSet set) {
        if (this.datasets.contains(set)) {
            logger.log(System.Logger.Level.WARNING, "Already assigned {0} to dataset {1}", this.id, set);
            return;
        }
        this.datasets.add(set);
        String key = this.getTypeString() + "." + this.id.toLowerCase() + ".page";
        String key2 = this.getTypeString() + "." + this.id.toLowerCase();
        String key3 = this.getTypeString() + "." + this.id.toLowerCase() + ".prodname";
        if (this.parentItem != null) {
            key = this.parentItem.getTypeString() + "." + this.parentItem.getId().toLowerCase() + "." + key;
            key2 = this.parentItem.getTypeString() + "." + this.parentItem.getId().toLowerCase() + "." + key2;
            key3 = this.parentItem.getTypeString() + "." + this.parentItem.getId().toLowerCase() + "." + key3;
        }
        for (Locale locale : set.getLocales()) {
            set.getResourceString(key2, locale);
            int page = 0;
            if (!(this instanceof PieceOfGearVariant)) {
                try {
                    String pageS = set.getResourceString(key, locale);
                    page = Integer.valueOf(pageS);
                }
                catch (NumberFormatException pageS) {
                }
                catch (MissingResourceException mre) {
                    logger.log(System.Logger.Level.ERROR, "Missing resource  " + mre.getKey() + "\t  for locale " + locale + " in " + set.getBaseBundleName());
                }
            }
            PageReference pageRef = new PageReference(set, page, locale.getLanguage());
            String prodName = set.getResourceString(key3, locale);
            if (prodName != null && !prodName.endsWith(".prodname")) {
                pageRef.setOverwrittenProductName(prodName);
            }
            this.parentSet.add(pageRef);
            this.getName(locale);
            this.getDescription(locale);
        }
    }

    public Collection<DataSet> getAssignedDataSets() {
        return this.datasets;
    }

    public boolean inDataSets(Collection<DataSet> sets) {
        return this.parentSet.stream().anyMatch(pr -> sets.contains(pr.getProduct()));
    }

    public String getTypeString() {
        if (this.getClass().getAnnotation(DataItemTypeKey.class) == null) {
            throw new IllegalArgumentException("Missing @DataItemTypeKey in " + this.getClass());
        }
        return this.getClass().getAnnotation(DataItemTypeKey.class).id();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String toString() {
        if (this.lang != null) {
            return this.getTypeString() + ":" + this.id + "(" + this.lang + ")";
        }
        return this.getTypeString() + ":" + this.id;
    }

    public String getName() {
        return this.getName(Locale.getDefault());
    }

    public void setParentItem(DataItem parentItem) {
        this.parentItem = parentItem;
    }

    public DataSet getFirstParent(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Locale may not by null");
        }
        PageReference defaultRef = null;
        for (PageReference set : this.parentSet) {
            if (defaultRef == null) {
                defaultRef = set;
            }
            if (set.getLanguage() != null && set.getLanguage().equals(locale.getLanguage())) {
                return set.getProduct();
            }
            if (set.getLanguage() != null && !set.getLanguage().equals(Locale.getDefault().getLanguage())) continue;
            defaultRef = set;
        }
        if (defaultRef == null && this.parentItem != null) {
            for (PageReference set : this.parentItem.getPageReferences()) {
                if (defaultRef == null) {
                    defaultRef = set;
                }
                if (set.getLanguage() != null && set.getLanguage().equals(locale.getLanguage())) {
                    return set.getProduct();
                }
                if (set.getLanguage() != null && !set.getLanguage().equals(Locale.getDefault().getLanguage())) continue;
                defaultRef = set;
            }
        }
        if (defaultRef == null) {
            return null;
        }
        return defaultRef.getProduct();
    }

    public String getLocalizedString(Locale locale, String key) {
        if (this.parentItem != null) {
            return this.parentItem.getLocalizedString(locale, key);
        }
        if (this.parentSet == null) {
            System.err.println("No parent dataset for " + this.getTypeString() + ":" + this.id);
            return key;
        }
        if (locale == null) {
            throw new NullPointerException("Locale was NULL");
        }
        this.getFirstParent(locale);
        DataSet set = null;
        int where = 0;
        try {
            String custom;
            set = this.getFirstParent(locale);
            if (set == null) {
                return "?No ParentSet?" + key;
            }
            if (CustomResourceManagerLoader.getInstance() != null && (custom = CustomResourceManagerLoader.getInstance().getProperty(set.getRules(), key, locale)) != null) {
                return custom;
            }
            ++where;
            return set.getResourceString(key, locale);
        }
        catch (MissingResourceException mre) {
            if (where == 0) {
                logger.log(System.Logger.Level.ERROR, mre.toString());
            } else {
                logger.log(System.Logger.Level.ERROR, "Missing resource  " + mre.getKey() + "\t  for locale " + locale + " in " + set.getBaseBundleName());
            }
            return this.id;
        }
    }

    public InputStream getResource(String name) {
        for (PageReference ref : this.parentSet) {
            DataSet set = ref.getProduct();
            String resourceName = "org.prelle.rpgframework.splittermond.data." + set.getID().toLowerCase() + "." + name;
            InputStream ins = ClassLoader.getSystemResourceAsStream(resourceName);
            logger.log(System.Logger.Level.ERROR, "Search image resource {0} = {1}", resourceName, ins);
            resourceName = "org/prelle/rpgframework/splittermond/data/" + set.getID().toLowerCase() + "/" + name;
            ins = ClassLoader.getSystemResourceAsStream(resourceName);
            logger.log(System.Logger.Level.ERROR, "Search image resource {0} = {1}", resourceName, ins);
            if (ins == null) continue;
            return ins;
        }
        return null;
    }

    public String getLocalizedString(Locale locale, List<String> keys) {
        if (this.parentSet == null) {
            System.err.println("No parent dataset for " + this.getTypeString() + ":" + this.id);
            return keys.toString();
        }
        if (locale == null) {
            throw new NullPointerException("Locale was NULL");
        }
        this.getFirstParent(locale);
        DataSet set = null;
        int where = 0;
        try {
            set = this.getFirstParent(locale);
            if (set == null) {
                return "?No ParentSet?";
            }
            ++where;
            String localized = set.getResourceString(keys, locale);
            if (localized == null) {
                logger.log(System.Logger.Level.ERROR, "Missing one of the follwing resources  " + keys + "\t  for locale " + locale + " in " + set.getBundleID());
                return "?No_Key_Found?";
            }
            return localized;
        }
        catch (MissingResourceException mre) {
            if (where == 0) {
                logger.log(System.Logger.Level.ERROR, mre.toString());
            } else {
                logger.log(System.Logger.Level.ERROR, "Missing one of the follwing resources  " + keys + "\t  for locale " + locale + " in " + set.getBaseBundleName());
            }
            return this.id;
        }
    }

    public String getName(Locale locale) {
        if (this.parentItem != null) {
            String key = this.parentItem.getTypeString() + "." + this.parentItem.getId().toLowerCase() + "." + this.getTypeString() + "." + this.id.toLowerCase();
            return this.getLocalizedString(locale, key);
        }
        String key = this.getTypeString() + "." + this.id.toLowerCase();
        return this.getLocalizedString(locale, key);
    }

    public String getShortName(Locale locale) {
        String key = this.getTypeString() + "." + this.id.toLowerCase() + ".short";
        ArrayList<String> keys = new ArrayList<String>();
        if (this.parentItem != null) {
            keys.add(this.parentItem.getTypeString() + "." + this.parentItem.getId().toLowerCase() + "." + key);
        }
        keys.add(key);
        String result = this.getLocalizedString(locale, keys);
        if ("?No_Key_Found?".equals(result)) {
            return null;
        }
        return result;
    }

    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public boolean hasLicense() {
        return this.hasLicense(Locale.getDefault());
    }

    public boolean hasLicense(Locale locale) {
        if (this.parentSet == null) {
            System.err.println("No parent dataset for " + this.getTypeString() + ":" + this.id);
            return false;
        }
        DataSet set = null;
        set = this.getFirstParent(locale);
        if (set == null) {
            return false;
        }
        return LicenseManager.hasLicense(set, locale);
    }

    public String getDescription(Locale locale) {
        String key = this.getTypeString() + "." + this.id.toLowerCase() + ".desc";
        if (this.parentSet == null) {
            System.err.println("No parent dataset for " + this.getTypeString() + ":" + this.id);
            return key;
        }
        if (this.parentItem != null) {
            key = this.parentItem.getTypeString() + "." + this.parentItem.getId().toLowerCase() + "." + key;
        }
        DataSet set = null;
        int where = 0;
        try {
            String custom;
            set = this.getFirstParent(locale);
            if (set == null) {
                return "?No ParentSet?";
            }
            if (CustomResourceManagerLoader.getInstance() != null && (custom = CustomResourceManagerLoader.getInstance().getProperty(set.getRules(), key, locale)) != null) {
                return custom;
            }
            ++where;
            if (!LicenseManager.hasLicense(set, locale)) {
                return GenericRPGTools.RES.format("warning.no_license", new Object[]{set.getName(locale), locale.getDisplayLanguage(locale)});
            }
            String foo = set.getResourceString(key, locale);
            return foo;
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace();
            if (where == 0) {
                logger.log(System.Logger.Level.ERROR, mre.toString());
            } else {
                logger.log(System.Logger.Level.ERROR, "Missing resource  " + mre.getKey() + "\t  for locale " + locale + " in " + set.getBaseBundleName());
            }
            return this.id;
        }
    }

    public String getLanguage() {
        return this.lang;
    }

    public void validate() throws DataErrorException {
    }

    public List<PageReference> getPageReferences() {
        if (this.parentItem != null) {
            return this.parentItem.getPageReferences();
        }
        return this.parentSet;
    }

    public void addLanguageAlternative(String lang, DataItem alt) {
        this.languageAlternatives.put(lang, alt);
    }

    public boolean hasLanguageAlternative(String lang) {
        return this.languageAlternatives.containsKey(lang);
    }

    public <T extends DataItem> T getLanguageAlternative(String lang) {
        return (T)this.languageAlternatives.get(lang);
    }

    public Collection<DataItem> getLanguageAlternatives() {
        return this.languageAlternatives.values();
    }
}

