/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.MultiLanguageResourceBundle;
import de.rpgframework.genericrpg.Datable;
import de.rpgframework.genericrpg.HistoryElement;
import de.rpgframework.genericrpg.Possible;
import de.rpgframework.genericrpg.Reward;
import de.rpgframework.genericrpg.ToDoElement;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.CommonCharacter;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.items.PieceOfGear;
import de.rpgframework.genericrpg.modification.DataItemModification;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModificationChoice;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import de.rpgframework.genericrpg.modification.ValueModification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;

public class GenericRPGTools {
    public static final MultiLanguageResourceBundle RES = new MultiLanguageResourceBundle(GenericRPGTools.class.getName(), new Locale[]{Locale.ENGLISH, Locale.GERMAN});
    private static final System.Logger logger = System.getLogger(GenericRPGTools.class.getPackageName());

    public static List<Modification> decisionToModifications(DataItemModification origMod, Choice choice, Decision dec) {
        if (origMod instanceof ValueModification) {
            return GenericRPGTools.decisionToModifications((ValueModification)origMod, choice, dec);
        }
        if (origMod.getSource() == null) {
            System.getLogger(GenericRPGTools.class.getPackageName()).log(System.Logger.Level.WARNING, "No source for decision " + dec);
        }
        ArrayList<Modification> ret = new ArrayList<Modification>();
        ModifiedObjectType type = choice.getChooseFrom();
        for (String key : dec.getValues()) {
            DataItemModification newMod = new DataItemModification(type, key);
            newMod.setSource(origMod.getSource());
            newMod.setWhen(origMod.getWhen());
            newMod.setApplyTo(origMod.getApplyTo());
            newMod.setConditionString(origMod.getConditionString());
            ret.add(newMod);
            System.getLogger(GenericRPGTools.class.getPackageName()).log(System.Logger.Level.DEBUG, "-->" + newMod);
        }
        return ret;
    }

    public static List<Modification> decisionToModifications(ModificationChoice origMod, Decision dec) {
        if (origMod.getSource() == null) {
            System.getLogger(GenericRPGTools.class.getPackageName()).log(System.Logger.Level.WARNING, "No source for decision " + dec);
        }
        if (origMod.getUUID() == null) {
            throw new IllegalArgumentException("No UUID in ModificationChoice " + origMod);
        }
        if (dec.getChoiceUUID() == null) {
            throw new IllegalArgumentException("No UUID in Decision " + dec);
        }
        if (!dec.getChoiceUUID().equals(origMod.getUUID())) {
            throw new IllegalArgumentException("Decision does not match ModificationChoice UUID");
        }
        UUID needle = dec.getChoiceUUID();
        ArrayList<Modification> ret = new ArrayList<Modification>();
        for (Modification tmp : origMod) {
            DataItemModification mod;
            if (!(tmp instanceof DataItemModification) || !needle.equals((mod = (DataItemModification)tmp).getId())) continue;
            ret.add(tmp);
        }
        if (ret.isEmpty()) {
            System.getLogger(GenericRPGTools.class.getPackageName()).log(System.Logger.Level.WARNING, "No modification {0} found in <selmod> {1}", needle, origMod.getUUID());
        }
        return ret;
    }

    public static DataItemModification getModificationFor(ComplexDataItem item, UUID choice) {
        for (Modification mod : item.getOutgoingModifications()) {
            DataItemModification dMod;
            if (!(mod instanceof DataItemModification) || (dMod = (DataItemModification)mod).getConnectedChoice() == null || !dMod.getConnectedChoice().equals(choice)) continue;
            return dMod;
        }
        return null;
    }

    public static List<Modification> decisionToModifications(ValueModification origMod, Choice choice, Decision dec) {
        ArrayList<Modification> ret = new ArrayList<Modification>();
        ModifiedObjectType type = choice.getChooseFrom();
        for (String key : dec.getValues()) {
            ValueModification newMod = null;
            int value = origMod.getValue();
            int pos = key.indexOf(":");
            if (pos > 0) {
                value = Integer.parseInt(key.substring(pos + 1));
                key = key.substring(0, pos);
            }
            if (value != 0) {
                newMod = new ValueModification(type, key, value);
            } else if (choice.getDistribute() != null && choice.getDistribute().length > 0) {
                int idx = Arrays.asList(dec.getValues()).indexOf(key);
                value = choice.getDistribute()[idx];
                newMod = new ValueModification(type, key, value);
            }
            newMod.setSource(origMod.getSource());
            newMod.setWhen(origMod.getWhen());
            newMod.setSet(origMod.getSet());
            newMod.setApplyTo(origMod.getApplyTo());
            newMod.setConditionString(origMod.getConditionString());
            ret.add(newMod);
        }
        return ret;
    }

    public static List<Object> convertChoiceToOptions(Choice choice) {
        ArrayList<Object> optionList = new ArrayList<Object>();
        if (choice.getChoiceOptions() == null) {
            optionList.addAll(List.of(choice.getChooseFrom().resolveAny()));
        } else if (choice.getRawChoiceOptions() != null && choice.getRawChoiceOptions().contains(":")) {
            logger.log(System.Logger.Level.ERROR, "GENERIC " + choice.getChooseFrom() + " via " + choice.getRawChoiceOptions());
            String newType = choice.getRawChoiceOptions().substring(0, choice.getRawChoiceOptions().indexOf(":"));
            String newID = choice.getRawChoiceOptions().substring(choice.getRawChoiceOptions().indexOf(":") + 1);
            for (String tmp : newID.split(",")) {
                String newKey = newType + ":" + tmp;
                T[] data = choice.getChooseFrom().resolveVariable(newKey);
                if (data == null) continue;
                optionList.addAll(List.of(data));
            }
            logger.log(System.Logger.Level.DEBUG, "Convert ''{0}'' to {1} elements: {2}", choice.getRawChoiceOptions(), optionList.size(), optionList);
        } else {
            for (String tmp : choice.getChoiceOptions()) {
                Object resolved;
                Object e = resolved = tmp.indexOf(":") == -1 ? (Object)choice.getChooseFrom().resolve(tmp) : null;
                if (resolved != null) {
                    optionList.add(resolved);
                    continue;
                }
                T[] data = choice.getChooseFrom().resolveVariable(tmp);
                if (data == null) continue;
                optionList.addAll(List.of(data));
            }
            logger.log(System.Logger.Level.DEBUG, "Convert ''{0}'' to {1} elements: {2}", Arrays.toString(choice.getChoiceOptions()), optionList.size(), optionList);
        }
        return optionList;
    }

    public static List<Object> convertChoiceToOptions(ModificationChoice choice) {
        ArrayList<Object> optionList = new ArrayList<Object>();
        for (Modification tmp : choice) {
            if (!(tmp instanceof DataItemModification)) continue;
            DataItemModification mod = (DataItemModification)tmp;
            Object resolved = mod.getReferenceType().resolve(mod.getKey());
            if (resolved != null) {
                optionList.add(resolved);
                continue;
            }
            T[] data = choice.getReferenceType().resolveVariable(mod.getKey());
            if (data == null) continue;
            optionList.addAll(List.of(data));
        }
        return optionList;
    }

    public static Decision getDecision(UUID choice, Decision[] decisions) {
        for (Decision dec : decisions) {
            if (!dec.getChoiceUUID().equals(choice)) continue;
            return dec;
        }
        return null;
    }

    public static Possible areAllDecisionsPresent(ComplexDataItem model, Decision ... decisions) {
        for (Choice choice : model.getChoices()) {
            boolean decisionMissing = true;
            for (Decision dec : decisions) {
                if (dec == null || !choice.getUUID().equals(dec.getChoiceUUID())) continue;
                decisionMissing = false;
                break;
            }
            if (!decisionMissing) continue;
            return new Possible(ToDoElement.Severity.INFO, RES, "impossible.choiceMissing", new Object[0]);
        }
        return Possible.TRUE;
    }

    public static Possible areAllDecisionsPresent(PieceOfGear<?, ?, ?, ?> model, String variantID, Decision ... decisions) {
        for (Choice choice : model.getChoices()) {
            boolean decisionMissing = true;
            for (Decision dec : decisions) {
                if (dec == null || !choice.getUUID().equals(dec.getChoiceUUID())) continue;
                decisionMissing = false;
                if (choice.getChoiceOptions() == null) break;
                boolean invalidOption = true;
                for (String opt : choice.getChoiceOptions()) {
                    if (!dec.getValue().equals(opt)) continue;
                    invalidOption = false;
                    break;
                }
                if (!invalidOption) break;
                return new Possible(ToDoElement.Severity.WARNING, RES, "impossible.invalidChoiceForOption", dec.getValue(), Arrays.toString(choice.getChoiceOptions()));
            }
            if (!decisionMissing) continue;
            return new Possible(ToDoElement.Severity.WARNING, RES, "impossible.choiceMissing", new Object[0]);
        }
        if (variantID != null) {
            Object variant = model.getVariant(variantID);
            if (variant == null) {
                return new Possible(ToDoElement.Severity.STOPPER, RES, "impossible.invalidVariant", new Object[0]);
            }
            for (Choice choice : ((ComplexDataItem)variant).getChoices()) {
                boolean decisionMissing = true;
                for (Decision dec : decisions) {
                    if (dec == null || !choice.getUUID().equals(dec.getChoiceUUID())) continue;
                    decisionMissing = false;
                    break;
                }
                if (!decisionMissing) continue;
                return new Possible(ToDoElement.Severity.INFO, RES, "impossible.choiceMissing", new Object[0]);
            }
        }
        return Possible.TRUE;
    }

    public static String getToDoString(List<ToDoElement> todos, Locale loc) {
        return String.join((CharSequence)", ", todos.stream().map(tmp -> tmp.getMessage(loc)).collect(Collectors.toList()));
    }

    private static HistoryElement makeFromReward(CommonCharacter charac, Reward reward) {
        HistoryElement current = new HistoryElement();
        current.setName(reward.getTitle());
        current.addGained(reward);
        return current;
    }

    public static List<HistoryElement> convertToHistoryElementList(CommonCharacter charac, boolean aggregate) {
        ArrayList<HistoryElement> ret = new ArrayList<HistoryElement>();
        if (charac.getRewards().isEmpty()) {
            return ret;
        }
        logger.log(System.Logger.Level.DEBUG, "Sort " + charac.getRewards().size() + " rewards  and " + charac.getHistory().size() + " mods");
        charac.getRewards();
        Reward firstReward = charac.getRewards().get(0);
        ArrayList<Datable> rewardsAndMods = new ArrayList<Datable>();
        rewardsAndMods.addAll(charac.getRewards());
        rewardsAndMods.remove(firstReward);
        for (DataItemModification mod : charac.getHistory()) {
            rewardsAndMods.add(mod.clone());
        }
        logger.log(System.Logger.Level.TRACE, "Unsorted = " + rewardsAndMods);
        GenericRPGTools.sort(rewardsAndMods);
        logger.log(System.Logger.Level.TRACE, "Sorted = " + rewardsAndMods);
        HistoryElement current = GenericRPGTools.makeFromReward(charac, firstReward);
        ret.add(current);
        for (Datable item : rewardsAndMods) {
            if (item instanceof Reward) {
                Reward reward = (Reward)item;
                if (!aggregate) {
                    current = new HistoryElement();
                    current.setName(reward.getTitle());
                    ret.add(current);
                }
                current.addGained(reward);
                continue;
            }
            if (item instanceof DataItemModification) {
                if (current == null) {
                    logger.log(System.Logger.Level.ERROR, "Failed preparing history: Exp spent on modification without previous reward");
                    continue;
                }
                current.addSpent((DataItemModification)item);
                continue;
            }
            logger.log(System.Logger.Level.ERROR, "Don't know how to " + item);
        }
        logger.log(System.Logger.Level.TRACE, "  return " + ret.size() + " elements");
        return ret;
    }

    private static void sort(List<Datable> rewardsAndMods) {
        Collections.sort(rewardsAndMods, new Comparator<Datable>(){

            @Override
            public int compare(Datable o1, Datable o2) {
                int cmp;
                Long time1 = 0L;
                Long time2 = 0L;
                if (o1.getDate() != null) {
                    time1 = o1.getDate().getTime();
                }
                if (o2.getDate() != null) {
                    time2 = o2.getDate().getTime();
                }
                if ((cmp = time1.compareTo(time2)) == 0) {
                    if (o1 instanceof Reward && o2 instanceof Modification) {
                        return -1;
                    }
                    if (o1 instanceof Modification && o2 instanceof Reward) {
                        return 1;
                    }
                }
                return cmp;
            }
        });
    }
}

