/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.items.CarryMode;
import de.rpgframework.genericrpg.items.Formula;
import de.rpgframework.genericrpg.items.IGearTypeData;
import de.rpgframework.genericrpg.items.IItemAttribute;
import de.rpgframework.genericrpg.items.ItemAttributeDefinition;
import de.rpgframework.genericrpg.items.Usage;
import de.rpgframework.genericrpg.items.formula.FormulaImpl;
import de.rpgframework.genericrpg.items.formula.NumberElement;
import de.rpgframework.genericrpg.items.formula.ObjectElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.prelle.simplepersist.ElementList;

public abstract class AGearData
extends ComplexDataItem
implements Cloneable {
    @ElementList(entry="attrdef", type=ItemAttributeDefinition.class, inline=true)
    protected List<ItemAttributeDefinition> attributes;
    @ElementList(entry="flag", type=String.class, inline=false)
    protected List<String> flags;
    protected transient Map<IItemAttribute, ItemAttributeDefinition> cache = new HashMap<IItemAttribute, ItemAttributeDefinition>();
    @ElementList(entry="usage", type=Usage.class, inline=true)
    protected List<Usage> usages;

    public AGearData() {
        this.attributes = new ArrayList<ItemAttributeDefinition>();
        this.usages = new ArrayList<Usage>();
        this.flags = new ArrayList<String>();
        this.userSelectableFlags = new ArrayList();
    }

    public abstract List<? extends IGearTypeData> getTypeData();

    public <T extends IGearTypeData> T getTypeData(Class<T> clazz) {
        for (IGearTypeData iGearTypeData : this.getTypeData()) {
            if (iGearTypeData.getClass() != clazz) continue;
            return (T)iGearTypeData;
        }
        return null;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.id == null) {
            throw new NullPointerException("id-Attribute not set for " + this);
        }
        for (IGearTypeData iGearTypeData : this.getTypeData()) {
            iGearTypeData.copyToAttributes(this);
        }
        for (ItemAttributeDefinition itemAttributeDefinition : this.attributes) {
            this.cache.put(itemAttributeDefinition.getModifyable(), itemAttributeDefinition);
        }
    }

    public Collection<ItemAttributeDefinition> getAttributes() {
        return this.cache.values();
    }

    public Collection<ItemAttributeDefinition> getAttributes(String variantID) {
        return this.cache.values();
    }

    public ItemAttributeDefinition getAttribute(IItemAttribute attrib) {
        return this.cache.get(attrib);
    }

    public void setAttribute(ItemAttributeDefinition def) {
        this.cache.put(def.getModifyable(), def);
    }

    public void setAttribute(IItemAttribute attrib, Formula value) {
        if (value == null) {
            throw new NullPointerException("Cannnot set NULL for " + attrib);
        }
        ItemAttributeDefinition val = this.cache.get(attrib);
        if (val == null) {
            val = new ItemAttributeDefinition(attrib);
            this.cache.put(attrib, val);
        }
        val.setRawValue(String.valueOf(value));
        val.setFormula(value);
    }

    public void setAttribute(IItemAttribute attrib, int value) {
        FormulaImpl form = new FormulaImpl();
        form.addElement(new NumberElement(value, -1));
        ItemAttributeDefinition val = this.cache.get(attrib);
        if (val == null) {
            val = new ItemAttributeDefinition(attrib);
            this.cache.put(attrib, val);
        }
        val.setRawValue(String.valueOf(value));
        val.setFormula(form);
    }

    public void setAttribute(IItemAttribute attrib, Object value) {
        if (value instanceof Integer) {
            this.setAttribute(attrib, (Integer)value);
            return;
        }
        FormulaImpl form = new FormulaImpl();
        form.addElement(new ObjectElement(value));
        ItemAttributeDefinition val = this.cache.get(attrib);
        if (val == null) {
            val = new ItemAttributeDefinition(attrib);
            this.cache.put(attrib, val);
        }
        if (value instanceof DataItem) {
            val.setRawValue(((DataItem)value).getId());
        } else {
            val.setRawValue(String.valueOf(value));
        }
        val.setFormula(form);
    }

    public void addUsage(Usage usage) {
        this.usages.add(usage);
    }

    public List<Usage> getUsages() {
        return this.usages;
    }

    public Usage getUsage(CarryMode mode) {
        for (Usage usage : this.getUsages()) {
            if (usage.getMode() != mode) continue;
            return usage;
        }
        return null;
    }

    public List<String> getFlags() {
        return new ArrayList<String>(this.flags);
    }

    public boolean hasFlag(String flag) {
        return this.flags.contains(flag);
    }

    public void addFlags(List<String> flags) {
        for (String flag : flags) {
            if (flag != null && !flag.isBlank()) continue;
            throw new IllegalArgumentException("Null or empty flag in " + flags);
        }
        this.flags.addAll(flags);
    }
}

