/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.ToDoElement;
import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.ChoiceOption;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.data.Lifeform;
import de.rpgframework.genericrpg.items.CarriedItem;
import de.rpgframework.genericrpg.items.CarriedItemProcessor;
import de.rpgframework.genericrpg.items.IItemAttribute;
import de.rpgframework.genericrpg.items.ItemAttributeNumericalValue;
import de.rpgframework.genericrpg.items.ItemAttributeObjectValue;
import de.rpgframework.genericrpg.items.PieceOfGear;
import de.rpgframework.genericrpg.items.PieceOfGearVariant;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import de.rpgframework.genericrpg.modification.ValueModification;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;

public class ApplyDecisionsStep
implements CarriedItemProcessor {
    private static final System.Logger logger = CarriedItem.logger;

    @Override
    public OperationResult<List<Modification>> process(boolean strict, ModifiedObjectType refType, Lifeform user, CarriedItem<?> model, List<Modification> unprocessed) {
        OperationResult<List<Modification>> ret = new OperationResult<List<Modification>>(unprocessed);
        List<Decision> decisions = model.getDecisions();
        PieceOfGear template = (PieceOfGear)model.getModifyable();
        PieceOfGearVariant variant = model.getVariant();
        LinkedHashMap openChoices = new LinkedHashMap();
        template.getChoices().forEach(ch -> openChoices.put(ch.getUUID(), ch));
        if (variant != null) {
            variant.getChoices().forEach(ch -> openChoices.put(ch.getUUID(), ch));
        }
        if (decisions != null) {
            for (Decision dec : decisions) {
                Choice choice = template.getChoice(dec.getChoiceUUID());
                logger.log(System.Logger.Level.DEBUG, "Decision {0} for choice {1}", dec.getValue(), choice);
                if (choice == null && variant != null) {
                    choice = variant.getChoice(dec.getChoiceUUID());
                }
                if (choice != null) {
                    openChoices.remove(choice.getUUID());
                    Object obj = null;
                    if (choice.getChooseFrom() != null && choice.getTypeReference() != null) {
                        obj = "CHOICE".equals(choice.getTypeReference()) ? choice.getChooseFrom().resolve(dec.getValue()) : choice.getChooseFrom().resolve(choice.getTypeReference());
                    }
                    if (obj == null) {
                        logger.log(System.Logger.Level.DEBUG, "No need to process {0} here", choice.getChooseFrom());
                        continue;
                    }
                    if (obj instanceof String) {
                        ChoiceOption subOpt = choice.getSubOption(dec.getValue());
                        if (subOpt == null) {
                            logger.log(System.Logger.Level.ERROR, "Reference to unknown suboption {0}", new Object[]{obj});
                            continue;
                        }
                        logger.log(System.Logger.Level.DEBUG, "  Found suboption {0}", new Object[]{obj});
                        if (subOpt.getCost() != 0.0f) {
                            logger.log(System.Logger.Level.DEBUG, "  Found cost {0}", refType);
                            try {
                                IItemAttribute attr = (IItemAttribute)refType.resolve("PRICE");
                                ItemAttributeNumericalValue<IItemAttribute> aVal = model.getAsValue(attr);
                                logger.log(System.Logger.Level.DEBUG, "Add {0} to price of {1}", (int)subOpt.getCost(), aVal.getDistributed());
                                aVal.setDistributed(aVal.getDistributed() + (int)subOpt.getCost());
                            }
                            catch (Exception attr) {
                                // empty catch block
                            }
                        }
                        if (subOpt.getOutgoingModifications().isEmpty()) continue;
                        ArrayList<Modification> toAdd = new ArrayList<Modification>();
                        for (Modification mod : subOpt.getOutgoingModifications()) {
                            if (mod instanceof ValueModification && String.valueOf(((ValueModification)mod).getReferenceType()).equals("ITEM_ATTRIBUTE")) {
                                ValueModification valMod = (ValueModification)mod;
                                obj = mod.getReferenceType().resolve(valMod.getKey());
                                logger.log(System.Logger.Level.DEBUG, "    Set attribute {0} to {1}", obj, valMod.getValue());
                                ItemAttributeNumericalValue<IItemAttribute> aVal = new ItemAttributeNumericalValue<IItemAttribute>(obj);
                                aVal.setDistributed(valMod.getValue());
                                model.setAttribute(aVal.attribute, aVal);
                                continue;
                            }
                            toAdd.add(mod);
                        }
                        if (toAdd.isEmpty()) continue;
                        logger.log(System.Logger.Level.DEBUG, "    Add {0} modifications from suboption {1}", toAdd.size(), subOpt);
                        ret.get().addAll(toAdd);
                        continue;
                    }
                    if (obj == null || !(obj instanceof IItemAttribute)) {
                        logger.log(System.Logger.Level.DEBUG, "No need to process {0} here: {1}", choice.getChooseFrom() + "/" + choice.getTypeReference(), dec.getValue());
                        continue;
                    }
                    logger.log(System.Logger.Level.DEBUG, "Set {0} to {1}", choice.getChooseFrom() + "/" + choice.getTypeReference(), dec.getValue());
                    try {
                        ItemAttributeNumericalValue<IItemAttribute> aVal = new ItemAttributeNumericalValue<IItemAttribute>(obj);
                        aVal.setDistributed(Integer.parseInt(dec.getValue()));
                        model.setAttribute(aVal.attribute, aVal);
                    }
                    catch (NumberFormatException nfe) {
                        ItemAttributeObjectValue aVal = new ItemAttributeObjectValue(obj, dec);
                        model.setAttribute(aVal.attribute, aVal);
                    }
                    continue;
                }
                logger.log(System.Logger.Level.WARNING, "Decision for unknown choice " + dec.getChoiceUUID() + " in item " + this);
                ret.addMessage(new ToDoElement(ToDoElement.Severity.INFO, "Decision for unknown choice " + dec.getChoiceUUID() + " in item " + this));
            }
        }
        for (UUID choiceID : new ArrayList(openChoices.keySet())) {
            Choice open = (Choice)openChoices.get(choiceID);
            if ("PARENT_OR_ALTERNATES".equals(open.getTypeReference())) {
                openChoices.remove(choiceID);
            }
            if (open.getTypeReference() != null) continue;
            logger.log(System.Logger.Level.DEBUG, "Missing type reference in choice {0} of {1}", open.getUUID(), template);
        }
        for (Choice open : openChoices.values()) {
            ret.addMessage(new ToDoElement(ToDoElement.Severity.INFO, "Missing decision for choice " + open.getUUID() + ": " + open.getTypeReference()));
        }
        return ret;
    }
}

