/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.data.Lifeform;
import de.rpgframework.genericrpg.items.CarriedItem;
import de.rpgframework.genericrpg.items.CarriedItemProcessor;
import de.rpgframework.genericrpg.items.Formula;
import de.rpgframework.genericrpg.items.IItemAttribute;
import de.rpgframework.genericrpg.items.ItemAttributeDefinition;
import de.rpgframework.genericrpg.items.ItemAttributeFloatValue;
import de.rpgframework.genericrpg.items.ItemAttributeNumericalValue;
import de.rpgframework.genericrpg.items.ItemAttributeObjectValue;
import de.rpgframework.genericrpg.items.ItemAttributeValue;
import de.rpgframework.genericrpg.items.PieceOfGear;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import de.rpgframework.genericrpg.persist.FloatConverter;
import de.rpgframework.genericrpg.persist.IntegerConverter;
import java.util.List;

public class CopyResolvedAttributesStep
implements CarriedItemProcessor {
    private static final System.Logger logger = CarriedItem.logger;

    private void process(CarriedItem<?> model, ItemAttributeDefinition val) {
        IItemAttribute attrib = val.getModifyable();
        Formula form = val.getFormula();
        if (!form.isResolved()) {
            logger.log(System.Logger.Level.INFO, "Not resolved yet: " + form);
        }
        if (form.isResolved()) {
            if (attrib.getConverter() != null) {
                Class<?> cls = attrib.getConverter().getClass();
                if (cls == FloatConverter.class) {
                    Float flt = (Float)form.getAsObject(attrib.getConverter());
                    model.setAttribute(val.getModifyable(), new ItemAttributeFloatValue<IItemAttribute>(attrib, flt.floatValue()));
                } else if (cls == IntegerConverter.class) {
                    Integer flt = (Integer)form.getAsObject(attrib.getConverter());
                    model.setAttribute(val.getModifyable(), new ItemAttributeNumericalValue<IItemAttribute>(attrib, flt));
                } else {
                    Object foo = form.getAsObject(attrib.getConverter());
                    if (foo == null) {
                        logger.log(System.Logger.Level.ERROR, "Converter {0} resolved {1} to NULL", attrib.getConverter(), form.toString());
                    }
                    if (foo instanceof ItemAttributeValue) {
                        model.setAttribute(val.getModifyable(), (ItemAttributeValue)foo);
                    } else {
                        model.setAttribute(val.getModifyable(), new ItemAttributeObjectValue(attrib, foo));
                    }
                }
            } else if (form.isInteger()) {
                model.setAttribute(val.getModifyable(), new ItemAttributeNumericalValue<IItemAttribute>(attrib, form.getAsInteger()));
            } else if (form.isFloat()) {
                model.setAttribute(val.getModifyable(), new ItemAttributeFloatValue<IItemAttribute>(attrib, form.getAsFloat()));
            } else {
                model.setAttribute(val.getModifyable(), new ItemAttributeObjectValue(attrib, form.getValue()));
            }
        }
    }

    @Override
    public OperationResult<List<Modification>> process(boolean strict, ModifiedObjectType refType, Lifeform user, CarriedItem<?> model, List<Modification> unprocessed) {
        OperationResult<List<Modification>> ret = new OperationResult<List<Modification>>(unprocessed);
        logger.log(System.Logger.Level.DEBUG, "item mods {0}", ((PieceOfGear)model.getResolved()).getOutgoingModifications());
        PieceOfGear template = (PieceOfGear)model.getResolved();
        if (template == null) {
            logger.log(System.Logger.Level.ERROR, "No resolved template for ''{0}'' in item {1}", model.getKey(), model.getUuid());
            return new OperationResult<List<Modification>>();
        }
        template.getAttributes().stream().forEach(val -> {
            logger.log(System.Logger.Level.DEBUG, "Operate {0} ", val);
            try {
                this.process(model, (ItemAttributeDefinition)val);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error converting " + val, (Throwable)e);
            }
        });
        model.clearAutoFlags();
        ((PieceOfGear)model.getResolved()).getFlags().forEach(flag -> {
            logger.log(System.Logger.Level.INFO, "Add flag {0}", flag);
            model.setAutoFlag((String)flag, true);
        });
        if (model.getVariant() != null) {
            logger.log(System.Logger.Level.DEBUG, "Apply variant " + model.getVariantID());
            logger.log(System.Logger.Level.DEBUG, "-->" + model.getVariant().getAttributes());
            model.getVariant().getAttributes().stream().forEach(val -> this.process(model, (ItemAttributeDefinition)val));
            model.getVariant().getFlags().forEach(flag -> {
                logger.log(System.Logger.Level.INFO, "Add variant's flag {0}", flag);
                model.setAutoFlag((String)flag, true);
            });
        }
        return ret;
    }
}

