/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items;

import de.rpgframework.genericrpg.items.IItemAttribute;
import de.rpgframework.genericrpg.items.ItemAttributeDefinition;
import de.rpgframework.genericrpg.items.ItemAttributeValue;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.Modifyable;
import java.util.ArrayList;
import java.util.Arrays;

public class ItemAttributeObjectValue<A extends IItemAttribute>
extends ItemAttributeValue<A>
implements Modifyable {
    protected Object value;

    public ItemAttributeObjectValue(ItemAttributeDefinition def) {
        super(def.getModifyable());
        this.value = null;
    }

    public ItemAttributeObjectValue(IItemAttribute attrib, Object value) {
        super(attrib);
        this.value = value;
        if (value instanceof Float) {
            throw new RuntimeException("Use ItemAttributeFloatValue instead");
        }
        if (value instanceof String && ((String)value).contains("WEAPON_CLOSE_COMBAT")) {
            try {
                throw new RuntimeException("Invalid String: " + value);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    @Override
    public Object clone() {
        ItemAttributeObjectValue<A> copy = new ItemAttributeObjectValue<A>(this.attribute, this.value);
        copy.addModifications(new ArrayList<Modification>(this.incomingModifications));
        return copy;
    }

    public String toString() {
        String modS = "";
        String valS = String.valueOf(this.value);
        if (this.value instanceof int[]) {
            valS = Arrays.toString((int[])this.value);
        }
        if (this.getModifiedValue() instanceof int[]) {
            modS = Arrays.toString((int[])this.getModifiedValue());
        }
        return "OBJ:" + valS + "(" + modS + ") (" + this.incomingModifications + ")";
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        if (value instanceof Float) {
            throw new RuntimeException("Use ItemAttributeFloatValue instead");
        }
    }

    public <T> T getModifiedValue() {
        return this.attribute.calculateModifiedValue(this.value, this.incomingModifications);
    }
}

