/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.items.formula;

import de.rpgframework.genericrpg.ToDoElement;
import de.rpgframework.genericrpg.chargen.OperationResult;
import de.rpgframework.genericrpg.data.Lifeform;
import de.rpgframework.genericrpg.items.CarriedItem;
import de.rpgframework.genericrpg.items.CarriedItemProcessor;
import de.rpgframework.genericrpg.items.IItemAttribute;
import de.rpgframework.genericrpg.items.ItemAttributeDefinition;
import de.rpgframework.genericrpg.items.ItemAttributeFloatValue;
import de.rpgframework.genericrpg.items.ItemAttributeNumericalValue;
import de.rpgframework.genericrpg.items.ItemAttributeObjectValue;
import de.rpgframework.genericrpg.items.ItemAttributeValue;
import de.rpgframework.genericrpg.items.PieceOfGear;
import de.rpgframework.genericrpg.items.formula.FormulaElement;
import de.rpgframework.genericrpg.items.formula.FormulaImpl;
import de.rpgframework.genericrpg.items.formula.FormulaTool;
import de.rpgframework.genericrpg.items.formula.NumberElement;
import de.rpgframework.genericrpg.items.formula.StringElement;
import de.rpgframework.genericrpg.items.formula.VariableResolver;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import de.rpgframework.genericrpg.persist.IntegerConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ResolveFormulasStep
implements CarriedItemProcessor {
    protected static final System.Logger logger = System.getLogger(FormulaTool.class.getPackageName());

    private FormulaElement resolveVariable(CarriedItem model, IItemAttribute toSetAttrib, String var) {
        String tail = var.substring(1);
        if (!tail.startsWith("$")) {
            Object attrib = toSetAttrib.resolve(tail);
            logger.log(System.Logger.Level.INFO, var + " resolved to ItemAttribute " + attrib);
            ItemAttributeValue<?> val = model.getAttributeRaw((IItemAttribute)attrib);
            if (val != null) {
                logger.log(System.Logger.Level.INFO, var + " resolved to value " + val);
                if (val instanceof ItemAttributeNumericalValue) {
                    return new NumberElement(((ItemAttributeNumericalValue)val).getDistributed(), -1);
                }
                return new StringElement(val.toString(), -1);
            }
            logger.log(System.Logger.Level.WARNING, var + " cannot be resolved - attribute is not set");
            return null;
        }
        logger.log(System.Logger.Level.WARNING, "TODO: ask parent");
        System.exit(0);
        return null;
    }

    @Override
    public OperationResult<List<Modification>> process(boolean strict, ModifiedObjectType refType, Lifeform user, CarriedItem<?> model, List<Modification> unprocessed) {
        OperationResult<List<Modification>> ret = new OperationResult<List<Modification>>(unprocessed);
        PieceOfGear template = (PieceOfGear)model.getResolved();
        Collection<ItemAttributeDefinition> attribs = template.getAttributes(model.getVariantID());
        attribs.stream().forEach(val -> {
            IItemAttribute attrib = val.getModifyable();
            logger.log(System.Logger.Level.DEBUG, "Check attribute {0} with {1}", val, val.getFormula());
            FormulaImpl formula = (FormulaImpl)val.getFormula();
            if (!formula.isResolved()) {
                String resolvedString = FormulaTool.resolve(refType, formula, new VariableResolver(model, user));
                if (resolvedString == null) {
                    logger.log(System.Logger.Level.DEBUG, "Not resolved yet: " + formula);
                } else {
                    if (val.getLookupTable() != null) {
                        logger.log(System.Logger.Level.DEBUG, "Lookup '{0}' in table {1}", resolvedString, Arrays.toString(val.getLookupTable()));
                        String tmp = val.getLookupTable()[Integer.parseInt(resolvedString) - 1];
                        logger.log(System.Logger.Level.DEBUG, "Resolved {0} maps to {1}", resolvedString, tmp);
                        resolvedString = tmp;
                    }
                    logger.log(System.Logger.Level.DEBUG, "{0}: Handing ''{1}'' to converter {2}", attrib.name(), resolvedString, attrib.getConverter());
                    try {
                        IntegerConverter conv = attrib.getConverter();
                        if (conv == null) {
                            conv = new IntegerConverter();
                        }
                        Object resolved = conv.read(resolvedString);
                        logger.log(System.Logger.Level.INFO, val.getModifyable() + ": RAW " + val.getRawValue() + " ==> " + formula + " ==> " + resolved);
                        if (resolved instanceof Integer) {
                            ItemAttributeNumericalValue<IItemAttribute> aVal = new ItemAttributeNumericalValue<IItemAttribute>(val.getModifyable());
                            aVal.setDistributed((Integer)resolved);
                            model.setAttribute((IItemAttribute)aVal.getModifyable(), aVal);
                            logger.log(System.Logger.Level.DEBUG, "Set attribute " + val + " to numerical " + aVal + " because type is " + resolved.getClass());
                        } else if (resolved instanceof Float) {
                            ItemAttributeFloatValue<IItemAttribute> aVal = new ItemAttributeFloatValue<IItemAttribute>(val.getModifyable());
                            aVal.setDistributed(((Float)resolved).floatValue());
                            model.setAttribute((IItemAttribute)aVal.getModifyable(), aVal);
                            logger.log(System.Logger.Level.DEBUG, "Set attribute " + val + " to float " + aVal + " because type is " + resolved.getClass());
                        } else {
                            ItemAttributeObjectValue aVal = new ItemAttributeObjectValue((ItemAttributeDefinition)val);
                            aVal.setValue(resolved);
                            model.setAttribute((IItemAttribute)aVal.getModifyable(), aVal);
                            logger.log(System.Logger.Level.DEBUG, "Set attribute " + val + " to object " + aVal + " because type is " + resolved.getClass());
                        }
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Failed converting '" + resolvedString + "' using " + attrib.getConverter() + " of attribute " + attrib, (Throwable)e);
                        ret.addMessage(new ToDoElement(ToDoElement.Severity.STOPPER, "Failed converting '" + resolvedString + "' using " + attrib.getConverter() + " of attribute " + attrib));
                    }
                }
            }
        });
        for (Modification tmp : model.getIncomingModifications()) {
            logger.log(System.Logger.Level.INFO, model.getKey() + ": " + tmp + " Modification -> " + tmp);
            System.exit(1);
        }
        return ret;
    }
}

