/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.modification;

import de.rpgframework.genericrpg.Datable;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.data.IReferenceResolver;
import de.rpgframework.genericrpg.data.ReferenceException;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.prelle.simplepersist.Attribute;
import org.prelle.simplepersist.ElementList;
import org.prelle.simplepersist.Root;

@Root(name="itemmod")
public class DataItemModification
extends Modification
implements Cloneable,
Datable {
    @Attribute(name="ref", required=true)
    protected String ref;
    @Attribute
    protected String variant;
    @Attribute(name="choice", required=false)
    protected UUID choice;
    @Attribute
    protected boolean remove;
    @Attribute(name="options")
    protected String choiceOptions;
    @Attribute(name="mode", required=false)
    protected String restrictedToMode;
    @ElementList(type=Decision.class, entry="decision", inline=true)
    protected List<Decision> decisions = new ArrayList<Decision>();
    @Attribute
    protected int expCost;
    @Attribute
    protected Date date;
    @Attribute
    protected UUID id;

    public DataItemModification() {
    }

    public DataItemModification(ModifiedObjectType type, String ref) {
        this.type = type;
        this.ref = ref;
    }

    @Override
    public DataItemModification clone() {
        return (DataItemModification)super.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof DataItemModification) {
            DataItemModification other = (DataItemModification)o;
            if (!super.equals(other)) {
                return false;
            }
            if (this.ref != null && !this.ref.equals(other.ref)) {
                return false;
            }
            return this.variant == null || this.variant.equals(other.variant);
        }
        return false;
    }

    public String toString() {
        return this.type + ":" + this.ref + "(apply=" + this.apply + ",src=" + this.source + ")";
    }

    public String getKey() {
        return this.ref;
    }

    public void setKey(String key) {
        this.ref = key;
    }

    public <T> T getResolvedKey() {
        return this.type.resolve(this.ref);
    }

    public String[] getAsKeys() {
        return this.ref.trim().split(",");
    }

    public UUID getConnectedChoice() {
        return this.choice;
    }

    @Override
    public void validate() throws ReferenceException {
        if (this.ref.startsWith("CHOICE")) {
            return;
        }
        if ("ALL".equals(this.ref)) {
            return;
        }
        if (this.type == null) {
            throw new RuntimeException("Modification has no type= attribute: " + this);
        }
        Object val = this.getResolvedKey();
        if (val == null && this.source instanceof IReferenceResolver) {
            val = ((IReferenceResolver)this.source).resolveItem(this.ref);
        }
        if (val == null && this.ref.contains(",")) {
            for (String k : this.getAsKeys()) {
                val = this.type.resolve(k.trim());
                if (val != null) continue;
                throw new ReferenceException(this.type, k);
            }
        }
        if (val == null) {
            if (this.ref.equals(this.ref.toUpperCase())) {
                return;
            }
            throw new ReferenceException(this.type, this.ref);
        }
        for (Decision dec : this.decisions) {
            UUID uuid = dec.getChoiceUUID();
            if (uuid != null) continue;
            throw new RuntimeException("Decision without a choice UUID: " + this);
        }
    }

    public List<Decision> getDecisions() {
        return this.decisions;
    }

    public Decision getDecision(UUID uuid) {
        for (Decision dec : this.decisions) {
            if (!dec.getChoiceUUID().equals(uuid)) continue;
            return dec;
        }
        return null;
    }

    public void setDecisions(List<Decision> decisions) {
        this.decisions = decisions;
    }

    public String getChoiceOptions() {
        return this.choiceOptions;
    }

    public int getExpCost() {
        return this.expCost;
    }

    public void setExpCost(int expCost) {
        this.expCost = expCost;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public String getVariant() {
        return this.variant;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }
}

