/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.requirements;

import de.rpgframework.genericrpg.items.Formula;
import de.rpgframework.genericrpg.items.formula.FormulaTool;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import de.rpgframework.genericrpg.requirements.Requirement;
import java.util.UUID;
import org.prelle.simplepersist.Attribute;
import org.prelle.simplepersist.Root;

@Root(name="valuereq")
public class ValueRequirement
extends Requirement {
    @Attribute(name="choice", required=false)
    private UUID choice;
    @Attribute(name="variant", required=false)
    private String variantId;
    @Attribute(required=false)
    protected String value;
    private transient Formula parsedValue;
    @Attribute(required=false)
    protected String max;

    public ValueRequirement() {
    }

    public ValueRequirement(ModifiedObjectType type, String ref, int min) {
        this.type = type;
        this.reference = ref;
        this.value = String.valueOf(min);
    }

    public String toString() {
        return this.type + ":" + this.reference + ">=" + this.value;
    }

    public UUID getChoice() {
        return this.choice;
    }

    public int getValue() {
        return Integer.parseInt(this.value);
    }

    public int getMaxValue() {
        return this.max != null && !this.max.isBlank() ? Integer.parseInt(this.max) : 0;
    }

    public Formula getFormula() {
        if (this.parsedValue == null) {
            if (this.value != null) {
                this.parsedValue = FormulaTool.tokenize(this.value);
            } else if (this.max != null) {
                this.parsedValue = FormulaTool.tokenize(this.max);
            }
        }
        return this.parsedValue;
    }

    public void setFormula(Formula value) {
        this.parsedValue = value;
    }

    public String getRawValue() {
        return this.value;
    }

    public void setRawValue(String val) {
        this.value = val;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getVariantId() {
        return this.variantId;
    }
}

