/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg;

import de.rpgframework.genericrpg.PoolCalculation;
import de.rpgframework.genericrpg.ValueType;
import de.rpgframework.genericrpg.modification.CheckModification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Pool<T>
implements Cloneable {
    private Map<ValueType, List<PoolCalculation<T>>> poolsBySet = new HashMap<ValueType, List<PoolCalculation<T>>>();
    private List<CheckModification> checkMods;

    public Pool() {
        this.checkMods = new ArrayList<CheckModification>();
    }

    public Pool(T val) {
        this.addStep(ValueType.NATURAL, new PoolCalculation<T>(val, null));
        this.checkMods = new ArrayList<CheckModification>();
    }

    public Object clone() {
        Pool<T> cloned = new Pool<T>();
        for (Map.Entry<ValueType, List<PoolCalculation<T>>> entry : this.poolsBySet.entrySet()) {
            cloned.poolsBySet.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return cloned;
    }

    public void addStep(ValueType set, PoolCalculation<T> step) {
        List<PoolCalculation<T>> list = this.poolsBySet.get((Object)set);
        if (list == null) {
            list = new ArrayList<PoolCalculation<T>>();
            this.poolsBySet.put(set, list);
        }
        list.add(step);
    }

    public boolean hasSet(ValueType set) {
        return this.poolsBySet.containsKey((Object)set);
    }

    public List<PoolCalculation<T>> getCalculation(ValueType set) {
        if (this.poolsBySet.containsKey((Object)set)) {
            return this.poolsBySet.get((Object)set);
        }
        return new ArrayList<PoolCalculation<T>>();
    }

    public int getValue(ValueType set) {
        return (int)this.getCalculation(set).stream().collect(Collectors.summarizingInt(pc -> (Integer)pc.value)).getSum();
    }

    public boolean isModified() {
        return this.poolsBySet.containsKey((Object)ValueType.ARTIFICIAL) || this.poolsBySet.get((Object)ValueType.NATURAL).size() > 1;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int nat = 0;
        int aug = 0;
        if (this.poolsBySet.get((Object)ValueType.NATURAL) != null) {
            for (PoolCalculation<T> c : this.poolsBySet.get((Object)ValueType.NATURAL)) {
                if (!c.augment) {
                    nat += ((Integer)c.value).intValue();
                    continue;
                }
                aug += ((Integer)c.value).intValue();
            }
        }
        buf.append(String.valueOf(nat));
        if (aug > 0) {
            buf.append("(");
            buf.append(String.valueOf(nat + aug));
            buf.append(")");
        }
        if (this.poolsBySet.containsKey((Object)ValueType.ARTIFICIAL)) {
            int sum = this.poolsBySet.get((Object)ValueType.ARTIFICIAL).stream().mapToInt(pc -> (Integer)pc.value).sum();
            buf.append("|" + sum);
        }
        return buf.toString();
    }

    public String toExplainString() {
        if (this.poolsBySet.get((Object)ValueType.NATURAL) == null) {
            return "";
        }
        List ret = this.poolsBySet.get((Object)ValueType.NATURAL).stream().map(pc -> String.valueOf(pc.value) + " " + pc.source).collect(Collectors.toList());
        if (this.poolsBySet.containsKey((Object)ValueType.ARTIFICIAL)) {
            ret.add(" ---");
            ret.addAll(this.poolsBySet.get((Object)ValueType.ARTIFICIAL).stream().map(pc -> String.valueOf(pc.value) + " " + pc.source).collect(Collectors.toList()));
        }
        return String.join((CharSequence)"\n", ret);
    }

    public int getNatural() {
        if (this.poolsBySet.get((Object)ValueType.NATURAL) == null) {
            return 0;
        }
        return this.poolsBySet.get((Object)ValueType.NATURAL).stream().mapToInt(pc -> (Integer)pc.value).sum();
    }

    public void addAll(Pool<T> other) {
        for (ValueType type : other.poolsBySet.keySet()) {
            List<PoolCalculation<T>> list = this.poolsBySet.get((Object)type);
            List<PoolCalculation<T>> otherList = other.poolsBySet.get((Object)type);
            if (list == null) {
                this.poolsBySet.put(type, otherList);
                continue;
            }
            list.addAll(otherList);
        }
    }

    public void addCheckModification(CheckModification mod) {
        this.checkMods.add(mod);
    }
}

