/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg;

import de.rpgframework.MultiLanguageResourceBundle;
import de.rpgframework.genericrpg.ToDoElement;
import de.rpgframework.genericrpg.requirements.Requirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class Possible {
    public static final Possible TRUE = new Possible(true);
    public static final Possible FALSE = new Possible(false);
    private State state;
    private List<Requirement> req;
    private List<ToDoElement> messages = new ArrayList<ToDoElement>();

    public Possible(boolean value) {
        this.state = value ? State.POSSIBLE : State.IMPOSSIBLE;
        this.req = new ArrayList<Requirement>();
    }

    public Possible(List<Requirement> unfulfilledReq, Function<Requirement, String> resolver) {
        this.state = State.REQUIREMENTS_NOT_MET;
        this.req = unfulfilledReq;
        for (Requirement req : unfulfilledReq) {
            this.messages.add(new ToDoElement(ToDoElement.Severity.STOPPER, resolver.apply(req)));
        }
    }

    public Possible(Requirement ... unfulfilledReq) {
        this.state = State.REQUIREMENTS_NOT_MET;
        this.req = Arrays.asList(unfulfilledReq);
    }

    public Possible(Possible ... all) {
        this.state = State.POSSIBLE;
        this.req = new ArrayList<Requirement>();
        for (Possible tmp : all) {
            if (tmp.getState() == State.POSSIBLE) continue;
            if (tmp.getState().ordinal() > this.state.ordinal()) {
                this.state = tmp.state;
            }
            this.req.addAll(tmp.getUnfulfilledRequirements());
            this.messages.addAll(tmp.getI18NKey());
        }
    }

    public Possible(String i18n) {
        this.state = State.IMPOSSIBLE;
        this.messages.add(new ToDoElement(ToDoElement.Severity.STOPPER, i18n));
        this.req = new ArrayList<Requirement>();
    }

    public Possible(ToDoElement.Severity severity, MultiLanguageResourceBundle res, String key, Object ... params) {
        this.state = severity == ToDoElement.Severity.STOPPER ? State.IMPOSSIBLE : State.DECISIONS_MISSING;
        this.messages.add(new ToDoElement(severity, res, key, params));
        this.req = new ArrayList<Requirement>();
    }

    public Possible(State state, ToDoElement.Severity severity, MultiLanguageResourceBundle res, String key, Object ... params) {
        this.state = state;
        this.messages.add(new ToDoElement(severity, res, key, params));
        this.req = new ArrayList<Requirement>();
    }

    public Possible(boolean value, String i18n) {
        this.state = value ? State.POSSIBLE : State.IMPOSSIBLE;
        this.req = new ArrayList<Requirement>();
        this.messages.add(new ToDoElement(ToDoElement.Severity.STOPPER, i18n));
    }

    public Possible(State state, String i18n) {
        this.state = state;
        this.req = new ArrayList<Requirement>();
        this.messages.add(new ToDoElement(ToDoElement.Severity.STOPPER, i18n));
    }

    public List<Requirement> getUnfulfilledRequirements() {
        return this.req;
    }

    public State getState() {
        return this.state;
    }

    public boolean get() {
        return this.state.get();
    }

    public boolean getRequireDecisions() {
        if (this.state == State.DECISIONS_MISSING) {
            return false;
        }
        return this.state.value;
    }

    public String toString() {
        if (this.messages != null && !this.messages.isEmpty()) {
            return this.messages.get(0).getMessage();
        }
        return String.valueOf((Object)this.state);
    }

    public List<ToDoElement> getI18NKey() {
        return this.messages;
    }

    public ToDoElement getMostSevere() {
        if (this.messages.isEmpty()) {
            return null;
        }
        Collections.sort(this.messages);
        return this.messages.get(0);
    }

    public ToDoElement getMostSevereExcept(List<String> i18n) {
        if (this.messages.isEmpty()) {
            return null;
        }
        Collections.sort(this.messages);
        for (ToDoElement mess : this.messages) {
            if (mess.getKey() != null && i18n.contains(mess.getKey())) continue;
            return mess;
        }
        return null;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void addMessage(ToDoElement.Severity severity, MultiLanguageResourceBundle res, String key, Object ... params) {
        this.messages.add(new ToDoElement(severity, res, key, params));
    }

    public static enum State {
        POSSIBLE(true),
        DECISIONS_MISSING(true),
        REQUIREMENTS_NOT_MET(false),
        IMPOSSIBLE(false);

        boolean value;

        private State(boolean val) {
            this.value = val;
        }

        public boolean get() {
            return this.value;
        }
    }
}

