/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg;

import de.rpgframework.MultiLanguageResourceBundle;
import de.rpgframework.ResourceI18N;
import java.util.Locale;

public class ToDoElement
implements Comparable<ToDoElement> {
    private Severity severity;
    private String message;
    private String key;
    private MultiLanguageResourceBundle bundle;
    private Object[] params;

    public ToDoElement(Severity sev, String mess) {
        this.severity = sev;
        this.message = mess;
    }

    public ToDoElement(Severity sev, MultiLanguageResourceBundle bundle, String key) {
        this.severity = sev;
        this.bundle = bundle;
        this.key = key;
    }

    public ToDoElement(Severity sev, MultiLanguageResourceBundle bundle, String key, Object ... params) {
        this.severity = sev;
        this.bundle = bundle;
        this.key = key;
        this.params = params;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        if (this.key != null && this.bundle != null) {
            if (this.params == null) {
                return ResourceI18N.get((MultiLanguageResourceBundle)this.bundle, (Locale)Locale.getDefault(), (String)this.key);
            }
            return ResourceI18N.format((MultiLanguageResourceBundle)this.bundle, (Locale)Locale.getDefault(), (String)this.key, (Object[])this.params);
        }
        return this.message;
    }

    public String getMessage(Locale locale) {
        if (this.key != null && this.bundle != null) {
            return ResourceI18N.format((MultiLanguageResourceBundle)this.bundle, (Locale)locale, (String)this.key, (Object[])this.params);
        }
        return this.message;
    }

    public String toString() {
        return this.getMessage();
    }

    @Override
    public int compareTo(ToDoElement o) {
        return Integer.compare(this.severity.ordinal(), o.severity.ordinal());
    }

    public String getKey() {
        return this.key;
    }

    public static enum Severity {
        STOPPER,
        WARNING,
        INFO;

    }
}

