/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.chargen;

import de.rpgframework.character.CharacterIOException;
import de.rpgframework.character.RuleSpecificCharacterObject;
import de.rpgframework.genericrpg.ToDoElement;
import de.rpgframework.genericrpg.chargen.ControllerEvent;
import de.rpgframework.genericrpg.chargen.ControllerListener;
import de.rpgframework.genericrpg.chargen.DataSetMode;
import de.rpgframework.genericrpg.chargen.IRecommender;
import de.rpgframework.genericrpg.chargen.LevellingProfileController;
import de.rpgframework.genericrpg.chargen.RecommendingController;
import de.rpgframework.genericrpg.data.CommonCharacter;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.DataSet;
import de.rpgframework.genericrpg.data.IAttribute;
import de.rpgframework.genericrpg.data.RuleController;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public interface CharacterController<A extends IAttribute, M extends RuleSpecificCharacterObject<A, ?, ?, ?>> {
    public M getModel();

    public void setModel(M var1);

    public Locale getLocale();

    default public boolean showDataItem(DataItem item) {
        M model = this.getModel();
        if (item.getId().equals("evo_splatter")) {
            System.out.println("CharacterController.showDataItem: " + item.getId() + " (" + item.getLanguage() + ") in locale " + String.valueOf(this.getLocale()) + "  alt=" + String.valueOf(item.getLanguageAlternatives()));
        }
        if (item.getLanguage() != null && !this.getLocale().getLanguage().equals(item.getLanguage())) {
            return false;
        }
        if (model instanceof CommonCharacter) {
            CommonCharacter.DataSetControl dsCtrl = ((CommonCharacter)model).getDataSets();
            if (dsCtrl.mode == DataSetMode.SELECTED) {
                boolean found = false;
                for (DataSet set : item.getAssignedDataSets()) {
                    if (!dsCtrl.selected.contains(set.getID()) && !set.getID().equalsIgnoreCase("CORE")) continue;
                    found = true;
                }
                if (!found) {
                    return false;
                }
            }
        }
        return true;
    }

    public void addListener(ControllerListener var1);

    public void removeListener(ControllerListener var1);

    public boolean hasListener(ControllerListener var1);

    public Collection<ControllerListener> getListener();

    public void fireEvent(ControllerEvent var1, Object ... var2);

    public List<ToDoElement> getToDos();

    public void setAllowRunProcessor(boolean var1);

    public void runProcessors();

    public boolean save(byte[] var1) throws IOException, CharacterIOException;

    public RuleController getRuleController();

    public <T> RecommendingController<T> getRecommendingControllerFor(T var1);

    public LevellingProfileController getProfileController();

    public Optional<IRecommender<A>> getRecommender();
}

