/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.chargen;

import de.rpgframework.MultiLanguageResourceBundle;
import de.rpgframework.genericrpg.data.GenericRPGTools;
import java.util.Locale;

public class Rule {
    private MultiLanguageResourceBundle RES;
    private EffectOn what;
    private String id;
    private Type type;
    private String defaultValue;
    private Class<? extends Enum> enumToUse;
    private Enum defEnumValue;

    public Rule(EffectOn what, String id, Type type, MultiLanguageResourceBundle res, String defVal) {
        this.what = what;
        this.id = id;
        this.type = type;
        this.defaultValue = defVal;
        this.RES = res;
    }

    public <E extends Enum<E>> Rule(EffectOn what, String id, Class<E> enumToUse, MultiLanguageResourceBundle res, E defVal) {
        this.what = what;
        this.id = id;
        this.type = Type.ENUM;
        this.enumToUse = enumToUse;
        this.defEnumValue = defVal;
        this.defaultValue = defVal.name();
        this.RES = res;
    }

    public String getID() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public <T> T parseValue(String value) {
        switch (this.type.ordinal()) {
            case 0: {
                return (T)Boolean.valueOf(value);
            }
            case 1: {
                return (T)Integer.valueOf(value);
            }
            case 2: {
                return (T)Float.valueOf(value);
            }
            case 3: {
                return (T)Enum.valueOf(this.enumToUse, value);
            }
        }
        return null;
    }

    public String encodeString(Object value) {
        switch (this.type.ordinal()) {
            case 0: {
                return String.valueOf((Boolean)value);
            }
            case 1: {
                return String.valueOf((Integer)value);
            }
            case 2: {
                return String.valueOf((Float)value);
            }
            case 3: {
                return ((Enum)value).name();
            }
        }
        return null;
    }

    public String getName(Locale loc) {
        return this.RES.getString("rule." + this.id.toLowerCase(), loc);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean getDefaultAsBooleanValue() {
        return Boolean.parseBoolean(this.defaultValue);
    }

    public <E extends Enum> E getDefaultAsEnumValue() {
        return (E)this.defEnumValue;
    }

    public <E extends Enum<E>> Class<E> getEnumClassToUse() {
        return this.enumToUse;
    }

    public EffectOn getAffected() {
        return this.what;
    }

    public static enum EffectOn {
        CHARGEN,
        CAREER,
        COMMON,
        UI;

        private static MultiLanguageResourceBundle RES;

        public String getName() {
            return RES.getString("rulecategory." + this.name().toLowerCase());
        }

        static {
            RES = GenericRPGTools.RES;
        }
    }

    public static enum Type {
        BOOLEAN,
        INTEGER,
        FLOAT,
        ENUM;

    }
}

