/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.chargen.ai;

import de.rpgframework.genericrpg.chargen.ai.Weight;
import java.util.ArrayList;
import java.util.List;

public class RecommendationCache<T>
implements Comparable<RecommendationCache<T>> {
    T data;
    Weight level;
    int count;
    List<Object> sources;

    public RecommendationCache(T data, Weight level) {
        this.data = data;
        this.level = level;
        this.sources = new ArrayList<Object>();
        this.count = 1;
    }

    public void merge(RecommendationCache<T> other) {
        if (this.data != other.data) {
            throw new IllegalArgumentException("does not match");
        }
        if (other.level.ordinal() > this.level.ordinal()) {
            this.level = other.level;
            this.count = 1;
        } else if (other.level == this.level) {
            ++this.count;
        }
    }

    public String toString() {
        return String.valueOf(this.data) + "(" + String.valueOf((Object)this.level) + "," + this.count + ")";
    }

    @Override
    public int compareTo(RecommendationCache<T> other) {
        int cmp = this.level.compareTo(other.level);
        if (cmp != 0) {
            return cmp;
        }
        return Integer.valueOf(this.count).compareTo(other.count);
    }

    public Weight getLevel() {
        return this.level;
    }
}

