/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.core.RoleplayingSystem;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import java.util.HashMap;
import java.util.Map;
import org.prelle.simplepersist.StringValueConverter;

public class AttributeCodingRegistry {
    private static Map<FormulaKey, StringValueConverter<?>> converters = new HashMap();

    public static void addConverter(RoleplayingSystem rules, ModifiedObjectType type, String attrib, StringValueConverter<?> conv) {
        FormulaKey key = new FormulaKey(rules, type, attrib);
        converters.put(key, conv);
    }

    public static StringValueConverter<?> getConverter(RoleplayingSystem rules, ModifiedObjectType type, String attrib) {
        FormulaKey key = new FormulaKey(rules, type, attrib);
        return converters.get(key);
    }

    private static class FormulaKey {
        RoleplayingSystem rules;
        ModifiedObjectType type;
        String key;

        public FormulaKey(RoleplayingSystem r, ModifiedObjectType t, String k) {
            this.rules = r;
            this.type = t;
            this.key = k;
        }

        public String toString() {
            return String.valueOf(this.rules) + ":" + String.valueOf(this.type) + ":" + this.key;
        }

        public boolean equals(Object o) {
            if (o instanceof FormulaKey) {
                FormulaKey other = (FormulaKey)o;
                if (this.rules != other.rules) {
                    return false;
                }
                if (this.type != other.type) {
                    return false;
                }
                return this.key.equals(other.key);
            }
            return false;
        }
    }
}

