/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.genericrpg.ModifyableNumericalValue;
import de.rpgframework.genericrpg.Pool;
import de.rpgframework.genericrpg.ValueType;
import de.rpgframework.genericrpg.data.IAttribute;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModifyableImpl;
import de.rpgframework.genericrpg.modification.ValueModification;
import java.util.Optional;
import org.prelle.simplepersist.Attribute;

public class AttributeValue<A extends IAttribute>
extends ModifyableImpl
implements ModifyableNumericalValue<A> {
    @Attribute(name="id", required=true)
    private A id;
    @Attribute(name="value", required=true)
    private int distributed;
    @Attribute(name="start", required=false)
    private int start;
    private transient Pool<Integer> pool;

    public AttributeValue() {
    }

    public AttributeValue(A key) {
        this.id = key;
    }

    public AttributeValue(A key, int distributed) {
        this.id = key;
        this.distributed = distributed;
    }

    public String toString() {
        return String.valueOf(this.id) + ":" + this.distributed + "(" + String.valueOf(this.getIncomingModifications()) + ")";
    }

    @Override
    public int getDistributed() {
        return this.distributed;
    }

    @Override
    public void setDistributed(int value) {
        this.distributed = value;
    }

    @Override
    public A getModifyable() {
        return this.id;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public Optional<Integer> getMaximumBase() {
        for (Modification mod : this.incomingModifications) {
            ValueModification vMod;
            if (!(mod instanceof ValueModification) || (vMod = (ValueModification)mod).getSet() != ValueType.MAX || !vMod.isAbsolute()) continue;
            return Optional.of(this.getMaximum(vMod.getValue()));
        }
        return Optional.empty();
    }

    public int getMaximum(int base) {
        int max = base;
        for (Modification mod : this.incomingModifications) {
            ValueModification aMod;
            if (!(mod instanceof ValueModification) || (aMod = (ValueModification)mod).getResolvedKey() != this.id || aMod.getSet() != ValueType.MAX) continue;
            max += aMod.getValue();
        }
        return max;
    }

    public int getMaximum() {
        int base = this.getMaximumBase().orElse(0);
        return this.getMaximum(base);
    }

    public String getDisplayString() {
        int natural = this.getDistributed();
        int augmented = this.getModifiedValue(ValueType.AUGMENTED);
        int artificial = this.getModifiedValue(ValueType.ARTIFICIAL);
        StringBuffer buf = new StringBuffer(String.valueOf(natural));
        if (augmented != natural) {
            buf.append("(" + augmented + ")");
        }
        if (artificial > 0) {
            buf.append("|" + artificial);
        }
        return buf.toString();
    }

    @Override
    public Pool<Integer> getPool() {
        return this.pool;
    }

    public void setPool(Pool<Integer> pool) {
        this.pool = pool;
    }
}

