/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.genericrpg.data.ChoiceOption;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.items.Formula;
import de.rpgframework.genericrpg.items.formula.FormulaTool;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import de.rpgframework.genericrpg.persist.DistributeConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.prelle.simplepersist.AttribConvert;
import org.prelle.simplepersist.Attribute;
import org.prelle.simplepersist.ElementList;

public class Choice
implements Cloneable {
    @Attribute(required=true)
    protected ModifiedObjectType type;
    @Attribute(required=false)
    protected String ref;
    @Attribute(required=false)
    protected String max;
    private transient Formula parsedMax;
    @Attribute(name="options")
    protected String choiceOptions;
    @Attribute(required=true)
    protected UUID uuid;
    @Attribute(name="neg", required=false)
    private boolean negate;
    @Attribute
    private int count;
    @Attribute(name="distr", required=false)
    @AttribConvert(value=DistributeConverter.class)
    private Integer[] distribute;
    @Attribute(name="cost", required=false)
    @AttribConvert(value=DistributeConverter.class)
    private Integer[] costTable;
    @ElementList(type=ChoiceOption.class, entry="subOption", inline=true)
    protected List<ChoiceOption> subOptions = new ArrayList<ChoiceOption>();
    @Attribute
    private String i18n;
    private transient ComplexDataItem source;

    public Choice() {
    }

    public Choice(UUID uuid, ModifiedObjectType type) {
        this.uuid = uuid;
        this.type = type;
    }

    public Choice(UUID uuid, ModifiedObjectType type, String ref) {
        this.uuid = uuid;
        this.type = type;
        this.ref = ref;
    }

    public Choice(String options) {
        this.choiceOptions = options;
    }

    public Object clone() {
        Choice ret = new Choice();
        ret.type = this.type;
        ret.ref = this.ref;
        ret.choiceOptions = this.choiceOptions;
        ret.uuid = this.uuid;
        ret.negate = this.negate;
        ret.count = this.count;
        ret.distribute = this.distribute;
        ret.costTable = this.costTable;
        ret.subOptions = new ArrayList<ChoiceOption>(this.subOptions);
        ret.source = this.source;
        return ret;
    }

    public String toString() {
        if (this.distribute != null) {
            return String.valueOf(this.uuid) + "(" + String.valueOf(this.type) + ", ref=" + this.ref + ", options=" + this.choiceOptions + ", distr=" + Arrays.toString((Object[])this.distribute) + ")";
        }
        if (this.count > 0) {
            return String.valueOf(this.uuid) + "(" + String.valueOf(this.type) + ", ref=" + this.ref + ", options=" + this.choiceOptions + ", count=" + this.count + ")";
        }
        return String.valueOf(this.uuid) + "(" + String.valueOf(this.type) + ", ref=" + this.ref + ", options=" + this.choiceOptions + ")";
    }

    public ModifiedObjectType getChooseFrom() {
        return this.type;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getTypeReference() {
        return this.ref;
    }

    public void setTypeReference(String value) {
        this.ref = value;
    }

    public Integer[] getDistribute() {
        return this.distribute;
    }

    public String getRawChoiceOptions() {
        return this.choiceOptions;
    }

    public String[] getChoiceOptions() {
        if (this.choiceOptions == null) {
            return null;
        }
        if (this.choiceOptions.contains(",")) {
            return this.choiceOptions.trim().split(",");
        }
        return this.choiceOptions.trim().split(" ");
    }

    public void setChoiceOptions(String tokenizedString) {
        this.choiceOptions = tokenizedString;
    }

    public void setChoiceOptions(String[] values) {
        this.choiceOptions = String.join((CharSequence)",", values);
    }

    public boolean isNegated() {
        return this.negate;
    }

    public int getCount() {
        return this.count;
    }

    public ComplexDataItem getSource() {
        return this.source;
    }

    public void setSource(ComplexDataItem source) {
        this.source = source;
    }

    public List<ChoiceOption> getSubOptions() {
        return this.subOptions;
    }

    public ChoiceOption getSubOption(String subOption) {
        if (this.subOptions != null) {
            for (ChoiceOption opt : this.subOptions) {
                if (!opt.getId().equals(subOption)) continue;
                return opt;
            }
        }
        return null;
    }

    public String getI18nKey() {
        return this.i18n;
    }

    public void setI18NKey(String val) {
        this.i18n = val;
    }

    public Formula getMaxFormula() {
        if (this.parsedMax == null) {
            this.parsedMax = FormulaTool.tokenize(this.max);
        }
        return this.parsedMax;
    }

    public void setMaxFormula(Formula value) {
        this.parsedMax = value;
    }
}

