/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.DataItemTypeKey;
import de.rpgframework.genericrpg.data.DataSet;
import de.rpgframework.genericrpg.items.ItemAttributeDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import org.prelle.simplepersist.Attribute;
import org.prelle.simplepersist.ElementList;

@DataItemTypeKey(id="subOption")
public class ChoiceOption
extends ComplexDataItem {
    transient Choice choice;
    transient ComplexDataItem parent;
    @Attribute
    private float cost;
    @ElementList(entry="attrdef", type=ItemAttributeDefinition.class, inline=true)
    protected List<ItemAttributeDefinition> attributes = new ArrayList<ItemAttributeDefinition>();

    public float getCost() {
        return this.cost;
    }

    public void setCost(float cost) {
        this.cost = cost;
    }

    @Override
    public String getName(Locale locale) {
        if (this.parent == null) {
            return this.getLocalizedString(locale, "choice." + this.choice.ref + "." + this.id.toLowerCase());
        }
        String key = this.parent.getTypeString() + "." + this.parent.getId().toLowerCase() + ".choice." + this.choice.ref + "." + this.id.toLowerCase();
        return this.getLocalizedString(locale, key);
    }

    @Override
    public String getDescription(Locale locale) {
        String key = this.parent.getTypeString() + "." + this.parent.getId().toLowerCase() + ".choice." + this.choice.ref + "." + this.id.toLowerCase() + ".desc";
        if (this.parentSet == null) {
            System.err.println("No parent dataset for " + this.getTypeString() + ":" + this.id);
            return key;
        }
        DataSet set = null;
        int where = 0;
        try {
            set = this.getFirstParent(locale);
            if (set == null) {
                return "?No ParentSet?";
            }
            ++where;
            String foo = set.getResourceString(key, locale);
            return foo;
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace();
            if (where == 0) {
                logger.log(System.Logger.Level.ERROR, mre.toString());
            } else {
                logger.log(System.Logger.Level.ERROR, "Missing resource  " + mre.getKey() + "\t  for locale " + String.valueOf(locale) + " in " + set.getBaseBundleName());
            }
            return this.id;
        }
    }

    public Collection<ItemAttributeDefinition> getAttributes() {
        return this.attributes;
    }
}

