/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.genericrpg.data;

import de.rpgframework.HasName;
import de.rpgframework.genericrpg.data.Choice;
import de.rpgframework.genericrpg.data.ChoiceOption;
import de.rpgframework.genericrpg.data.ChoiceOrigin;
import de.rpgframework.genericrpg.data.DataErrorException;
import de.rpgframework.genericrpg.data.DataItem;
import de.rpgframework.genericrpg.data.Decision;
import de.rpgframework.genericrpg.data.ReferenceException;
import de.rpgframework.genericrpg.items.ItemFlag;
import de.rpgframework.genericrpg.items.PieceOfGearVariant;
import de.rpgframework.genericrpg.modification.DataItemModification;
import de.rpgframework.genericrpg.modification.Modification;
import de.rpgframework.genericrpg.modification.ModificationChoice;
import de.rpgframework.genericrpg.modification.ModificationList;
import de.rpgframework.genericrpg.modification.ModifiedObjectType;
import de.rpgframework.genericrpg.requirements.Requirement;
import de.rpgframework.genericrpg.requirements.RequirementList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.prelle.simplepersist.Attribute;
import org.prelle.simplepersist.Element;
import org.prelle.simplepersist.ElementList;

public class ComplexDataItem
extends DataItem
implements ChoiceOrigin {
    @ElementList(type=Choice.class, entry="choice")
    protected List<Choice> choices = new ArrayList<Choice>();
    @Element
    protected ModificationList modifications = new ModificationList();
    @Element
    protected RequirementList requires = new RequirementList();
    @Attribute(name="hasLevel")
    protected boolean hasLevel;
    @ElementList(entry="flag", type=String.class, inline=false)
    protected List<String> userSelectableFlags;

    public List<Choice> getChoices() {
        return new ArrayList<Choice>(this.choices);
    }

    public void addChoice(Choice choice) {
        if (!this.choices.contains(choice)) {
            this.choices.add(choice);
        }
    }

    @Override
    public Choice getChoice(UUID uuid) {
        if (this.choices != null) {
            for (Choice choice : this.choices) {
                if (choice.uuid != null && !choice.uuid.equals(uuid)) continue;
                return choice;
            }
        }
        return null;
    }

    public Choice getChoice(String ref) {
        if (this.choices != null) {
            for (Choice choice : this.choices) {
                if (choice.ref == null || !choice.ref.equals(ref)) continue;
                return choice;
            }
        }
        return null;
    }

    public Choice getChoice(ModifiedObjectType type) {
        if (this.choices != null) {
            for (Choice choice : this.choices) {
                if (choice.type != type) continue;
                return choice;
            }
        }
        return null;
    }

    public ModificationChoice getModificationChoice(UUID uuid) {
        for (Modification tmp : this.modifications) {
            if (!(tmp instanceof ModificationChoice) || !((ModificationChoice)tmp).getUUID().equals(uuid)) continue;
            return (ModificationChoice)tmp;
        }
        return null;
    }

    protected Choice getHardcodedChoice(UUID uuid) {
        return null;
    }

    public List<Modification> getOutgoingModifications() {
        return new ArrayList<Modification>(this.modifications);
    }

    public void addOutgoingModifications(List<Modification> value) {
        this.modifications.addAll(value);
    }

    public List<Requirement> getRequirements() {
        return this.requires;
    }

    public boolean hasLevel() {
        return this.hasLevel;
    }

    public void setHasLevel(boolean hasLevel) {
        this.hasLevel = hasLevel;
    }

    @Override
    public void validate() throws DataErrorException {
        DataItemModification mod;
        super.validate();
        for (Modification modification : this.modifications) {
            modification.setSource(this);
        }
        try {
            this.modifications.validate();
        }
        catch (ReferenceException e) {
            e.printStackTrace();
            throw new DataErrorException((DataItem)this, e.getError());
        }
        for (Modification modification : this.modifications) {
            if (!(modification instanceof DataItemModification)) continue;
            mod = (DataItemModification)modification;
            Object resolved = null;
            if (mod.getKey().startsWith("CHOICE:")) {
                try {
                    String uuid_s = mod.getKey().substring(7);
                    Iterator<Modification> iterator = UUID.fromString(uuid_s);
                }
                catch (Exception e) {
                    throw new DataErrorException((DataItem)this, "Referring to decision must be 'CHOICE:<uuid>'");
                }
            }
            if (!"CHOICE".equals(mod.getKey()) && !mod.getKey().startsWith("CHOICE:")) {
                resolved = mod.getReferenceType().resolve(mod.getKey());
            }
            ComplexDataItem item = resolved instanceof ComplexDataItem ? (ComplexDataItem)resolved : null;
            for (Decision dec : mod.getDecisions()) {
                if (dec.getValue() != null && dec.getValue().length() < 3) continue;
                UUID uuid = dec.getChoiceUUID();
                Choice choice = this.getChoice(uuid);
                if (choice == null && item != null) {
                    choice = item.getChoice(uuid);
                }
                if (choice == null) {
                    throw new DataErrorException((DataItem)this, "Decision for non-existing choice " + String.valueOf(uuid) + " in item " + String.valueOf(item));
                }
                try {
                    dec.setValueAsUUID(UUID.fromString(dec.getValue()));
                }
                catch (Exception exception) {
                    resolved = choice.getChooseFrom().resolve(dec.getValue());
                    if (resolved != null) continue;
                    throw new ReferenceException(choice.getChooseFrom(), dec.getValue(), this);
                }
            }
        }
        try {
            this.requires.validate();
        }
        catch (ReferenceException e) {
            throw new DataErrorException((DataItem)this, e.getError());
        }
        for (Modification modification : this.modifications) {
            if (this.parentItem != null) {
                modification.setSource(this.parentItem);
            } else {
                modification.setSource(this);
            }
            if (!(modification instanceof DataItemModification)) continue;
            mod = (DataItemModification)modification;
            if (!"CHOICE".equals(((DataItemModification)modification).getKey())) continue;
            if (mod.getConnectedChoice() == null) {
                throw new DataErrorException((DataItem)this, "Missing choice=\"<uuid>\"");
            }
            Choice choice = this.getChoice(mod.getConnectedChoice());
            if (choice == null) {
                throw new DataErrorException((DataItem)this, "No such choice " + String.valueOf(mod.getConnectedChoice()));
            }
            if (choice.getChooseFrom() == mod.getReferenceType()) continue;
            throw new DataErrorException((DataItem)this, "Modification type " + String.valueOf(mod.getReferenceType()) + " does not match choice type " + String.valueOf(choice.getChooseFrom()));
        }
        for (Choice choice : this.choices) {
            if (choice.getChoiceOptions() != null && choice.getChoiceOptions().length > 0 && choice.getTypeReference() == null) {
                choice.setTypeReference("CHOICE");
            }
            this.getChoiceName(choice, Locale.getDefault());
            if (!"SUBSELECT".equals(choice.getChooseFrom().toString())) continue;
            String key = this.getTypeString() + "." + this.id.toLowerCase() + ".choice." + choice.ref.toLowerCase();
            this.getLocalizedString(Locale.getDefault(), key);
            for (ChoiceOption opt : choice.getSubOptions()) {
                opt.parentSet = this.parentSet;
                opt.parent = this;
                opt.choice = choice;
                this.getLocalizedString(Locale.getDefault(), key + "." + opt.getId());
                this.getLocalizedString(Locale.getDefault(), key + "." + opt.getId() + ".desc");
                for (Modification m : opt.getOutgoingModifications()) {
                    m.setSource(this);
                    m.validate();
                }
            }
        }
    }

    public void resolveWithinItem(Modification m) {
    }

    public String getChoiceName(Choice choice, Locale loc) {
        String choiceID;
        ArrayList<String> keys = new ArrayList<String>();
        if (choice == null && this.hasLevel) {
            keys.add("choice.rating");
        }
        if (choice == null || choice.getChooseFrom() == null) {
            return "";
        }
        if (choice != null && choice.getI18nKey() != null) {
            keys.add("choice." + choice.getI18nKey());
        }
        String itemID = this.getTypeString() + "." + this.id.toLowerCase();
        String parentID = this.parentItem != null ? this.parentItem.getTypeString() + "." + this.parentItem.id.toLowerCase() : null;
        String typeID = "choice." + String.valueOf(choice.getChooseFrom()).toLowerCase();
        String string = choiceID = choice.getTypeReference() != null ? "choice." + choice.getTypeReference().toLowerCase() : "?";
        if (choice.getTypeReference() != null && choice.getTypeReference().equals("CHOICE")) {
            choiceID = String.valueOf(choice.getUUID());
        }
        if (this.parentItem != null) {
            keys.add(parentID + "." + itemID + "." + typeID + "." + choiceID);
            keys.add(parentID + "." + itemID + "." + typeID);
            keys.add(parentID + "." + itemID + "." + choiceID);
            keys.add(parentID + "." + choiceID);
        }
        keys.add(itemID + "." + typeID + "." + choiceID);
        keys.add(typeID + "." + choiceID);
        keys.add(itemID + "." + typeID);
        keys.add(typeID);
        keys.add(itemID + "." + choiceID);
        keys.add(choiceID);
        return this.getLocalizedString(loc, keys);
    }

    public String getVariantName(PieceOfGearVariant<?> variant, Locale loc) {
        String key = this.getTypeString() + "." + this.id.toLowerCase();
        key = key + ".variant." + variant.getId();
        return this.getLocalizedString(loc, key);
    }

    public String[] getChoiceOptionStrings(Choice choice, ChoiceOption opt, Locale loc) {
        if (opt == null) {
            throw new NullPointerException("ChoiceOption is null");
        }
        String key = this.getTypeString() + "." + this.id.toLowerCase() + ".choice." + choice.ref.toLowerCase();
        return new String[]{this.getLocalizedString(loc, key + "." + opt.getId()), this.getLocalizedString(loc, key + "." + opt.getId() + ".desc")};
    }

    public String getChoiceOptionString(Choice choice, HasName opt, Locale loc) {
        if (opt == null) {
            throw new NullPointerException("ChoiceOption is null");
        }
        String key = this.getTypeString() + "." + this.id.toLowerCase() + ".choice.";
        if (choice.ref != null) {
            key = key + choice.ref.toLowerCase();
        }
        return this.getLocalizedString(loc, key + "." + opt.getId());
    }

    public <T extends Enum> List<T> getUserSelectableFlags(Class<T> cls) {
        ArrayList<T> ret = new ArrayList<T>();
        for (String s : this.userSelectableFlags) {
            T tmp = Enum.valueOf(cls, s);
            ret.add(tmp);
        }
        return ret;
    }

    public boolean hasUserSelectableFlag(ItemFlag flag) {
        return this.userSelectableFlags.contains(flag.name());
    }

    public void addUserSelectableFlag(ItemFlag flag) {
        if (!this.userSelectableFlags.contains(flag.name())) {
            this.userSelectableFlags.add(flag.name());
        }
    }
}

